/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink;

import io.confluent.connect.jdbc.sink.metadata.DbTable;
import io.confluent.connect.jdbc.sink.metadata.DbTableColumn;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DbMetadataQueries {
    private static final Logger log = LoggerFactory.getLogger(DbMetadataQueries.class);

    public static boolean doesTableExist(Connection connection, String tableName) throws SQLException {
        String catalog = connection.getCatalog();
        DatabaseMetaData meta = connection.getMetaData();
        String product = meta.getDatabaseProductName();
        String schema = DbMetadataQueries.getSchema(connection, product);
        log.info("Checking table:{} exists for product:{} schema:{} catalog:", new Object[]{tableName, product, schema, catalog});
        try (ResultSet rs = meta.getTables(catalog, schema, tableName, new String[]{"TABLE"});){
            boolean exists = rs.next();
            log.info("product:{} schema:{} catalog:{} -- table:{} is {}", new Object[]{product, schema, catalog, tableName, exists ? "present" : "absent"});
            boolean bl = exists;
            return bl;
        }
    }

    public static DbTable getTableMetadata(Connection connection, String tableName) throws SQLException {
        DatabaseMetaData dbMetaData = connection.getMetaData();
        String product = dbMetaData.getDatabaseProductName();
        String catalog = connection.getCatalog();
        String schema = DbMetadataQueries.getSchema(connection, product);
        String tableNameForQuery = product.equalsIgnoreCase("oracle") ? tableName.toUpperCase() : tableName;
        log.info("Querying column metadata for product:{} schema:{} catalog:{} table:{}", new Object[]{product, schema, catalog, tableNameForQuery});
        HashSet<String> pkColumns = new HashSet<String>();
        try (ResultSet primaryKeysResultSet = dbMetaData.getPrimaryKeys(catalog, schema, tableNameForQuery);){
            while (primaryKeysResultSet.next()) {
                String colName = primaryKeysResultSet.getString("COLUMN_NAME");
                pkColumns.add(colName);
            }
        }
        ArrayList<DbTableColumn> columns = new ArrayList<DbTableColumn>();
        try (ResultSet columnsResultSet = dbMetaData.getColumns(catalog, schema, tableNameForQuery, null);){
            while (columnsResultSet.next()) {
                String colName = columnsResultSet.getString("COLUMN_NAME");
                int sqlType = columnsResultSet.getInt("DATA_TYPE");
                boolean isPk = pkColumns.contains(colName);
                boolean isNullable = !isPk && Objects.equals("YES", columnsResultSet.getString("IS_NULLABLE"));
                columns.add(new DbTableColumn(colName, isPk, isNullable, sqlType));
            }
        }
        return new DbTable(tableName, columns);
    }

    private static String getSchema(Connection connection, String product) throws SQLException {
        block29: {
            if (!product.equalsIgnoreCase("oracle")) break block29;
            Throwable throwable = null;
            try (Statement statement = connection.createStatement();){
                Throwable throwable2;
                ResultSet rs;
                block26: {
                    String string;
                    block27: {
                        block28: {
                            rs = statement.executeQuery("select sys_context('userenv','current_schema') x from dual");
                            throwable2 = null;
                            if (!rs.next()) break block26;
                            string = rs.getString("x").toUpperCase();
                            if (rs == null) break block27;
                            if (throwable2 == null) break block28;
                            try {
                                rs.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                            break block27;
                        }
                        rs.close();
                    }
                    return string;
                }
                try {
                    try {
                        try {
                            throw new SQLException("Failed to determine Oracle schema");
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (rs != null) {
                            if (throwable2 != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable x2) {
                                    throwable2.addSuppressed(x2);
                                }
                            } else {
                                rs.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
        }
        if (product.toLowerCase().startsWith("postgre")) {
            return connection.getSchema();
        }
        return null;
    }
}

