/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink;

import io.confluent.connect.jdbc.sink.DbStructure;
import io.confluent.connect.jdbc.sink.JdbcDbWriter;
import io.confluent.connect.jdbc.sink.JdbcSinkConfig;
import io.confluent.connect.jdbc.sink.dialect.DbDialect;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.RetriableException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSinkTask
extends SinkTask {
    private static final Logger log = LoggerFactory.getLogger(JdbcSinkTask.class);
    JdbcSinkConfig config;
    JdbcDbWriter writer;
    int remainingRetries;

    public void start(Map<String, String> props) {
        log.info("Starting task");
        this.config = new JdbcSinkConfig(props);
        this.initWriter();
        this.remainingRetries = this.config.maxRetries;
    }

    void initWriter() {
        DbDialect dbDialect = DbDialect.fromConnectionString(this.config.connectionUrl);
        DbStructure dbStructure = new DbStructure(dbDialect);
        log.info("Initializing writer using SQL dialect: {}", (Object)dbDialect.getClass().getSimpleName());
        this.writer = new JdbcDbWriter(this.config, dbDialect, dbStructure);
    }

    public void put(Collection<SinkRecord> records) {
        if (records.isEmpty()) {
            return;
        }
        SinkRecord first = records.iterator().next();
        int recordsCount = records.size();
        log.trace("Received {} records. First record kafka coordinates:({}-{}-{}). Writing them to the database...", new Object[]{recordsCount, first.topic(), first.kafkaPartition(), first.kafkaOffset()});
        try {
            this.writer.write(records);
        }
        catch (SQLException sqle) {
            log.warn("Write of {} records failed, remainingRetries={}", new Object[]{records.size(), this.remainingRetries, sqle});
            if (this.remainingRetries == 0) {
                throw new ConnectException((Throwable)sqle);
            }
            this.writer.closeQuietly();
            this.initWriter();
            --this.remainingRetries;
            this.context.timeout((long)this.config.retryBackoffMs);
            throw new RetriableException((Throwable)sqle);
        }
        this.remainingRetries = this.config.maxRetries;
    }

    public void flush(Map<TopicPartition, OffsetAndMetadata> map) {
    }

    public void stop() {
        log.info("Stopping task");
        this.writer.closeQuietly();
    }

    public String version() {
        return ((Object)((Object)this)).getClass().getPackage().getImplementationVersion();
    }
}

