/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink.dialect;

import io.confluent.connect.jdbc.sink.dialect.DbDialect;
import io.confluent.connect.jdbc.sink.dialect.StringBuilderUtil;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;

public class HanaDialect
extends DbDialect {
    public HanaDialect() {
        super("\"", "\"");
    }

    @Override
    protected String getSqlType(String schemaName, Map<String, String> parameters, Schema.Type type) {
        if (schemaName != null) {
            switch (schemaName) {
                case "org.apache.kafka.connect.data.Decimal": {
                    return "DECIMAL";
                }
                case "org.apache.kafka.connect.data.Date": {
                    return "DATE";
                }
                case "org.apache.kafka.connect.data.Time": {
                    return "DATE";
                }
                case "org.apache.kafka.connect.data.Timestamp": {
                    return "TIMESTAMP";
                }
            }
        }
        switch (type) {
            case INT8: {
                return "TINYINT";
            }
            case INT16: {
                return "SMALLINT";
            }
            case INT32: {
                return "INTEGER";
            }
            case INT64: {
                return "BIGINT";
            }
            case FLOAT32: {
                return "REAL";
            }
            case FLOAT64: {
                return "DOUBLE";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case STRING: {
                return "VARCHAR(1000)";
            }
            case BYTES: {
                return "BLOB";
            }
        }
        return super.getSqlType(schemaName, parameters, type);
    }

    @Override
    public String getCreateQuery(String tableName, Collection<SinkRecordField> fields) {
        return super.getCreateQuery(tableName, fields).replace("CREATE TABLE", "CREATE COLUMN TABLE");
    }

    @Override
    public List<String> getAlterTable(String tableName, Collection<SinkRecordField> fields) {
        StringBuilder builder = new StringBuilder("ALTER TABLE ");
        builder.append(this.escaped(tableName));
        builder.append(" ADD(");
        this.writeColumnsSpec(builder, fields);
        builder.append(")");
        return Collections.singletonList(builder.toString());
    }

    @Override
    public String getUpsertQuery(String table, Collection<String> keyCols, Collection<String> cols) {
        StringBuilder builder = new StringBuilder("UPSERT ");
        builder.append(this.escaped(table));
        builder.append("(");
        StringBuilderUtil.joinToBuilder(builder, ",", keyCols, cols, this.escaper());
        builder.append(") VALUES(");
        StringBuilderUtil.nCopiesToBuilder(builder, ",", "?", keyCols.size() + cols.size());
        builder.append(")");
        builder.append(" WITH PRIMARY KEY");
        return builder.toString();
    }
}

