/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink.dialect;

import io.confluent.connect.jdbc.sink.dialect.DbDialect;
import io.confluent.connect.jdbc.sink.dialect.StringBuilderUtil;
import java.util.Collection;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;

public class MySqlDialect
extends DbDialect {
    public MySqlDialect() {
        super("`", "`");
    }

    @Override
    protected String getSqlType(String schemaName, Map<String, String> parameters, Schema.Type type) {
        if (schemaName != null) {
            switch (schemaName) {
                case "org.apache.kafka.connect.data.Decimal": {
                    return "DECIMAL(65," + Integer.parseInt(parameters.get("scale")) + ")";
                }
                case "org.apache.kafka.connect.data.Date": {
                    return "DATE";
                }
                case "org.apache.kafka.connect.data.Time": {
                    return "TIME(3)";
                }
                case "org.apache.kafka.connect.data.Timestamp": {
                    return "TIMESTAMP(3)";
                }
            }
        }
        switch (type) {
            case INT8: {
                return "TINYINT";
            }
            case INT16: {
                return "SMALLINT";
            }
            case INT32: {
                return "INT";
            }
            case INT64: {
                return "BIGINT";
            }
            case FLOAT32: {
                return "FLOAT";
            }
            case FLOAT64: {
                return "DOUBLE";
            }
            case BOOLEAN: {
                return "TINYINT";
            }
            case STRING: {
                return "VARCHAR(256)";
            }
            case BYTES: {
                return "VARBINARY(1024)";
            }
        }
        return super.getSqlType(schemaName, parameters, type);
    }

    @Override
    public String getUpsertQuery(String table, Collection<String> keyCols, Collection<String> cols) {
        StringBuilder builder = new StringBuilder();
        builder.append("insert into ");
        builder.append(this.escaped(table));
        builder.append("(");
        StringBuilderUtil.joinToBuilder(builder, ",", keyCols, cols, this.escaper());
        builder.append(") values(");
        StringBuilderUtil.nCopiesToBuilder(builder, ",", "?", cols.size() + keyCols.size());
        builder.append(") on duplicate key update ");
        StringBuilderUtil.joinToBuilder(builder, ",", cols, new StringBuilderUtil.Transform<String>(){

            @Override
            public void apply(StringBuilder builder, String col) {
                builder.append(MySqlDialect.this.escaped(col)).append("=values(").append(MySqlDialect.this.escaped(col)).append(")");
            }
        });
        return builder.toString();
    }
}

