/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink.dialect;

import io.confluent.connect.jdbc.sink.dialect.DbDialect;
import io.confluent.connect.jdbc.sink.dialect.StringBuilderUtil;
import java.util.Collection;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;

public class PostgreSqlDialect
extends DbDialect {
    public PostgreSqlDialect() {
        super("\"", "\"");
    }

    @Override
    protected String getSqlType(String schemaName, Map<String, String> parameters, Schema.Type type) {
        if (schemaName != null) {
            switch (schemaName) {
                case "org.apache.kafka.connect.data.Decimal": {
                    return "DECIMAL";
                }
                case "org.apache.kafka.connect.data.Date": {
                    return "DATE";
                }
                case "org.apache.kafka.connect.data.Time": {
                    return "TIME";
                }
                case "org.apache.kafka.connect.data.Timestamp": {
                    return "TIMESTAMP";
                }
            }
        }
        switch (type) {
            case INT8: {
                return "SMALLINT";
            }
            case INT16: {
                return "SMALLINT";
            }
            case INT32: {
                return "INT";
            }
            case INT64: {
                return "BIGINT";
            }
            case FLOAT32: {
                return "REAL";
            }
            case FLOAT64: {
                return "DOUBLE PRECISION";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case STRING: {
                return "TEXT";
            }
            case BYTES: {
                return "BLOB";
            }
        }
        return super.getSqlType(schemaName, parameters, type);
    }

    @Override
    public String getUpsertQuery(String table, Collection<String> keyCols, Collection<String> cols) {
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.escaped(table));
        builder.append(" (");
        StringBuilderUtil.joinToBuilder(builder, ",", keyCols, cols, this.escaper());
        builder.append(") VALUES (");
        StringBuilderUtil.nCopiesToBuilder(builder, ",", "?", cols.size() + keyCols.size());
        builder.append(") ON CONFLICT (");
        StringBuilderUtil.joinToBuilder(builder, ",", keyCols, this.escaper());
        builder.append(") DO UPDATE SET ");
        StringBuilderUtil.joinToBuilder(builder, ",", cols, new StringBuilderUtil.Transform<String>(){

            @Override
            public void apply(StringBuilder builder, String col) {
                builder.append(PostgreSqlDialect.this.escaped(col)).append("=EXCLUDED.").append(PostgreSqlDialect.this.escaped(col));
            }
        });
        return builder.toString();
    }
}

