/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink.dialect;

import io.confluent.connect.jdbc.sink.dialect.DbDialect;
import io.confluent.connect.jdbc.sink.dialect.StringBuilderUtil;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;

public class SqliteDialect
extends DbDialect {
    public SqliteDialect() {
        super("`", "`");
    }

    @Override
    protected void formatColumnValue(StringBuilder builder, String schemaName, Map<String, String> schemaParameters, Schema.Type type, Object value) {
        if (schemaName != null) {
            switch (schemaName) {
                case "org.apache.kafka.connect.data.Date": 
                case "org.apache.kafka.connect.data.Time": 
                case "org.apache.kafka.connect.data.Timestamp": {
                    builder.append(((Date)value).getTime());
                    return;
                }
            }
        }
        super.formatColumnValue(builder, schemaName, schemaParameters, type, value);
    }

    @Override
    protected String getSqlType(String schemaName, Map<String, String> parameters, Schema.Type type) {
        if (schemaName != null) {
            switch (schemaName) {
                case "org.apache.kafka.connect.data.Decimal": 
                case "org.apache.kafka.connect.data.Date": 
                case "org.apache.kafka.connect.data.Time": 
                case "org.apache.kafka.connect.data.Timestamp": {
                    return "NUMERIC";
                }
            }
        }
        switch (type) {
            case BOOLEAN: 
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: {
                return "INTEGER";
            }
            case FLOAT32: 
            case FLOAT64: {
                return "REAL";
            }
            case STRING: {
                return "TEXT";
            }
            case BYTES: {
                return "BLOB";
            }
        }
        return super.getSqlType(schemaName, parameters, type);
    }

    @Override
    public List<String> getAlterTable(String tableName, Collection<SinkRecordField> fields) {
        ArrayList<String> queries = new ArrayList<String>(fields.size());
        for (SinkRecordField field : fields) {
            queries.addAll(super.getAlterTable(tableName, Collections.singleton(field)));
        }
        return queries;
    }

    @Override
    public String getUpsertQuery(String table, Collection<String> keyCols, Collection<String> cols) {
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT OR REPLACE INTO ");
        builder.append(this.escaped(table)).append("(");
        StringBuilderUtil.joinToBuilder(builder, ",", keyCols, cols, this.escaper());
        builder.append(") VALUES(");
        StringBuilderUtil.nCopiesToBuilder(builder, ",", "?", cols.size() + keyCols.size());
        builder.append(")");
        return builder.toString();
    }
}

