/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink.metadata;

import io.confluent.connect.jdbc.sink.JdbcSinkConfig;
import io.confluent.connect.jdbc.sink.metadata.SchemaPair;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;

public class FieldsMetadata {
    public final Set<String> keyFieldNames;
    public final Set<String> nonKeyFieldNames;
    public final Map<String, SinkRecordField> allFields;

    private FieldsMetadata(Set<String> keyFieldNames, Set<String> nonKeyFieldNames, Map<String, SinkRecordField> allFields) {
        if (keyFieldNames.size() + nonKeyFieldNames.size() != allFields.size() || !allFields.keySet().containsAll(keyFieldNames) || !allFields.keySet().containsAll(nonKeyFieldNames)) {
            throw new IllegalArgumentException(String.format("Validation fail -- keyFieldNames:%s nonKeyFieldNames:%s allFields:%s", keyFieldNames, nonKeyFieldNames, allFields));
        }
        this.keyFieldNames = keyFieldNames;
        this.nonKeyFieldNames = nonKeyFieldNames;
        this.allFields = allFields;
    }

    public static FieldsMetadata extract(String tableName, JdbcSinkConfig.PrimaryKeyMode pkMode, List<String> configuredPkFields, Set<String> fieldsWhitelist, SchemaPair schemaPair) {
        return FieldsMetadata.extract(tableName, pkMode, configuredPkFields, fieldsWhitelist, schemaPair.keySchema, schemaPair.valueSchema);
    }

    public static FieldsMetadata extract(String tableName, JdbcSinkConfig.PrimaryKeyMode pkMode, List<String> configuredPkFields, Set<String> fieldsWhitelist, Schema keySchema, Schema valueSchema) {
        Schema fieldSchema;
        if (valueSchema != null && valueSchema.type() != Schema.Type.STRUCT) {
            throw new ConnectException("Value schema must be of type Struct");
        }
        HashMap<String, SinkRecordField> allFields = new HashMap<String, SinkRecordField>();
        LinkedHashSet<String> keyFieldNames = new LinkedHashSet<String>();
        switch (pkMode) {
            case KAFKA: {
                if (configuredPkFields.isEmpty()) {
                    keyFieldNames.addAll(JdbcSinkConfig.DEFAULT_KAFKA_PK_NAMES);
                } else if (configuredPkFields.size() == 3) {
                    keyFieldNames.addAll(configuredPkFields);
                } else {
                    throw new ConnectException(String.format("PK mode for table '%s' is %s so there should either be no field names defined for defaults %s to be applicable, or exactly 3, defined fields are: %s", new Object[]{tableName, pkMode, JdbcSinkConfig.DEFAULT_KAFKA_PK_NAMES, configuredPkFields}));
                }
                Iterator it = keyFieldNames.iterator();
                String topicFieldName = (String)it.next();
                allFields.put(topicFieldName, new SinkRecordField(Schema.STRING_SCHEMA, topicFieldName, true));
                String partitionFieldName = (String)it.next();
                allFields.put(partitionFieldName, new SinkRecordField(Schema.INT32_SCHEMA, partitionFieldName, true));
                String offsetFieldName = (String)it.next();
                allFields.put(offsetFieldName, new SinkRecordField(Schema.INT64_SCHEMA, offsetFieldName, true));
                break;
            }
            case RECORD_KEY: {
                if (keySchema == null) {
                    throw new ConnectException(String.format("PK mode for table '%s' is %s, but record key schema is missing", new Object[]{tableName, pkMode}));
                }
                Schema.Type keySchemaType = keySchema.type();
                if (keySchemaType.isPrimitive()) {
                    if (configuredPkFields.size() != 1) {
                        throw new ConnectException(String.format("Need exactly one PK column defined since the key schema for records is a primitive type, defined columns are: %s", configuredPkFields));
                    }
                    String fieldName = configuredPkFields.get(0);
                    keyFieldNames.add(fieldName);
                    allFields.put(fieldName, new SinkRecordField(keySchema, fieldName, true));
                    break;
                }
                if (keySchemaType == Schema.Type.STRUCT) {
                    if (configuredPkFields.isEmpty()) {
                        for (Field keyField : keySchema.fields()) {
                            keyFieldNames.add(keyField.name());
                        }
                    } else {
                        for (String fieldName : configuredPkFields) {
                            Field keyField = keySchema.field(fieldName);
                            if (keyField != null) continue;
                            throw new ConnectException(String.format("PK mode for table '%s' is %s with configured PK fields %s, but record key schema does not contain field: %s", new Object[]{tableName, pkMode, configuredPkFields, fieldName}));
                        }
                        keyFieldNames.addAll(configuredPkFields);
                    }
                    for (String fieldName : keyFieldNames) {
                        fieldSchema = keySchema.field(fieldName).schema();
                        allFields.put(fieldName, new SinkRecordField(fieldSchema, fieldName, true));
                    }
                    break;
                }
                throw new ConnectException("Key schema must be primitive type or Struct, but is of type: " + keySchemaType);
            }
            case RECORD_VALUE: {
                if (valueSchema == null) {
                    throw new ConnectException(String.format("PK mode for table '%s' is %s, but record value schema is missing", new Object[]{tableName, pkMode}));
                }
                if (configuredPkFields.isEmpty()) {
                    for (Field keyField : valueSchema.fields()) {
                        keyFieldNames.add(keyField.name());
                    }
                } else {
                    for (String fieldName : configuredPkFields) {
                        if (valueSchema.field(fieldName) != null) continue;
                        throw new ConnectException(String.format("PK mode for table '%s' is %s with configured PK fields %s, but record value schema does not contain field: %s", new Object[]{tableName, pkMode, configuredPkFields, fieldName}));
                    }
                    keyFieldNames.addAll(configuredPkFields);
                }
                for (String fieldName : keyFieldNames) {
                    Schema fieldSchema2 = valueSchema.field(fieldName).schema();
                    allFields.put(fieldName, new SinkRecordField(fieldSchema2, fieldName, true));
                }
                break;
            }
        }
        LinkedHashSet<String> nonKeyFieldNames = new LinkedHashSet<String>();
        if (valueSchema != null) {
            for (Field field : valueSchema.fields()) {
                if (keyFieldNames.contains(field.name()) || !fieldsWhitelist.isEmpty() && !fieldsWhitelist.contains(field.name())) continue;
                nonKeyFieldNames.add(field.name());
                fieldSchema = field.schema();
                allFields.put(field.name(), new SinkRecordField(fieldSchema, field.name(), false));
            }
        }
        if (allFields.isEmpty()) {
            throw new ConnectException("No fields found using key and value schemas for table: " + tableName);
        }
        return new FieldsMetadata(keyFieldNames, nonKeyFieldNames, allFields);
    }

    public String toString() {
        return "FieldsMetadata{keyFieldNames=" + this.keyFieldNames + ", nonKeyFieldNames=" + this.nonKeyFieldNames + ", allFields=" + this.allFields + '}';
    }
}

