/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink.metadata;

import io.confluent.connect.jdbc.sink.DbMetadataQueries;
import io.confluent.connect.jdbc.sink.metadata.DbTable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMetadataLoadingCache {
    private static final Logger log = LoggerFactory.getLogger(TableMetadataLoadingCache.class);
    private final Map<String, DbTable> cache = new HashMap<String, DbTable>();

    public DbTable get(Connection connection, String tableName) throws SQLException {
        DbTable dbTable = this.cache.get(tableName);
        if (dbTable == null) {
            if (DbMetadataQueries.doesTableExist(connection, tableName)) {
                dbTable = DbMetadataQueries.getTableMetadata(connection, tableName);
                this.cache.put(tableName, dbTable);
            } else {
                return null;
            }
        }
        return dbTable;
    }

    public DbTable refresh(Connection connection, String tableName) throws SQLException {
        DbTable dbTable = DbMetadataQueries.getTableMetadata(connection, tableName);
        log.info("Updating cached metadata -- {}", (Object)dbTable);
        this.cache.put(dbTable.name, dbTable);
        return dbTable;
    }
}

