/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.source;

import io.confluent.connect.jdbc.source.JdbcSourceTask;
import java.io.IOException;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataConverter {
    private static final Logger log = LoggerFactory.getLogger(JdbcSourceTask.class);
    private static final ThreadLocal<Calendar> UTC_CALENDAR = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        }
    };

    public static Schema convertSchema(String tableName, ResultSetMetaData metadata) throws SQLException {
        SchemaBuilder builder = SchemaBuilder.struct().name(tableName);
        for (int col = 1; col <= metadata.getColumnCount(); ++col) {
            DataConverter.addFieldSchema(metadata, col, builder);
        }
        return builder.build();
    }

    public static Struct convertRecord(Schema schema, ResultSet resultSet) throws SQLException {
        ResultSetMetaData metadata = resultSet.getMetaData();
        Struct struct = new Struct(schema);
        for (int col = 1; col <= metadata.getColumnCount(); ++col) {
            try {
                DataConverter.convertFieldValue(resultSet, col, metadata.getColumnType(col), struct, metadata.getColumnLabel(col));
                continue;
            }
            catch (IOException e) {
                log.warn("Ignoring record because processing failed:", (Throwable)e);
                continue;
            }
            catch (SQLException e) {
                log.warn("Ignoring record due to SQL error:", (Throwable)e);
            }
        }
        return struct;
    }

    private static void addFieldSchema(ResultSetMetaData metadata, int col, SchemaBuilder builder) throws SQLException {
        String label = metadata.getColumnLabel(col);
        String name = metadata.getColumnName(col);
        String fieldName = label != null && !label.isEmpty() ? label : name;
        int sqlType = metadata.getColumnType(col);
        boolean optional = false;
        if (metadata.isNullable(col) == 1 || metadata.isNullable(col) == 2) {
            optional = true;
        }
        switch (sqlType) {
            case 0: {
                log.warn("JDBC type {} not currently supported", (Object)sqlType);
                break;
            }
            case 16: {
                if (optional) {
                    builder.field(fieldName, Schema.OPTIONAL_BOOLEAN_SCHEMA);
                    break;
                }
                builder.field(fieldName, Schema.BOOLEAN_SCHEMA);
                break;
            }
            case -7: 
            case -6: {
                if (optional) {
                    builder.field(fieldName, Schema.OPTIONAL_INT8_SCHEMA);
                    break;
                }
                builder.field(fieldName, Schema.INT8_SCHEMA);
                break;
            }
            case 5: {
                if (optional) {
                    builder.field(fieldName, Schema.OPTIONAL_INT16_SCHEMA);
                    break;
                }
                builder.field(fieldName, Schema.INT16_SCHEMA);
                break;
            }
            case 4: {
                if (optional) {
                    builder.field(fieldName, Schema.OPTIONAL_INT32_SCHEMA);
                    break;
                }
                builder.field(fieldName, Schema.INT32_SCHEMA);
                break;
            }
            case -5: {
                if (optional) {
                    builder.field(fieldName, Schema.OPTIONAL_INT64_SCHEMA);
                    break;
                }
                builder.field(fieldName, Schema.INT64_SCHEMA);
                break;
            }
            case 7: {
                if (optional) {
                    builder.field(fieldName, Schema.OPTIONAL_FLOAT32_SCHEMA);
                    break;
                }
                builder.field(fieldName, Schema.FLOAT32_SCHEMA);
                break;
            }
            case 6: 
            case 8: {
                if (optional) {
                    builder.field(fieldName, Schema.OPTIONAL_FLOAT64_SCHEMA);
                    break;
                }
                builder.field(fieldName, Schema.FLOAT64_SCHEMA);
                break;
            }
            case 2: 
            case 3: {
                SchemaBuilder fieldBuilder = Decimal.builder((int)metadata.getScale(col));
                if (optional) {
                    fieldBuilder.optional();
                }
                builder.field(fieldName, fieldBuilder.build());
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 70: 
            case 2005: 
            case 2009: 
            case 2011: {
                if (optional) {
                    builder.field(fieldName, Schema.OPTIONAL_STRING_SCHEMA);
                    break;
                }
                builder.field(fieldName, Schema.STRING_SCHEMA);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                if (optional) {
                    builder.field(fieldName, Schema.OPTIONAL_BYTES_SCHEMA);
                    break;
                }
                builder.field(fieldName, Schema.BYTES_SCHEMA);
                break;
            }
            case 91: {
                SchemaBuilder dateSchemaBuilder = Date.builder();
                if (optional) {
                    dateSchemaBuilder.optional();
                }
                builder.field(fieldName, dateSchemaBuilder.build());
                break;
            }
            case 92: {
                SchemaBuilder timeSchemaBuilder = Time.builder();
                if (optional) {
                    timeSchemaBuilder.optional();
                }
                builder.field(fieldName, timeSchemaBuilder.build());
                break;
            }
            case 93: {
                SchemaBuilder tsSchemaBuilder = Timestamp.builder();
                if (optional) {
                    tsSchemaBuilder.optional();
                }
                builder.field(fieldName, tsSchemaBuilder.build());
                break;
            }
            default: {
                log.warn("JDBC type {} not currently supported", (Object)sqlType);
            }
        }
    }

    private static void convertFieldValue(ResultSet resultSet, int col, int colType, Struct struct, String fieldName) throws SQLException, IOException {
        Object colValue;
        switch (colType) {
            case 0: {
                colValue = null;
                break;
            }
            case 16: {
                colValue = resultSet.getBoolean(col);
                break;
            }
            case -7: {
                colValue = resultSet.getByte(col);
                break;
            }
            case -6: {
                colValue = resultSet.getByte(col);
                break;
            }
            case 5: {
                colValue = resultSet.getShort(col);
                break;
            }
            case 4: {
                colValue = resultSet.getInt(col);
                break;
            }
            case -5: {
                colValue = resultSet.getLong(col);
                break;
            }
            case 7: {
                colValue = Float.valueOf(resultSet.getFloat(col));
                break;
            }
            case 6: 
            case 8: {
                colValue = resultSet.getDouble(col);
                break;
            }
            case 2: 
            case 3: {
                colValue = resultSet.getBigDecimal(col);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                colValue = resultSet.getString(col);
                break;
            }
            case -16: 
            case -15: 
            case -9: {
                colValue = resultSet.getNString(col);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                colValue = resultSet.getBytes(col);
                break;
            }
            case 91: {
                colValue = resultSet.getDate(col, UTC_CALENDAR.get());
                break;
            }
            case 92: {
                colValue = resultSet.getTime(col, UTC_CALENDAR.get());
                break;
            }
            case 93: {
                colValue = resultSet.getTimestamp(col, UTC_CALENDAR.get());
                break;
            }
            case 70: {
                URL url = resultSet.getURL(col);
                colValue = url != null ? url.toString() : null;
                break;
            }
            case 2004: {
                Blob blob = resultSet.getBlob(col);
                if (blob == null) {
                    colValue = null;
                    break;
                }
                if (blob.length() > Integer.MAX_VALUE) {
                    throw new IOException("Can't process BLOBs longer than Integer.MAX_VALUE");
                }
                colValue = blob.getBytes(1L, (int)blob.length());
                blob.free();
                break;
            }
            case 2005: 
            case 2011: {
                Clob clob;
                Clob clob2 = clob = colType == 2005 ? resultSet.getClob(col) : resultSet.getNClob(col);
                if (clob == null) {
                    colValue = null;
                    break;
                }
                if (clob.length() > Integer.MAX_VALUE) {
                    throw new IOException("Can't process BLOBs longer than Integer.MAX_VALUE");
                }
                colValue = clob.getSubString(1L, (int)clob.length());
                clob.free();
                break;
            }
            case 2009: {
                SQLXML xml = resultSet.getSQLXML(col);
                colValue = xml != null ? xml.getString() : null;
                break;
            }
            default: {
                return;
            }
        }
        struct.put(fieldName, resultSet.wasNull() ? null : colValue);
    }
}

