/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.source;

import io.confluent.connect.jdbc.util.CachedConnectionProvider;
import io.confluent.connect.jdbc.util.JdbcUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.connector.ConnectorContext;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMonitorThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(TableMonitorThread.class);
    private final CachedConnectionProvider cachedConnectionProvider;
    private final String schemaPattern;
    private final ConnectorContext context;
    private final CountDownLatch shutdownLatch;
    private final long pollMs;
    private Set<String> whitelist;
    private Set<String> blacklist;
    private List<String> tables;
    private Set<String> tableTypes;

    public TableMonitorThread(CachedConnectionProvider cachedConnectionProvider, ConnectorContext context, String schemaPattern, long pollMs, Set<String> whitelist, Set<String> blacklist, Set<String> tableTypes) {
        this.cachedConnectionProvider = cachedConnectionProvider;
        this.schemaPattern = schemaPattern;
        this.context = context;
        this.shutdownLatch = new CountDownLatch(1);
        this.pollMs = pollMs;
        this.whitelist = whitelist;
        this.blacklist = blacklist;
        this.tables = null;
        this.tableTypes = tableTypes;
    }

    @Override
    public void run() {
        while (this.shutdownLatch.getCount() > 0L) {
            try {
                if (this.updateTables()) {
                    this.context.requestTaskReconfiguration();
                }
            }
            catch (Exception e) {
                this.context.raiseError(e);
                throw e;
            }
            try {
                boolean shuttingDown = this.shutdownLatch.await(this.pollMs, TimeUnit.MILLISECONDS);
                if (!shuttingDown) continue;
                return;
            }
            catch (InterruptedException e) {
                log.error("Unexpected InterruptedException, ignoring: ", (Throwable)e);
            }
        }
    }

    public synchronized List<String> tables() {
        long started;
        long timeout = 10000L;
        long now = started = System.currentTimeMillis();
        while (this.tables == null && now - started < 10000L) {
            try {
                this.wait(10000L - (now - started));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            now = System.currentTimeMillis();
        }
        if (this.tables == null) {
            throw new ConnectException("Tables could not be updated quickly enough.");
        }
        return this.tables;
    }

    public void shutdown() {
        this.shutdownLatch.countDown();
    }

    private synchronized boolean updateTables() {
        List<String> filteredTables;
        List<String> tables;
        try {
            tables = JdbcUtils.getTables(this.cachedConnectionProvider.getValidConnection(), this.schemaPattern, this.tableTypes);
            log.debug("Got the following tables: " + Arrays.toString(tables.toArray()));
        }
        catch (SQLException e) {
            log.error("Error while trying to get updated table list, ignoring and waiting for next table poll interval", (Throwable)e);
            this.cachedConnectionProvider.closeQuietly();
            return false;
        }
        if (this.whitelist != null) {
            filteredTables = new ArrayList<String>(tables.size());
            for (String table : tables) {
                if (!this.whitelist.contains(table)) continue;
                filteredTables.add(table);
            }
        } else if (this.blacklist != null) {
            filteredTables = new ArrayList<String>(tables.size());
            for (String table : tables) {
                if (this.blacklist.contains(table)) continue;
                filteredTables.add(table);
            }
        } else {
            filteredTables = tables;
        }
        if (!filteredTables.equals(this.tables)) {
            log.debug("After filtering we got tables: " + Arrays.toString(filteredTables.toArray()));
            List<String> previousTables = this.tables;
            this.tables = filteredTables;
            this.notifyAll();
            return previousTables != null;
        }
        return false;
    }
}

