/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUtils {
    private static final Logger log = LoggerFactory.getLogger(JdbcUtils.class);
    public static final Set<String> DEFAULT_TABLE_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("TABLE")));
    private static final int GET_TABLES_TYPE_COLUMN = 4;
    private static final int GET_TABLES_NAME_COLUMN = 3;
    private static final int GET_COLUMNS_COLUMN_NAME = 4;
    private static final int GET_COLUMNS_IS_NULLABLE = 18;
    private static final int GET_COLUMNS_IS_AUTOINCREMENT = 23;
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMATTER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            return sdf;
        }
    };

    public static List<String> getTables(Connection conn, String schemaPattern) throws SQLException {
        return JdbcUtils.getTables(conn, schemaPattern, DEFAULT_TABLE_TYPES);
    }

    public static List<String> getTables(Connection conn, String schemaPattern, Set<String> types) throws SQLException {
        DatabaseMetaData metadata = conn.getMetaData();
        try (ResultSet rs = metadata.getTables(null, schemaPattern, "%", null);){
            ArrayList<String> tableNames = new ArrayList<String>();
            while (rs.next()) {
                if (!types.contains(rs.getString(4))) continue;
                String colName = rs.getString(3);
                if (metadata.getDatabaseProductName().equals("SQLite") && colName.startsWith("sqlite_")) continue;
                tableNames.add(colName);
            }
            ArrayList<String> arrayList = tableNames;
            return arrayList;
        }
    }

    public static String getAutoincrementColumn(Connection conn, String schemaPattern, String table) throws SQLException {
        String result = null;
        int matches = 0;
        try (ResultSet rs = conn.getMetaData().getColumns(null, schemaPattern, table, "%");){
            if (rs.getMetaData().getColumnCount() >= 23) {
                while (rs.next()) {
                    if (!rs.getString(23).equals("YES")) continue;
                    result = rs.getString(4);
                    ++matches;
                }
                String string = matches == 1 ? result : null;
                return string;
            }
        }
        log.trace("Falling back to SELECT detection of auto-increment column for {}:{}", (Object)conn, (Object)table);
        var6_6 = null;
        try (Statement stmt = conn.createStatement();){
            String quoteString = JdbcUtils.getIdentifierQuoteString(conn);
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + quoteString + table + quoteString + " LIMIT 1");
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 1; i < rsmd.getColumnCount(); ++i) {
                if (!rsmd.isAutoIncrement(i)) continue;
                result = rsmd.getColumnName(i);
                ++matches;
            }
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        return matches == 1 ? result : null;
    }

    public static boolean isColumnNullable(Connection conn, String schemaPattern, String table, String column) throws SQLException {
        try (ResultSet rs = conn.getMetaData().getColumns(null, schemaPattern, table, column);){
            if (rs.getMetaData().getColumnCount() > 18) {
                if (!rs.next()) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = rs.getString(18).equals("YES");
                return bl;
            }
        }
        return false;
    }

    public static String formatUTC(Date date) {
        return DATE_FORMATTER.get().format(date);
    }

    public static String getIdentifierQuoteString(Connection connection) throws SQLException {
        String quoteString = connection.getMetaData().getIdentifierQuoteString();
        quoteString = quoteString == null ? "" : quoteString;
        return quoteString;
    }

    public static String quoteString(String orig, String quote) {
        return quote + orig + quote;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Timestamp getCurrentTimeOnDB(Connection conn, Calendar cal) throws SQLException, ConnectException {
        String dbProduct = conn.getMetaData().getDatabaseProductName();
        String query = "Oracle".equals(dbProduct) ? "select CURRENT_TIMESTAMP from dual" : ("Apache Derby".equals(dbProduct) ? "values(CURRENT_TIMESTAMP)" : "select CURRENT_TIMESTAMP;");
        try (Statement stmt = conn.createStatement();){
            log.debug("executing query " + query + " to get current time from database");
            ResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                Timestamp timestamp = rs.getTimestamp(1, cal);
                return timestamp;
            }
            throw new ConnectException("Unable to get current time from DB using query " + query + " on database " + dbProduct);
        }
        catch (SQLException e) {
            log.error("Failed to get current time from DB using query " + query + " on database " + dbProduct, (Throwable)e);
            throw e;
        }
    }
}

