/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.dialect.DatabaseDialectProvider;
import io.confluent.connect.jdbc.dialect.GenericDatabaseDialect;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import io.confluent.connect.jdbc.util.ColumnId;
import io.confluent.connect.jdbc.util.ExpressionBuilder;
import io.confluent.connect.jdbc.util.IdentifierRules;
import io.confluent.connect.jdbc.util.TableId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.config.AbstractConfig;

public class SqliteDatabaseDialect
extends GenericDatabaseDialect {
    public SqliteDatabaseDialect(AbstractConfig config) {
        super(config, new IdentifierRules(".", "`", "`"));
    }

    @Override
    protected boolean includeTable(TableId table) {
        return !table.tableName().startsWith("sqlite_");
    }

    @Override
    protected String getSqlType(SinkRecordField field) {
        if (field.schemaName() != null) {
            switch (field.schemaName()) {
                case "org.apache.kafka.connect.data.Decimal": 
                case "org.apache.kafka.connect.data.Date": 
                case "org.apache.kafka.connect.data.Time": 
                case "org.apache.kafka.connect.data.Timestamp": {
                    return "NUMERIC";
                }
            }
        }
        switch (field.schemaType()) {
            case BOOLEAN: 
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: {
                return "INTEGER";
            }
            case FLOAT32: 
            case FLOAT64: {
                return "REAL";
            }
            case STRING: {
                return "TEXT";
            }
            case BYTES: {
                return "BLOB";
            }
        }
        return super.getSqlType(field);
    }

    @Override
    public List<String> buildAlterTable(TableId table, Collection<SinkRecordField> fields) {
        ArrayList<String> queries = new ArrayList<String>(fields.size());
        for (SinkRecordField field : fields) {
            queries.addAll(super.buildAlterTable(table, Collections.singleton(field)));
        }
        return queries;
    }

    @Override
    public String buildUpsertQueryStatement(TableId table, Collection<ColumnId> keyColumns, Collection<ColumnId> nonKeyColumns) {
        ExpressionBuilder builder = this.expressionBuilder();
        builder.append("INSERT OR REPLACE INTO ");
        builder.append(table);
        builder.append("(");
        builder.appendList().delimitedBy(",").transformedBy(ExpressionBuilder.columnNames()).of(keyColumns, nonKeyColumns);
        builder.append(") VALUES(");
        builder.appendMultiple(",", "?", keyColumns.size() + nonKeyColumns.size());
        builder.append(")");
        return builder.toString();
    }

    public static class Provider
    extends DatabaseDialectProvider.SubprotocolBasedProvider {
        public Provider() {
            super(SqliteDatabaseDialect.class.getSimpleName(), "sqlite");
        }

        @Override
        public DatabaseDialect create(AbstractConfig config) {
            return new SqliteDatabaseDialect(config);
        }
    }
}

