/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.util;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.util.TableDefinition;
import io.confluent.connect.jdbc.util.TableId;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDefinitions {
    private static final Logger log = LoggerFactory.getLogger(TableDefinitions.class);
    private final Map<TableId, TableDefinition> cache = new HashMap<TableId, TableDefinition>();
    private final DatabaseDialect dialect;

    public TableDefinitions(DatabaseDialect dialect) {
        this.dialect = dialect;
    }

    public TableDefinition get(Connection connection, TableId tableId) throws SQLException {
        TableDefinition dbTable = this.cache.get(tableId);
        if (dbTable == null && this.dialect.tableExists(connection, tableId) && (dbTable = this.dialect.describeTable(connection, tableId)) != null) {
            log.info("Setting metadata for table {} to {}", (Object)tableId, (Object)dbTable);
            this.cache.put(tableId, dbTable);
        }
        return dbTable;
    }

    public TableDefinition refresh(Connection connection, TableId tableId) throws SQLException {
        TableDefinition dbTable = this.dialect.describeTable(connection, tableId);
        log.info("Refreshing metadata for table {} to {}", (Object)tableId, (Object)dbTable);
        this.cache.put(dbTable.id(), dbTable);
        return dbTable;
    }
}

