/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.dialect.DatabaseDialectProvider;
import io.confluent.connect.jdbc.dialect.DropOptions;
import io.confluent.connect.jdbc.dialect.GenericDatabaseDialect;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import io.confluent.connect.jdbc.util.ColumnId;
import io.confluent.connect.jdbc.util.ExpressionBuilder;
import io.confluent.connect.jdbc.util.IdentifierRules;
import io.confluent.connect.jdbc.util.TableId;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.config.AbstractConfig;

public class OracleDatabaseDialect
extends GenericDatabaseDialect {
    public OracleDatabaseDialect(AbstractConfig config) {
        super(config, new IdentifierRules(".", "\"", "\""));
    }

    @Override
    protected String currentTimestampDatabaseQuery() {
        return "select CURRENT_TIMESTAMP from dual";
    }

    @Override
    protected String checkConnectionQuery() {
        return "SELECT 1 FROM DUAL";
    }

    @Override
    protected String getSqlType(SinkRecordField field) {
        if (field.schemaName() != null) {
            switch (field.schemaName()) {
                case "org.apache.kafka.connect.data.Decimal": {
                    return "NUMBER(*," + field.schemaParameters().get("scale") + ")";
                }
                case "org.apache.kafka.connect.data.Date": {
                    return "DATE";
                }
                case "org.apache.kafka.connect.data.Time": {
                    return "DATE";
                }
                case "org.apache.kafka.connect.data.Timestamp": {
                    return "TIMESTAMP";
                }
            }
        }
        switch (field.schemaType()) {
            case INT8: {
                return "NUMBER(3,0)";
            }
            case INT16: {
                return "NUMBER(5,0)";
            }
            case INT32: {
                return "NUMBER(10,0)";
            }
            case INT64: {
                return "NUMBER(19,0)";
            }
            case FLOAT32: {
                return "BINARY_FLOAT";
            }
            case FLOAT64: {
                return "BINARY_DOUBLE";
            }
            case BOOLEAN: {
                return "NUMBER(1,0)";
            }
            case STRING: {
                return "CLOB";
            }
            case BYTES: {
                return "BLOB";
            }
        }
        return super.getSqlType(field);
    }

    @Override
    public String buildDropTableStatement(TableId table, DropOptions options) {
        ExpressionBuilder builder = this.expressionBuilder();
        builder.append("DROP TABLE ");
        builder.append(table);
        if (options.cascade()) {
            builder.append(" CASCADE CONSTRAINTS");
        }
        String dropStatement = builder.toString();
        if (!options.ifExists()) {
            return dropStatement;
        }
        builder = this.expressionBuilder();
        builder.append("BEGIN ");
        builder.append("EXECUTE IMMEDIATE '" + dropStatement + "' ");
        builder.append("EXCEPTION ");
        builder.append("WHEN OTHERS THEN ");
        builder.append("IF SQLCODE != -942 THEN ");
        builder.append("    RAISE;");
        builder.append("END IF;");
        builder.append("END;");
        return builder.toString();
    }

    @Override
    public List<String> buildAlterTable(TableId table, Collection<SinkRecordField> fields) {
        ExpressionBuilder builder = this.expressionBuilder();
        builder.append("ALTER TABLE ");
        builder.append(table);
        builder.append(" ADD(");
        this.writeColumnsSpec(builder, fields);
        builder.append(")");
        return Collections.singletonList(builder.toString());
    }

    @Override
    public String buildUpsertQueryStatement(TableId table, Collection<ColumnId> keyColumns, Collection<ColumnId> nonKeyColumns) {
        ExpressionBuilder.Transform<ColumnId> transform = (builder, col) -> builder.append(table).append(".").appendColumnName(col.name()).append("=incoming.").appendColumnName(col.name());
        ExpressionBuilder builder2 = this.expressionBuilder();
        builder2.append("merge into ");
        builder2.append(table);
        builder2.append(" using (select ");
        builder2.appendList().delimitedBy(", ").transformedBy(ExpressionBuilder.columnNamesWithPrefix("? ")).of(keyColumns, nonKeyColumns);
        builder2.append(" FROM dual) incoming on(");
        builder2.appendList().delimitedBy(" and ").transformedBy(transform).of(keyColumns);
        builder2.append(")");
        if (nonKeyColumns != null && !nonKeyColumns.isEmpty()) {
            builder2.append(" when matched then update set ");
            builder2.appendList().delimitedBy(",").transformedBy(transform).of(nonKeyColumns);
        }
        builder2.append(" when not matched then insert(");
        builder2.appendList().delimitedBy(",").of(nonKeyColumns, keyColumns);
        builder2.append(") values(");
        builder2.appendList().delimitedBy(",").transformedBy(ExpressionBuilder.columnNamesWithPrefix("incoming.")).of(nonKeyColumns, keyColumns);
        builder2.append(")");
        return builder2.toString();
    }

    @Override
    protected String sanitizedUrl(String url) {
        return super.sanitizedUrl(url).replaceAll("(:thin:[^/]*)/([^@]*)@", "$1/****@").replaceAll("(:oci[^:]*:[^/]*)/([^@]*)@", "$1/****@");
    }

    public static class Provider
    extends DatabaseDialectProvider.SubprotocolBasedProvider {
        public Provider() {
            super(OracleDatabaseDialect.class.getSimpleName(), "oracle");
        }

        @Override
        public DatabaseDialect create(AbstractConfig config) {
            return new OracleDatabaseDialect(config);
        }
    }
}

