/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.sink;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.sink.JdbcSinkConfig;
import io.confluent.connect.jdbc.sink.metadata.FieldsMetadata;
import io.confluent.connect.jdbc.sink.metadata.SchemaPair;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkRecord;

public class PreparedStatementBinder
implements DatabaseDialect.StatementBinder {
    private final JdbcSinkConfig.PrimaryKeyMode pkMode;
    private final PreparedStatement statement;
    private final SchemaPair schemaPair;
    private final FieldsMetadata fieldsMetadata;
    private final JdbcSinkConfig.InsertMode insertMode;
    private final DatabaseDialect dialect;

    public PreparedStatementBinder(DatabaseDialect dialect, PreparedStatement statement, JdbcSinkConfig.PrimaryKeyMode pkMode, SchemaPair schemaPair, FieldsMetadata fieldsMetadata, JdbcSinkConfig.InsertMode insertMode) {
        this.dialect = dialect;
        this.pkMode = pkMode;
        this.statement = statement;
        this.schemaPair = schemaPair;
        this.fieldsMetadata = fieldsMetadata;
        this.insertMode = insertMode;
    }

    @Override
    public void bindRecord(SinkRecord record) throws SQLException {
        Struct valueStruct = (Struct)record.value();
        boolean isDelete = Objects.isNull(valueStruct);
        int index = 1;
        if (isDelete) {
            this.bindKeyFields(record, index);
        } else {
            switch (this.insertMode) {
                case INSERT: 
                case UPSERT: {
                    index = this.bindKeyFields(record, index);
                    this.bindNonKeyFields(record, valueStruct, index);
                    break;
                }
                case UPDATE: {
                    index = this.bindNonKeyFields(record, valueStruct, index);
                    this.bindKeyFields(record, index);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        this.statement.addBatch();
    }

    protected int bindKeyFields(SinkRecord record, int index) throws SQLException {
        switch (this.pkMode) {
            case NONE: {
                if (!this.fieldsMetadata.keyFieldNames.isEmpty()) {
                    throw new AssertionError();
                }
                break;
            }
            case KAFKA: {
                assert (this.fieldsMetadata.keyFieldNames.size() == 3);
                this.bindField(index++, Schema.STRING_SCHEMA, record.topic());
                this.bindField(index++, Schema.INT32_SCHEMA, record.kafkaPartition());
                this.bindField(index++, Schema.INT64_SCHEMA, record.kafkaOffset());
                break;
            }
            case RECORD_KEY: {
                if (this.schemaPair.keySchema.type().isPrimitive()) {
                    assert (this.fieldsMetadata.keyFieldNames.size() == 1);
                    this.bindField(index++, this.schemaPair.keySchema, record.key());
                    break;
                }
                for (String fieldName : this.fieldsMetadata.keyFieldNames) {
                    Field field = this.schemaPair.keySchema.field(fieldName);
                    this.bindField(index++, field.schema(), ((Struct)record.key()).get(field));
                }
                break;
            }
            case RECORD_VALUE: {
                for (String fieldName : this.fieldsMetadata.keyFieldNames) {
                    Field field = this.schemaPair.valueSchema.field(fieldName);
                    this.bindField(index++, field.schema(), ((Struct)record.value()).get(field));
                }
                break;
            }
            default: {
                throw new ConnectException("Unknown primary key mode: " + (Object)((Object)this.pkMode));
            }
        }
        return index;
    }

    protected int bindNonKeyFields(SinkRecord record, Struct valueStruct, int index) throws SQLException {
        for (String fieldName : this.fieldsMetadata.nonKeyFieldNames) {
            Field field = record.valueSchema().field(fieldName);
            this.bindField(index++, field.schema(), valueStruct.get(field));
        }
        return index;
    }

    protected void bindField(int index, Schema schema, Object value) throws SQLException {
        this.dialect.bindField(this.statement, index, schema, value);
    }
}

