/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.dialect.DatabaseDialectProvider;
import io.confluent.connect.jdbc.dialect.DropOptions;
import io.confluent.connect.jdbc.dialect.GenericDatabaseDialect;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import io.confluent.connect.jdbc.source.ColumnMapping;
import io.confluent.connect.jdbc.util.ColumnDefinition;
import io.confluent.connect.jdbc.util.ColumnId;
import io.confluent.connect.jdbc.util.DateTimeUtils;
import io.confluent.connect.jdbc.util.ExpressionBuilder;
import io.confluent.connect.jdbc.util.IdentifierRules;
import io.confluent.connect.jdbc.util.TableId;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerDatabaseDialect
extends GenericDatabaseDialect {
    private static final Logger log = LoggerFactory.getLogger(SqlServerDatabaseDialect.class);
    static final int DATETIMEOFFSET = -155;
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSSSSSS ZZZZZ";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSSS ZZZZZ");
    private static final int MSSQL_2016_VERSION = 13;
    private static final int PRE_MSSQL_2016_VERSION = 12;
    private static String DATETIME = "datetime";
    private boolean verifiedSqlServerTimestamp = false;
    private final boolean jtdsDriver = this.jdbcUrlInfo == null ? false : this.jdbcUrlInfo.subprotocol().matches("jtds");

    public SqlServerDatabaseDialect(AbstractConfig config) {
        super(config, new IdentifierRules(".", "[", "]"));
    }

    public boolean versionWithBreakingDatetimeChange() {
        String jdbcDatabaseMajorVersion = this.jdbcDriverInfo().productVersion().split("\\.")[0];
        int jdbcDatabaseMajorVersionValue = 12;
        try {
            jdbcDatabaseMajorVersionValue = Integer.parseInt(jdbcDatabaseMajorVersion);
        }
        catch (NumberFormatException e) {
            log.warn("Could not retrieve MSSQL Database version from JDBC.Version is used to verify timestamp mode compatibility with Sql Server Datetime columns. Defaulting to pre 2016 version.Error:" + e.toString());
        }
        return jdbcDatabaseMajorVersionValue >= 13;
    }

    @Override
    protected boolean useCatalog() {
        return true;
    }

    @Override
    protected String addFieldToSchema(ColumnDefinition columnDefn, SchemaBuilder builder, String fieldName, int sqlType, boolean optional) {
        switch (sqlType) {
            case -155: {
                return super.addFieldToSchema(columnDefn, builder, fieldName, 93, optional);
            }
        }
        return super.addFieldToSchema(columnDefn, builder, fieldName, sqlType, optional);
    }

    @Override
    protected DatabaseDialect.ColumnConverter columnConverterFor(ColumnMapping mapping, ColumnDefinition defn, int col, boolean isJdbc4) {
        switch (defn.type()) {
            case -155: {
                if (this.jtdsDriver) {
                    return rs -> this.convertDateTimeOffsetFromString(rs, col);
                }
                return rs -> this.convertDateTimeOffset(rs, col);
            }
        }
        return super.columnConverterFor(mapping, defn, col, isJdbc4);
    }

    protected Object convertDateTimeOffset(ResultSet rs, int col) throws SQLException {
        return rs.getTimestamp(col, DateTimeUtils.getTimeZoneCalendar(this.timeZone()));
    }

    protected Object convertDateTimeOffsetFromString(ResultSet rs, int col) throws SQLException {
        String value = rs.getString(col);
        return value == null ? null : SqlServerDatabaseDialect.dateTimeOffsetFrom(rs.getString(col), this.timeZone());
    }

    protected static Timestamp dateTimeOffsetFrom(String value, TimeZone timeZone) {
        ZonedDateTime zdt = ZonedDateTime.parse(value, DATE_TIME_FORMATTER);
        zdt = zdt.withZoneSameInstant(timeZone.toZoneId());
        return Timestamp.from(zdt.toInstant());
    }

    @Override
    protected String getSqlType(SinkRecordField field) {
        if (field.schemaName() != null) {
            switch (field.schemaName()) {
                case "org.apache.kafka.connect.data.Decimal": {
                    return "decimal(38," + field.schemaParameters().get("scale") + ")";
                }
                case "org.apache.kafka.connect.data.Date": {
                    return "date";
                }
                case "org.apache.kafka.connect.data.Time": {
                    return "time";
                }
                case "org.apache.kafka.connect.data.Timestamp": {
                    return "datetime2";
                }
            }
        }
        switch (field.schemaType()) {
            case INT8: {
                return "tinyint";
            }
            case INT16: {
                return "smallint";
            }
            case INT32: {
                return "int";
            }
            case INT64: {
                return "bigint";
            }
            case FLOAT32: {
                return "real";
            }
            case FLOAT64: {
                return "float";
            }
            case BOOLEAN: {
                return "bit";
            }
            case STRING: {
                if (field.isPrimaryKey()) {
                    return "varchar(900)";
                }
                return "varchar(max)";
            }
            case BYTES: {
                return "varbinary(max)";
            }
        }
        return super.getSqlType(field);
    }

    @Override
    public String buildDropTableStatement(TableId table, DropOptions options) {
        ExpressionBuilder builder = this.expressionBuilder();
        if (options.ifExists()) {
            builder.append("IF OBJECT_ID('");
            builder.append(table);
            builder.append(", 'U') IS NOT NULL");
        }
        builder.append("DROP TABLE ");
        builder.append(table);
        if (options.cascade()) {
            builder.append(" CASCADE");
        }
        return builder.toString();
    }

    @Override
    public List<String> buildAlterTable(TableId table, Collection<SinkRecordField> fields) {
        ExpressionBuilder builder = this.expressionBuilder();
        builder.append("ALTER TABLE ");
        builder.append(table);
        builder.append(" ADD");
        this.writeColumnsSpec(builder, fields);
        return Collections.singletonList(builder.toString());
    }

    @Override
    public String buildUpsertQueryStatement(TableId table, Collection<ColumnId> keyColumns, Collection<ColumnId> nonKeyColumns) {
        ExpressionBuilder builder = this.expressionBuilder();
        builder.append("merge into ");
        builder.append(table);
        builder.append(" with (HOLDLOCK) AS target using (select ");
        builder.appendList().delimitedBy(", ").transformedBy(ExpressionBuilder.columnNamesWithPrefix("? AS ")).of(keyColumns, nonKeyColumns);
        builder.append(") AS incoming on (");
        builder.appendList().delimitedBy(" and ").transformedBy(this::transformAs).of(keyColumns);
        builder.append(")");
        if (nonKeyColumns != null && !nonKeyColumns.isEmpty()) {
            builder.append(" when matched then update set ");
            builder.appendList().delimitedBy(",").transformedBy(this::transformUpdate).of(nonKeyColumns);
        }
        builder.append(" when not matched then insert (");
        builder.appendList().delimitedBy(", ").transformedBy(ExpressionBuilder.columnNames()).of(nonKeyColumns, keyColumns);
        builder.append(") values (");
        builder.appendList().delimitedBy(",").transformedBy(ExpressionBuilder.columnNamesWithPrefix("incoming.")).of(nonKeyColumns, keyColumns);
        builder.append(");");
        return builder.toString();
    }

    @Override
    public void validateSpecificColumnTypes(ResultSetMetaData rsMetadata, List<ColumnId> columns) throws ConnectException {
        List<ColumnId> timestampColumns = columns;
        if (this.verifiedSqlServerTimestamp) {
            return;
        }
        if (this.versionWithBreakingDatetimeChange()) {
            try {
                for (int i = 0; i < rsMetadata.getColumnCount(); ++i) {
                    if (!rsMetadata.getColumnTypeName(i + 1).equals(DATETIME)) continue;
                    for (ColumnId id : timestampColumns) {
                        if (!id.name().equals(rsMetadata.getColumnName(i + 1))) continue;
                        throw new ConnectException("A DATETIME column is configured for timestamp.column.name with Sql Server. DATETIME is not supported. Use DATETIME2 instead.");
                    }
                }
            }
            catch (SQLException sqlException) {
                throw new ConnectException("Failed to get table meta datawhile verifying Timestamp column type:", (Throwable)sqlException);
            }
        }
        this.verifiedSqlServerTimestamp = true;
    }

    @Override
    protected ColumnDefinition columnDefinition(ResultSet resultSet, ColumnId id, int jdbcType, String typeName, String classNameForType, ColumnDefinition.Nullability nullability, ColumnDefinition.Mutability mutability, int precision, int scale, Boolean signedNumbers, Integer displaySize, Boolean autoIncremented, Boolean caseSensitive, Boolean searchable, Boolean currency, Boolean isPrimaryKey) {
        try {
            String isAutoIncremented = resultSet.getString(22);
            if ("yes".equalsIgnoreCase(isAutoIncremented)) {
                autoIncremented = Boolean.TRUE;
            } else if ("no".equalsIgnoreCase(isAutoIncremented)) {
                autoIncremented = Boolean.FALSE;
            }
        }
        catch (SQLException e) {
            log.warn("Unable to get auto incrementing column information", (Throwable)e);
        }
        return super.columnDefinition(resultSet, id, jdbcType, typeName, classNameForType, nullability, mutability, precision, scale, signedNumbers, displaySize, autoIncremented, caseSensitive, searchable, currency, isPrimaryKey);
    }

    private void transformAs(ExpressionBuilder builder, ColumnId col) {
        builder.append("target.").appendColumnName(col.name()).append("=incoming.").appendColumnName(col.name());
    }

    private void transformUpdate(ExpressionBuilder builder, ColumnId col) {
        builder.appendColumnName(col.name()).append("=incoming.").appendColumnName(col.name());
    }

    @Override
    protected String sanitizedUrl(String url) {
        return super.sanitizedUrl(url).replaceAll("(?i)(;password=)[^;]*", "$1****").replaceAll("(?i)(;keyStoreSecret=)[^;]*", "$1****").replaceAll("(?i)(;gsscredential=)[^;]*", "$1****");
    }

    public static class Provider
    extends DatabaseDialectProvider.SubprotocolBasedProvider {
        public Provider() {
            super(SqlServerDatabaseDialect.class.getSimpleName(), "microsoft:sqlserver", "sqlserver", "jtds:sqlserver");
        }

        @Override
        public DatabaseDialect create(AbstractConfig config) {
            return new SqlServerDatabaseDialect(config);
        }
    }
}

