/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.source;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.source.SchemaMapping;
import io.confluent.connect.jdbc.util.TableId;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class TableQuerier
implements Comparable<TableQuerier> {
    private final Logger log = LoggerFactory.getLogger(TableQuerier.class);
    protected final DatabaseDialect dialect;
    protected final QueryMode mode;
    protected final String query;
    protected final String topicPrefix;
    protected final TableId tableId;
    protected long lastUpdate;
    protected Connection db;
    protected PreparedStatement stmt;
    protected ResultSet resultSet;
    protected SchemaMapping schemaMapping;
    private String loggedQueryString;

    public TableQuerier(DatabaseDialect dialect, QueryMode mode, String nameOrQuery, String topicPrefix) {
        this.dialect = dialect;
        this.mode = mode;
        this.tableId = mode.equals((Object)QueryMode.TABLE) ? dialect.parseTableIdentifier(nameOrQuery) : null;
        this.query = mode.equals((Object)QueryMode.QUERY) ? nameOrQuery : null;
        this.topicPrefix = topicPrefix;
        this.lastUpdate = 0L;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public PreparedStatement getOrCreatePreparedStatement(Connection db) throws SQLException {
        if (this.stmt != null) {
            return this.stmt;
        }
        this.createPreparedStatement(db);
        return this.stmt;
    }

    protected abstract void createPreparedStatement(Connection var1) throws SQLException;

    public boolean querying() {
        return this.resultSet != null;
    }

    public void maybeStartQuery(Connection db) throws SQLException {
        if (this.resultSet == null) {
            this.db = db;
            this.stmt = this.getOrCreatePreparedStatement(db);
            this.resultSet = this.executeQuery();
            String schemaName = this.tableId != null ? this.tableId.tableName() : null;
            this.schemaMapping = SchemaMapping.create(schemaName, this.resultSet.getMetaData(), this.dialect);
        }
    }

    protected abstract ResultSet executeQuery() throws SQLException;

    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    public abstract SourceRecord extractRecord() throws SQLException;

    public void reset(long now, boolean resetOffset) {
        this.closeResultSetQuietly();
        this.closeStatementQuietly();
        this.releaseLocksQuietly();
        this.schemaMapping = null;
        this.lastUpdate = now;
    }

    private void releaseLocksQuietly() {
        if (this.db != null) {
            try {
                this.db.commit();
            }
            catch (SQLException e) {
                this.log.warn("Error while committing read transaction, database locks may still be held", (Throwable)e);
            }
        }
        this.db = null;
    }

    private void closeStatementQuietly() {
        if (this.stmt != null) {
            try {
                this.stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.stmt = null;
    }

    private void closeResultSetQuietly() {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.resultSet = null;
    }

    protected void recordQuery(String query) {
        if (query != null && !query.equals(this.loggedQueryString)) {
            this.log.info("Begin using SQL query: {}", (Object)query);
            this.loggedQueryString = query;
        }
    }

    @Override
    public int compareTo(TableQuerier other) {
        if (this.lastUpdate < other.lastUpdate) {
            return -1;
        }
        if (this.lastUpdate > other.lastUpdate) {
            return 1;
        }
        return this.tableId.compareTo(other.tableId);
    }

    public static enum QueryMode {
        TABLE,
        QUERY;

    }
}

