/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.util;

import io.confluent.connect.jdbc.util.ColumnId;
import io.confluent.connect.jdbc.util.TableId;
import java.util.Objects;

public class ColumnDefinition {
    private final ColumnId id;
    private final String typeName;
    private final int jdbcType;
    private final int displaySize;
    private final int precision;
    private final int scale;
    private final boolean autoIncremented;
    private final boolean caseSensitive;
    private final boolean searchable;
    private final boolean currency;
    private final boolean signedNumbers;
    private final boolean isPrimaryKey;
    private final Nullability nullability;
    private final Mutability mutability;
    private final String classNameForType;

    public ColumnDefinition(ColumnId id, int jdbcType, String typeName, String classNameForType, Nullability nullability, Mutability mutability, int precision, int scale, boolean signedNumbers, int displaySize, boolean autoIncremented, boolean caseSensitive, boolean searchable, boolean currency, boolean isPrimaryKey) {
        this.id = id;
        this.typeName = typeName;
        this.jdbcType = jdbcType;
        this.displaySize = displaySize;
        this.precision = precision;
        this.scale = scale;
        this.autoIncremented = autoIncremented;
        this.caseSensitive = caseSensitive;
        this.searchable = searchable;
        this.currency = currency;
        this.signedNumbers = signedNumbers;
        this.nullability = nullability != null ? nullability : Nullability.UNKNOWN;
        this.mutability = mutability != null ? mutability : Mutability.MAYBE_WRITABLE;
        this.classNameForType = classNameForType;
        this.isPrimaryKey = isPrimaryKey;
    }

    public boolean isAutoIncrement() {
        return this.autoIncremented;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public boolean isCurrency() {
        return this.currency;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public Nullability nullability() {
        return this.nullability;
    }

    public boolean isOptional() {
        return this.nullability == Nullability.NULL || this.nullability == Nullability.UNKNOWN;
    }

    public boolean isSignedNumber() {
        return this.signedNumbers;
    }

    public int displaySize() {
        return this.displaySize;
    }

    public ColumnId id() {
        return this.id;
    }

    public TableId tableId() {
        return this.id.tableId();
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }

    public int type() {
        return this.jdbcType;
    }

    public String typeName() {
        return this.typeName;
    }

    public Mutability mutability() {
        return this.mutability;
    }

    public String classNameForType() {
        return this.classNameForType;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ColumnDefinition) {
            ColumnDefinition that = (ColumnDefinition)obj;
            return Objects.equals(this.id, that.id) && this.jdbcType == that.jdbcType && this.displaySize == that.displaySize && this.precision == that.precision && this.scale == that.scale && this.autoIncremented == that.autoIncremented && this.caseSensitive == that.caseSensitive && this.searchable == that.searchable && this.currency == that.currency && this.signedNumbers == that.signedNumbers && this.nullability == that.nullability && Objects.equals(this.typeName, that.typeName) && Objects.equals(this.classNameForType, that.classNameForType) && Objects.equals(this.isPrimaryKey, that.isPrimaryKey);
        }
        return false;
    }

    public String toString() {
        return "Column{'" + this.id.name() + '\'' + ", isPrimaryKey=" + this.isPrimaryKey + ", allowsNull=" + this.isOptional() + ", sqlType=" + this.typeName + '}';
    }

    public ColumnDefinition forTable(TableId tableId) {
        if (this.tableId().equals(tableId)) {
            return this;
        }
        ColumnId newId = new ColumnId(tableId, this.id().name());
        return new ColumnDefinition(newId, this.jdbcType, this.typeName, this.classNameForType, this.nullability, this.mutability, this.precision, this.scale, this.signedNumbers, this.displaySize, this.autoIncremented, this.caseSensitive, this.searchable, this.currency, this.isPrimaryKey);
    }

    public ColumnDefinition asPartOfPrimaryKey(boolean isPrimaryKey) {
        if (isPrimaryKey == this.isPrimaryKey()) {
            return this;
        }
        return new ColumnDefinition(this.id, this.jdbcType, this.typeName, this.classNameForType, this.nullability, this.mutability, this.precision, this.scale, this.signedNumbers, this.displaySize, this.autoIncremented, this.caseSensitive, this.searchable, this.currency, isPrimaryKey);
    }

    public static enum Mutability {
        READ_ONLY,
        MAYBE_WRITABLE,
        WRITABLE,
        UNKNOWN;

    }

    public static enum Nullability {
        NULL,
        NOT_NULL,
        UNKNOWN;

    }
}

