/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jdbc.dialect;

import io.confluent.connect.jdbc.dialect.DatabaseDialect;
import io.confluent.connect.jdbc.dialect.DatabaseDialectProvider;
import io.confluent.connect.jdbc.dialect.GenericDatabaseDialect;
import io.confluent.connect.jdbc.sink.metadata.SinkRecordField;
import io.confluent.connect.jdbc.source.ColumnMapping;
import io.confluent.connect.jdbc.util.ColumnDefinition;
import io.confluent.connect.jdbc.util.ColumnId;
import io.confluent.connect.jdbc.util.ExpressionBuilder;
import io.confluent.connect.jdbc.util.IdentifierRules;
import io.confluent.connect.jdbc.util.TableId;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSqlDatabaseDialect
extends GenericDatabaseDialect {
    private static final Logger log = LoggerFactory.getLogger(PostgreSqlDatabaseDialect.class);
    volatile int maxIdentifierLength = 0;
    static final String JSON_TYPE_NAME = "json";
    static final String JSONB_TYPE_NAME = "jsonb";

    public PostgreSqlDatabaseDialect(AbstractConfig config) {
        super(config, new IdentifierRules(".", "\"", "\""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        Connection result = super.getConnection();
        PostgreSqlDatabaseDialect postgreSqlDatabaseDialect = this;
        synchronized (postgreSqlDatabaseDialect) {
            if (this.maxIdentifierLength <= 0) {
                this.maxIdentifierLength = PostgreSqlDatabaseDialect.computeMaxIdentifierLength(result);
            }
        }
        return result;
    }

    static int computeMaxIdentifierLength(Connection connection) {
        int result;
        String warningMessage = "Unable to query database for maximum table name length; the connector may fail to write to tables with long names";
        String nameLengthQuery = "SELECT length(repeat('1234567890', 1000)::NAME);";
        try (ResultSet rs = connection.createStatement().executeQuery(nameLengthQuery);){
            if (rs.next()) {
                result = rs.getInt(1);
                if (result <= 0) {
                    log.warn("Cannot accommodate maximum table name length of {} as it is not positive; table name truncation will be disabled, and the connector may fail to write to tables with long names", (Object)result);
                    result = Integer.MAX_VALUE;
                } else {
                    log.info("Maximum table name length for database is {} bytes", (Object)result);
                }
            } else {
                log.warn(warningMessage);
                result = Integer.MAX_VALUE;
            }
        }
        catch (SQLException e) {
            log.warn(warningMessage, (Throwable)e);
            result = Integer.MAX_VALUE;
        }
        return result;
    }

    @Override
    public TableId parseTableIdentifier(String fqn) {
        TableId result = super.parseTableIdentifier(fqn);
        if (this.maxIdentifierLength > 0 && result.tableName().length() > this.maxIdentifierLength) {
            String newTableName = result.tableName().substring(0, this.maxIdentifierLength);
            log.debug("Truncating table name from {} to {} in order to respect maximum name length", (Object)result.tableName(), (Object)newTableName);
            result = new TableId(result.catalogName(), result.schemaName(), newTableName);
        }
        return result;
    }

    @Override
    protected void initializePreparedStatement(PreparedStatement stmt) throws SQLException {
        super.initializePreparedStatement(stmt);
        log.trace("Initializing PreparedStatement fetch direction to FETCH_FORWARD for '{}'", (Object)stmt);
        stmt.setFetchDirection(1000);
    }

    @Override
    public String addFieldToSchema(ColumnDefinition columnDefn, SchemaBuilder builder) {
        String fieldName = this.fieldNameFor(columnDefn);
        switch (columnDefn.type()) {
            case -7: {
                boolean optional = columnDefn.isOptional();
                int numBits = columnDefn.precision();
                Schema schema = numBits <= 1 ? (optional ? Schema.OPTIONAL_BOOLEAN_SCHEMA : Schema.BOOLEAN_SCHEMA) : (numBits <= 8 ? (optional ? Schema.OPTIONAL_INT8_SCHEMA : Schema.INT8_SCHEMA) : (optional ? Schema.OPTIONAL_BYTES_SCHEMA : Schema.BYTES_SCHEMA));
                builder.field(fieldName, schema);
                return fieldName;
            }
            case 1111: {
                if (!this.isJsonType(columnDefn)) break;
                builder.field(fieldName, columnDefn.isOptional() ? Schema.OPTIONAL_STRING_SCHEMA : Schema.STRING_SCHEMA);
                return fieldName;
            }
        }
        return super.addFieldToSchema(columnDefn, builder);
    }

    @Override
    protected DatabaseDialect.ColumnConverter columnConverterFor(ColumnMapping mapping, ColumnDefinition defn, int col, boolean isJdbc4) {
        ColumnDefinition columnDefn = mapping.columnDefn();
        switch (columnDefn.type()) {
            case -7: {
                int numBits = columnDefn.precision();
                if (numBits <= 1) {
                    return rs -> rs.getBoolean(col);
                }
                if (numBits <= 8) {
                    return rs -> rs.getByte(col);
                }
                return rs -> rs.getBytes(col);
            }
            case 1111: {
                if (!this.isJsonType(columnDefn)) break;
                return rs -> rs.getString(col);
            }
        }
        return super.columnConverterFor(mapping, defn, col, isJdbc4);
    }

    protected boolean isJsonType(ColumnDefinition columnDefn) {
        String typeName = columnDefn.typeName();
        return JSON_TYPE_NAME.equalsIgnoreCase(typeName) || JSONB_TYPE_NAME.equalsIgnoreCase(typeName);
    }

    @Override
    protected String getSqlType(SinkRecordField field) {
        if (field.schemaName() != null) {
            switch (field.schemaName()) {
                case "org.apache.kafka.connect.data.Decimal": {
                    return "DECIMAL";
                }
                case "org.apache.kafka.connect.data.Date": {
                    return "DATE";
                }
                case "org.apache.kafka.connect.data.Time": {
                    return "TIME";
                }
                case "org.apache.kafka.connect.data.Timestamp": {
                    return "TIMESTAMP";
                }
            }
        }
        switch (field.schemaType()) {
            case INT8: {
                return "SMALLINT";
            }
            case INT16: {
                return "SMALLINT";
            }
            case INT32: {
                return "INT";
            }
            case INT64: {
                return "BIGINT";
            }
            case FLOAT32: {
                return "REAL";
            }
            case FLOAT64: {
                return "DOUBLE PRECISION";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case STRING: {
                return "TEXT";
            }
            case BYTES: {
                return "BYTEA";
            }
        }
        return super.getSqlType(field);
    }

    @Override
    public String buildUpsertQueryStatement(TableId table, Collection<ColumnId> keyColumns, Collection<ColumnId> nonKeyColumns) {
        ExpressionBuilder.Transform<ColumnId> transform = (builder, col) -> builder.appendColumnName(col.name()).append("=EXCLUDED.").appendColumnName(col.name());
        ExpressionBuilder builder2 = this.expressionBuilder();
        builder2.append("INSERT INTO ");
        builder2.append(table);
        builder2.append(" (");
        builder2.appendList().delimitedBy(",").transformedBy(ExpressionBuilder.columnNames()).of(keyColumns, nonKeyColumns);
        builder2.append(") VALUES (");
        builder2.appendMultiple(",", "?", keyColumns.size() + nonKeyColumns.size());
        builder2.append(") ON CONFLICT (");
        builder2.appendList().delimitedBy(",").transformedBy(ExpressionBuilder.columnNames()).of(keyColumns);
        if (nonKeyColumns.isEmpty()) {
            builder2.append(") DO NOTHING");
        } else {
            builder2.append(") DO UPDATE SET ");
            builder2.appendList().delimitedBy(",").transformedBy(transform).of(nonKeyColumns);
        }
        return builder2.toString();
    }

    @Override
    protected void formatColumnValue(ExpressionBuilder builder, String schemaName, Map<String, String> schemaParameters, Schema.Type type, Object value) {
        if (schemaName == null && Schema.Type.BOOLEAN.equals((Object)type)) {
            builder.append((Boolean)value != false ? "TRUE" : "FALSE");
        } else {
            super.formatColumnValue(builder, schemaName, schemaParameters, type, value);
        }
    }

    @Override
    protected int decimalScale(ColumnDefinition defn) {
        if (defn.scale() == -127) {
            return 127;
        }
        if (defn.precision() == 0) {
            if (defn.scale() == 0) {
                log.debug("Column {} does not appear to have a fixed scale defined; defaulting to {}", (Object)defn.id(), (Object)127);
                return 127;
            }
            log.warn("Column {} has a precision of zero, but a non-zero scale of {}", (Object)defn.id(), (Object)defn.scale());
        }
        return defn.scale();
    }

    public static class Provider
    extends DatabaseDialectProvider.SubprotocolBasedProvider {
        public Provider() {
            super(PostgreSqlDatabaseDialect.class.getSimpleName(), "postgresql");
        }

        @Override
        public DatabaseDialect create(AbstractConfig config) {
            return new PostgreSqlDatabaseDialect(config);
        }
    }
}

