/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jms.core.source;

import io.confluent.connect.utils.config.ConfigUtils;
import io.confluent.connect.utils.licensing.LicenseValidator;
import io.confluent.connect.utils.recommenders.Recommenders;
import io.confluent.connect.utils.validators.Validators;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class BaseJmsConnectorConfig
extends AbstractConfig {
    public static final String CONFLUENT_LICENSE_CONFIG = "confluent.license";
    public static final String CONFLUENT_LICENSE_DISPLAY = "License";
    public static final String CONFLUENT_LICENSE_DEFAULT = "";
    public static final String CONFLUENT_LICENSE_DOC = "Confluent will issue a license key to each subscriber. The license key will be a short snippet of text that you can copy and paste. Without the license key, you can use the connector for a 30-day trial period. If you are a subscriber, please contact Confluent Support for more information.";
    public static final String CONFLUENT_TOPIC_CONFIG = "confluent.topic";
    public static final String CONFLUENT_TOPIC_DISPLAY = "Confluent Topic";
    public static final String CONFLUENT_TOPIC_DEFAULT = "_confluent-command";
    public static final String CONFLUENT_TOPIC_DOC = "Name of the Kafka topic used for Confluent Platform configuration, including licensing information.";
    public static final String CONFLUENT_TOPIC_PREFIX = "confluent.topic.";
    public static final String CONFLUENT_TOPIC_PRODUCER_PREFIX = "confluent.topic.producer.";
    public static final String CONFLUENT_TOPIC_CONSUMER_PREFIX = "confluent.topic.consumer.";
    public static final String CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_CONFIG = "confluent.topic.bootstrap.servers";
    public static final String CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_DISPLAY = "Confluent Topic Servers";
    public static final String CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_DOC = "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster used for licensing. All servers in the cluster will be discovered from the initial connection. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).";
    public static final String CONFLUENT_TOPIC_REPLICATION_FACTOR_CONFIG = "confluent.topic.replication.factor";
    public static final String CONFLUENT_TOPIC_REPLICATION_FACTOR_DISPLAY = "Confluent Topic Replication Factor";
    public static final int CONFLUENT_TOPIC_REPLICATION_FACTOR_DEFAULT = 3;
    public static final String CONFLUENT_TOPIC_REPLICATION_FACTOR_DOC = "The replication factor for the Kafka topic used for Confluent Platform configuration, including licensing information. This is used only if the topic does not already exist, and the default of 3 is appropriate for production use. If you are using a development environment with less than 3 brokers, you must set this to the number of brokers (often 1).";
    public static final String DESTINATION_NAME_CONFIG = "jms.destination.name";
    public static final String DESTINATION_NAME_DISPLAY = "Destination Name";
    protected static final String DESTINATION_NAME_DOC = "The name of the JMS destination (queue or topic) to read from.";
    public static final String DESTINATION_TYPE_CONFIG = "jms.destination.type";
    public static final String DESTINATION_TYPE_DISPLAY = "Destination Type";
    protected static final String DESTINATION_TYPE_DOC = "The type of JMS destination, which is either `queue` or `topic`.";
    public static final String BATCH_SIZE_CONFIG = "batch.size";
    public static final String BATCH_SIZE_DISPLAY = "Batch Size";
    public static final int BATCH_SIZE_DEFAULT = 1024;
    protected static final String BATCH_SIZE_DOC = "The maximum number of records that a connector task may read from the JMS broker before writing to Kafka. The task holds these records until they are acknowledged in Kafka, so this may affect memory usage.";
    public static final String MAX_PENDING_CONFIG = "max.pending.messages";
    public static final String MAX_PENDING_DISPLAY = "Unacknowledged Messages Limit";
    public static final int MAX_PENDING_DEFAULT = 4096;
    protected static final String MAX_PENDING_DOC = "The maximum number of messages per task that can be received from JMS brokers and produced to Kafka before the task acknowledges the JMS session/messages. If the task fails and is restarted, this is the maximum number of JMS messages the task may duplicate in Kafka. This is typically set larger than ``batch.size``. A smaller value than ``batch.size`` limits the size of the batches.";
    public static final String MAX_POLL_DURATION_MS_CONFIG = "max.poll.duration";
    public static final String MAX_POLL_DURATION_MS_DISPLAY = "Maximum time to wait for a single poll in milliseconds.";
    public static final int MAX_POLL_DURATION_MS_DEFAULT = 60000;
    protected static final String MAX_POLL_DURATION_MS_DOC = "The maximum amount of time each task can build a batch. The batch is closed and sent to Kafka if not enough messages are read during the time allotted. This helps limit connector lag when the JMS queue/topic has a lower throughput.";
    public static final String USERNAME_CONFIG = "java.naming.security.principal";
    public static final String USERNAME_DISPLAY = "Username";
    protected static final String USERNAME_DOC = "The security principal to connect with. This is typically a username. See `Context.SECURITY_PRINCIPAL <https://docs.oracle.com/javase/7/docs/api/javax/naming/Context.html#SECURITY_PRINCIPAL>`_ for more details. The documentation for your JMS provider will be helpful as well.";
    public static final String PASSWORD_CONFIG = "java.naming.security.credentials";
    public static final String PASSWORD_DISPLAY = "Password";
    protected static final String PASSWORD_DOC = "The security credentials to connect with. This is typically a password. See `Context.SECURITY_CREDENTIALS <https://docs.oracle.com/javase/7/docs/api/javax/naming/Context.html#SECURITY_CREDENTIALS>`_ for more details. The documentation for your JMS provider will be helpful as well.";
    public static final String MAX_TOTAL_RETRY_TIME_MS_CONFIG = "max.retry.time";
    public static final long MAX_TOTAL_RETRY_TIME_MS_DEFAULT = TimeUnit.HOURS.toMillis(1L);
    public static final String MAX_TOTAL_RETRY_TIME_MS_DISPLAY = "Max Retry Time in Milliseconds";
    public static final String MAX_TOTAL_RETRY_TIME_MS_DOC = "The maximum total time in milliseconds the connector will retry when receiving a retriable exception. This value must be at least 100 milliseconds if retry functionality is desired. If a value of less than 100 milliseconds is configured, it will be assumed that no retry functionality is desired.Additionally, some retriable exceptions will require establishing a new JMS session";
    protected static final String JMS_GROUP = "JMS Connection";
    protected static final String SESSION_GROUP = "JMS Session";
    protected static final String CONFLUENT_GROUP = "Confluent Platform";
    protected static final String RETRY_GROUP = "Retry";
    public final String destinationName = this.getString("jms.destination.name");
    public final DestinationType destinationType = DestinationType.valueOf(this.getString("jms.destination.type").toUpperCase());

    public static ConfigDef addJmsTopicConfigs(ConfigDef configDef, String groupName) {
        if (groupName == null) {
            groupName = SESSION_GROUP;
        }
        int orderInGroup = ConfigUtils.keysInGroup(configDef, groupName);
        configDef.define(DESTINATION_NAME_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, DESTINATION_NAME_DOC, groupName, ++orderInGroup, ConfigDef.Width.LONG, DESTINATION_NAME_DISPLAY);
        configDef.define(DESTINATION_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)DestinationType.QUEUE.name(), (ConfigDef.Validator)Validators.oneStringOf(DestinationType.getNames(), (boolean)false), ConfigDef.Importance.HIGH, DESTINATION_TYPE_DOC, groupName, ++orderInGroup, ConfigDef.Width.MEDIUM, DESTINATION_TYPE_DISPLAY, Recommenders.anyOf((Object[])new Object[]{DestinationType.TOPIC.name(), DestinationType.QUEUE.name()}));
        configDef.define(BATCH_SIZE_CONFIG, ConfigDef.Type.INT, (Object)1024, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, BATCH_SIZE_DOC, groupName, ++orderInGroup, ConfigDef.Width.MEDIUM, BATCH_SIZE_DISPLAY);
        configDef.define(MAX_PENDING_CONFIG, ConfigDef.Type.INT, (Object)4096, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, MAX_PENDING_DOC, groupName, ++orderInGroup, ConfigDef.Width.MEDIUM, MAX_PENDING_DISPLAY);
        configDef.define(MAX_POLL_DURATION_MS_CONFIG, ConfigDef.Type.INT, (Object)60000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, MAX_POLL_DURATION_MS_DOC, groupName, ++orderInGroup, ConfigDef.Width.MEDIUM, MAX_POLL_DURATION_MS_DISPLAY);
        return configDef;
    }

    public static ConfigDef addCredentialsConfigs(ConfigDef configDef, String groupName) {
        if (groupName == null) {
            groupName = JMS_GROUP;
        }
        int orderInGroup = ConfigUtils.keysInGroup(configDef, groupName);
        configDef.define(USERNAME_CONFIG, ConfigDef.Type.STRING, (Object)CONFLUENT_LICENSE_DEFAULT, ConfigDef.Importance.HIGH, USERNAME_DOC, groupName, ++orderInGroup, ConfigDef.Width.MEDIUM, USERNAME_DISPLAY);
        configDef.define(PASSWORD_CONFIG, ConfigDef.Type.PASSWORD, (Object)CONFLUENT_LICENSE_DEFAULT, ConfigDef.Importance.HIGH, PASSWORD_DOC, groupName, ++orderInGroup, ConfigDef.Width.MEDIUM, PASSWORD_DISPLAY);
        return configDef;
    }

    public static ConfigDef addLicenseConfigs(ConfigDef configDef) {
        int orderInGroup = ConfigUtils.keysInGroup(configDef, CONFLUENT_GROUP);
        configDef.define(CONFLUENT_LICENSE_CONFIG, ConfigDef.Type.STRING, (Object)CONFLUENT_LICENSE_DEFAULT, (ConfigDef.Validator)new LicenseValidator(), ConfigDef.Importance.HIGH, CONFLUENT_LICENSE_DOC, CONFLUENT_GROUP, ++orderInGroup, ConfigDef.Width.NONE, CONFLUENT_LICENSE_DISPLAY);
        configDef.define(CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_CONFIG, ConfigDef.Type.LIST, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.HIGH, CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_DOC, CONFLUENT_GROUP, ++orderInGroup, ConfigDef.Width.LONG, CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_DISPLAY);
        configDef.define(CONFLUENT_TOPIC_CONFIG, ConfigDef.Type.STRING, (Object)CONFLUENT_TOPIC_DEFAULT, ConfigDef.Importance.LOW, CONFLUENT_TOPIC_DOC, CONFLUENT_GROUP, ++orderInGroup, ConfigDef.Width.MEDIUM, CONFLUENT_TOPIC_DISPLAY);
        configDef.define(CONFLUENT_TOPIC_REPLICATION_FACTOR_CONFIG, ConfigDef.Type.INT, (Object)3, ConfigDef.Importance.LOW, CONFLUENT_TOPIC_REPLICATION_FACTOR_DOC, CONFLUENT_GROUP, ++orderInGroup, ConfigDef.Width.MEDIUM, CONFLUENT_TOPIC_REPLICATION_FACTOR_DISPLAY);
        return configDef;
    }

    public static ConfigDef addRetryConfigs(ConfigDef configDef) {
        int orderInGroup = ConfigUtils.keysInGroup(configDef, CONFLUENT_GROUP);
        configDef.define(MAX_TOTAL_RETRY_TIME_MS_CONFIG, ConfigDef.Type.LONG, (Object)MAX_TOTAL_RETRY_TIME_MS_DEFAULT, ConfigDef.Importance.LOW, MAX_TOTAL_RETRY_TIME_MS_DOC, RETRY_GROUP, ++orderInGroup, ConfigDef.Width.SHORT, MAX_TOTAL_RETRY_TIME_MS_DISPLAY);
        return configDef;
    }

    public BaseJmsConnectorConfig(ConfigDef config, Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    protected String username() {
        return this.getString(USERNAME_CONFIG);
    }

    protected String password() {
        return this.getPassword(PASSWORD_CONFIG).value();
    }

    protected int batchSize() {
        return this.getInt(BATCH_SIZE_CONFIG);
    }

    protected int maxPending() {
        return this.getInt(MAX_PENDING_CONFIG);
    }

    protected int maxPollDuration() {
        return this.getInt(MAX_POLL_DURATION_MS_CONFIG);
    }

    protected long maxRetryTimeMs() {
        return this.getLong(MAX_TOTAL_RETRY_TIME_MS_CONFIG);
    }

    protected String licenseDefaultClientId() {
        String connectorName = (String)this.originalsStrings().get("name");
        return connectorName != null ? connectorName + "-license-manager" : null;
    }

    protected Map<String, Object> licenseProducerConfig() {
        HashMap<String, Object> unifiedConfig = new HashMap<String, Object>();
        unifiedConfig.putAll(this.originalsWithPrefix(CONFLUENT_TOPIC_PREFIX));
        unifiedConfig.putAll(this.originalsWithPrefix(CONFLUENT_TOPIC_PRODUCER_PREFIX));
        return unifiedConfig;
    }

    protected Map<String, Object> licenseConsumerConfig() {
        HashMap<String, Object> unifiedConfig = new HashMap<String, Object>();
        unifiedConfig.putAll(this.originalsWithPrefix(CONFLUENT_TOPIC_PREFIX));
        unifiedConfig.putAll(this.originalsWithPrefix(CONFLUENT_TOPIC_CONSUMER_PREFIX));
        return unifiedConfig;
    }

    protected Map<String, Object> licenseTopicAdminConfig() {
        HashMap<String, Object> unifiedConfig = new HashMap<String, Object>();
        unifiedConfig.putAll(this.originalsWithPrefix(CONFLUENT_TOPIC_PREFIX));
        unifiedConfig.putAll(this.originalsWithPrefix(CONFLUENT_TOPIC_PRODUCER_PREFIX));
        unifiedConfig.putAll(this.originalsWithPrefix(CONFLUENT_TOPIC_CONSUMER_PREFIX));
        return unifiedConfig;
    }

    protected String licenseTopicName() {
        return this.getString(CONFLUENT_TOPIC_CONFIG);
    }

    protected String license() {
        return this.getString(CONFLUENT_LICENSE_CONFIG);
    }

    public static enum DestinationType {
        QUEUE,
        TOPIC;


        public static List<String> getNames() {
            return Arrays.stream(DestinationType.class.getEnumConstants()).map(Enum::name).collect(Collectors.toList());
        }
    }
}

