/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jms.core.source;

import io.confluent.connect.jms.core.source.BaseJmsConnectorConfig;
import io.confluent.connect.jms.core.source.BaseJmsSourceConnectorConfig;
import io.confluent.connect.utils.licensing.ConnectLicenseManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJmsSourceConnector<C extends BaseJmsSourceConnectorConfig>
extends SourceConnector {
    private static final Logger log = LoggerFactory.getLogger(BaseJmsSourceConnector.class);
    protected C config;
    private Map<String, String> settings;
    private String connectorName;

    protected abstract C config(Map<String, String> var1);

    public void start(Map<String, String> settings) {
        this.connectorName = settings.get("name");
        log.info("{} start()", (Object)this);
        this.config = this.config(settings);
        this.settings = settings;
        this.createLicenseManager().registerOrValidateLicense();
    }

    protected ConnectLicenseManager createLicenseManager() {
        return ConnectLicenseManager.create().useLicense(((BaseJmsConnectorConfig)((Object)this.config)).license()).useTopicName(((BaseJmsConnectorConfig)((Object)this.config)).licenseTopicName()).useDefaultClientId(((BaseJmsConnectorConfig)((Object)this.config)).licenseDefaultClientId()).useProducerConfig(((BaseJmsConnectorConfig)((Object)this.config)).licenseProducerConfig()).useConsumerConfig(((BaseJmsConnectorConfig)((Object)this.config)).licenseConsumerConfig()).useAdminConfig(((BaseJmsConnectorConfig)((Object)this.config)).licenseTopicAdminConfig()).build();
    }

    public void stop() {
        log.info("{} stop()", (Object)this);
    }

    public List<Map<String, String>> taskConfigs(int taskCount) {
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>(taskCount);
        for (int i = 0; i < taskCount; ++i) {
            HashMap<String, String> taskSettings = new HashMap<String, String>(this.settings);
            taskSettings.put("task.jms.id", Integer.toString(i));
            result.add(taskSettings);
        }
        return Collections.unmodifiableList(result);
    }

    public String toString() {
        return this.connectorName;
    }
}

