/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jms.core.source;

import io.confluent.connect.jms.core.source.BaseJmsConnectorConfig;
import io.confluent.connect.utils.config.ConfigUtils;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;

public class BaseJmsSourceConnectorConfig
extends BaseJmsConnectorConfig {
    public static final String MESSAGE_SELECTOR_CONFIG = "jms.message.selector";
    public static final String MESSAGE_SELECTOR_DISPLAY = "Message Selector";
    private static final String MESSAGE_SELECTOR_DOC = "The `message selector <http://docs.oracle.com/javaee/6/api/javax/jms/Session.html#createConsumer(javax.jms.Destination, java.lang.String, boolean)>`_ that should be applied to messages in the destination.";
    public static final String TOPIC_CONFIG = "kafka.topic";
    public static final String TOPIC_DISPLAY = "Kafka Topic";
    private static final String TOPIC_DOC = "The name of the Kafka topic where the connector writes all records that were read from the JMS broker.";
    public static final String USE_PERMISSIVE_SCHEMA_CONFIG = "use.permissive.schema";
    public static final Boolean USE_PERMISSIVE_SCHEMA_DEFAULT = Boolean.FALSE;
    public static final String USE_PERMISSIVE_SCHEMA_DISPLAY = "Permissive Schema";
    public static final String USE_PERMISSIVE_SCHEMA_DOC = "Whether to use a more permissive schema with an optional messageID in the key and value. Defaults to ``false`` for compatibility with the old strict schema. If your JMS messages have null message IDs, then you must set this to ``true``.";
    protected static final String KAFKA_GROUP = "Kafka";
    public final String topic = this.getString("kafka.topic");
    public final String messageSelector = this.getString("jms.message.selector");
    public final boolean permissiveSchema = this.getBoolean("use.permissive.schema");

    public static ConfigDef addKafkaConfigs(ConfigDef configDef, String groupName) {
        if (groupName == null) {
            groupName = KAFKA_GROUP;
        }
        int orderInGroup = ConfigUtils.keysInGroup(configDef, groupName);
        configDef.define(TOPIC_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, TOPIC_DOC, groupName, ++orderInGroup, ConfigDef.Width.LONG, TOPIC_DISPLAY);
        configDef.define(USE_PERMISSIVE_SCHEMA_CONFIG, ConfigDef.Type.BOOLEAN, (Object)USE_PERMISSIVE_SCHEMA_DEFAULT, ConfigDef.Importance.LOW, USE_PERMISSIVE_SCHEMA_DOC, groupName, ++orderInGroup, ConfigDef.Width.SHORT, USE_PERMISSIVE_SCHEMA_DISPLAY);
        return configDef;
    }

    public static ConfigDef addJmsTopicConfigs(ConfigDef configDef, String groupName) {
        return BaseJmsConnectorConfig.addJmsTopicConfigs(configDef, groupName);
    }

    public static ConfigDef addCredentialsConfigs(ConfigDef configDef, String groupName) {
        return BaseJmsConnectorConfig.addCredentialsConfigs(configDef, groupName);
    }

    public static ConfigDef addSessionConfigs(ConfigDef configDef, String groupName) {
        if (groupName == null) {
            groupName = "JMS Session";
        }
        int orderInGroup = ConfigUtils.keysInGroup(configDef, groupName);
        configDef.define(MESSAGE_SELECTOR_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, MESSAGE_SELECTOR_DOC, groupName, ++orderInGroup, ConfigDef.Width.LONG, MESSAGE_SELECTOR_DISPLAY);
        BaseJmsSourceConnectorConfig.addRetryConfigs(configDef);
        return configDef;
    }

    public BaseJmsSourceConnectorConfig(ConfigDef conf, Map<String, String> parsedConfig) {
        super(conf, parsedConfig);
    }
}

