/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jms.core.source;

import io.confluent.connect.jms.core.source.BaseJmsConnectorConfig;
import io.confluent.connect.jms.core.source.BaseJmsSourceConnectorConfig;
import io.confluent.connect.jms.core.source.BaseJmsSourceTask;
import io.confluent.license.util.StringUtils;
import java.io.Closeable;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.kafka.connect.errors.RetriableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsClientHelper<C extends BaseJmsSourceConnectorConfig>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(BaseJmsSourceTask.class);
    private static final boolean TRANSACTION_MODE = false;
    private static final int ACKNOWLEDGE_MODE = 2;
    private final C config;
    private final ConnectionFactory connectionFactory;
    private Connection connection;
    private Session session;
    private MessageConsumer messageConsumer;
    private String clientId;
    private String connectorNameAndTaskId;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtomicBoolean isActive = new AtomicBoolean(true);
    private final AtomicBoolean isOpen = new AtomicBoolean(false);

    public JmsClientHelper(C config, ConnectionFactory connectionFactory, String connectorTaskAndId) {
        this.config = config;
        this.connectionFactory = connectionFactory;
        this.connectorNameAndTaskId = connectorTaskAndId;
    }

    public void connect() throws JMSException {
        if (this.isOpen.get() || !this.isActive.get()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            Queue destination;
            if (this.isOpen.get() || !this.isActive.get()) {
                return;
            }
            if (StringUtils.isBlank((String)((BaseJmsConnectorConfig)((Object)this.config)).username())) {
                log.debug("Connecting with no username/password");
                this.connection = this.connectionFactory.createConnection();
            } else {
                log.debug("Connecting as {}", (Object)((BaseJmsConnectorConfig)((Object)this.config)).username());
                this.connection = this.connectionFactory.createConnection(((BaseJmsConnectorConfig)((Object)this.config)).username(), ((BaseJmsConnectorConfig)((Object)this.config)).password());
            }
            try {
                this.clientId = this.connection.getClientID();
            }
            catch (JMSException e) {
                log.info("{} Error getting client ID: {} {}", new Object[]{this, e.getErrorCode(), e.getMessage()});
            }
            if (this.clientId != null && !this.clientId.trim().isEmpty()) {
                log.info("{} Found existing JMS client ID '{}'", (Object)this, (Object)this.clientId);
            } else {
                this.clientId = this.createClientId();
                try {
                    log.info("{} Setting JMS client ID to '{}'", (Object)this, (Object)this.clientId);
                    this.connection.setClientID(this.clientId);
                }
                catch (JMSException e) {
                    log.info("{} Unable to set client ID to '{}': {} {}", new Object[]{this, this.clientId, e.getErrorCode(), e.getMessage()});
                }
            }
            log.info("{} Starting connection", (Object)this);
            this.connection.start();
            this.session = this.connection.createSession(false, 2);
            log.info("Created session.");
            switch (((BaseJmsSourceConnectorConfig)((Object)this.config)).destinationType) {
                case QUEUE: {
                    destination = this.session.createQueue(((BaseJmsSourceConnectorConfig)((Object)this.config)).destinationName);
                    break;
                }
                case TOPIC: {
                    destination = this.session.createTopic(((BaseJmsSourceConnectorConfig)((Object)this.config)).destinationName);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Destination type of '" + (Object)((Object)((BaseJmsSourceConnectorConfig)((Object)this.config)).destinationType) + "' is not supported.");
                }
            }
            this.messageConsumer = this.session.createConsumer((Destination)destination);
            log.info("Created consumer.");
            this.isOpen.compareAndSet(false, true);
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(long timeout) throws JMSException {
        if (this.isHealthy()) {
            this.lock.readLock().lock();
            try {
                if (this.isHealthy()) {
                    Message message = this.messageConsumer.receive(timeout);
                    return message;
                }
                Message message = null;
                return message;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        return null;
    }

    public void acknowledge(Message message) throws JMSException, RetriableException {
        if (this.isHealthy()) {
            this.lock.readLock().lock();
            try {
                if (this.isHealthy()) {
                    message.acknowledge();
                    return;
                }
                throw new RetriableException("Connection is closed, cannot acknowledge message.");
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        throw new RetriableException("Connection is closed, cannot acknowledge message.");
    }

    public boolean isClosed() {
        return !this.isOpen.get();
    }

    private boolean isHealthy() {
        return this.isOpen.get() && this.isActive.get();
    }

    public void deactivate() {
        this.lock.writeLock().lock();
        try {
            this.isActive.compareAndSet(true, false);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private String createClientId() {
        return this.connectorNameAndTaskId + UUID.randomUUID().toString().substring(0, 8);
    }

    public String clientId() {
        return this.clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.lock.writeLock().lock();
        try {
            try {
                if (this.messageConsumer != null) {
                    this.messageConsumer.close();
                }
            }
            catch (JMSException e) {
                log.debug("Closing MessageConsumer threw: ", (Throwable)e);
            }
            finally {
                this.messageConsumer = null;
            }
            try {
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (JMSException e) {
                log.debug("Closing Session threw: ", (Throwable)e);
            }
            finally {
                this.session = null;
            }
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (JMSException e) {
                log.debug("Closing Connection threw: ", (Throwable)e);
            }
            finally {
                this.connection = null;
                this.isOpen.set(false);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

