/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.jms.core.source;

import io.confluent.connect.jms.core.source.BaseJmsConnectorConfig;
import io.confluent.connect.jms.core.source.BaseJmsSourceConnectorConfig;
import io.confluent.connect.jms.core.source.JmsSourceRecord;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordConverter {
    public static final Map<String, Object> PARTITIONS = new HashMap<String, Object>();
    public static final Map<String, Object> OFFSETS = new HashMap<String, Object>();
    public static final String FIELD_TIMESTAMP = "timestamp";
    public static final String FIELD_DELIVERY_MODE = "deliveryMode";
    public static final String FIELD_MESSAGE_ID = "messageID";
    public static final String FIELD_CORRELATION_ID = "correlationID";
    public static final String FIELD_REPLY_TO = "replyTo";
    public static final String FIELD_DESTINATION = "destination";
    public static final String FIELD_REDELIVERED = "redelivered";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_EXPIRATION = "expiration";
    public static final String FIELD_PRIORITY = "priority";
    public static final String FIELD_PROPERTIES = "properties";
    public static final String FIELD_PROPERTY_TYPE = "propertyType";
    public static final String FIELD_BOOLEAN = "boolean";
    public static final String FIELD_BYTE = "byte";
    public static final String FIELD_SHORT = "short";
    public static final String FIELD_INTEGER = "integer";
    public static final String FIELD_LONG = "long";
    public static final String FIELD_FLOAT = "float";
    public static final String FIELD_DOUBLE = "double";
    public static final String FIELD_STRING = "string";
    public static final String FIELD_NULL = "null-value";
    public static final String FIELD_DESTINATION_TYPE = "destinationType";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_MESSAGE_TYPE = "messageType";
    private static final String FIELD_TIMESTAMP_DOC = "Data from the `getJMSTimestamp() <http://docs.oracle.com/javaee/6/api/javax/jms/Message.html#getJMSTimestamp()>`_ method.";
    private static final String FIELD_DELIVERY_MODE_DOC = "This field stores the value of `Message.getJMSDeliveryMode() <http://docs.oracle.com/javaee/6/api/javax/jms/Message.html#getJMSDeliveryMode()>`_.";
    private static final String FIELD_MESSAGE_ID_DOC = "This field stores the value of `Message.getJMSMessageID() <http://docs.oracle.com/javaee/6/api/javax/jms/Message.html#getJMSMessageID()>`_.";
    private static final String FIELD_CORRELATION_ID_DOC = "This field stores the value of `Message.getJMSCorrelationID() <http://docs.oracle.com/javaee/6/api/javax/jms/Message.html#getJMSCorrelationID()>`_.";
    private static final String FIELD_REDELIVERED_DOC = "This field stores the value of `Message.getJMSRedelivered() <http://docs.oracle.com/javaee/6/api/javax/jms/Message.html#getJMSRedelivered()>`_.";
    private static final String FIELD_TYPE_DOC = "This field stores the value of `Message.getJMSType() <http://docs.oracle.com/javaee/6/api/javax/jms/Message.html#getJMSType()>`_.";
    private static final String FIELD_EXPIRATION_DOC = "This field stores the value of `Message.getJMSExpiration() <http://docs.oracle.com/javaee/6/api/javax/jms/Message.html#getJMSExpiration()>`_.";
    private static final String FIELD_PRIORITY_DOC = "This field stores the value of `Message.getJMSPriority() <http://docs.oracle.com/javaee/6/api/javax/jms/Message.html#getJMSPriority()>`_.";
    private static final String FIELD_PROPERTIES_DOC = "This field stores the data from all of the properties for the Message indexed by their propertyName.";
    private static final String FIELD_PROPERTY_TYPE_DOC = "The java type of the property on the Message. One of ``boolean``, ``byte``, ``short``, ``integer``, ``long``, ``float``, ``double``, or ``string``, or ``null-value``.";
    private static final String FIELD_BOOLEAN_DOC = "The value stored as a boolean. Null unless ``propertyType`` is set to ``boolean``.";
    private static final String FIELD_BYTE_DOC = "The value stored as a byte. Null unless ``propertyType`` is set to ``byte``.";
    private static final String FIELD_SHORT_DOC = "The value stored as a short. Null unless ``propertyType`` is set to ``short``.";
    private static final String FIELD_INTEGER_DOC = "The value stored as a integer. Null unless ``propertyType`` is set to ``integer``.";
    private static final String FIELD_LONG_DOC = "The value stored as a long. Null unless ``propertyType`` is set to ``long``.";
    private static final String FIELD_FLOAT_DOC = "The value stored as a float. Null unless ``propertyType`` is set to ``float``.";
    private static final String FIELD_DOUBLE_DOC = "The value stored as a double. Null unless ``propertyType`` is set to ``double``.";
    private static final String FIELD_STRING_DOC = "The value stored as a string. Null unless ``propertyType`` is set to ``string``.";
    private static final String FIELD_BYTES_DOC = "This field stores the value from `BytesMessage.html.readBytes(byte[]) <http://docs.oracle.com/javaee/6/api/javax/jms/BytesMessage.html#readBytes(byte[])>`_.";
    private static final String FIELD_DESTINATION_TYPE_DOC = "The type of JMS Destination, and either ``queue`` or ``topic``.";
    private static final String FIELD_NAME_DOC = "The name of the destination. This will be the value of `Queue.getQueueName() <http://docs.oracle.com/javaee/6/api/javax/jms/Queue.html#getQueueName()>`_ or `Topic.getTopicName() <http://docs.oracle.com/javaee/6/api/javax/jms/Topic.html#getTopicName()>`_.";
    private static final String FIELD_MAP_DOC = "This field stores the data from all of the map entries returned from `MapMessage.getMapNames() <http://docs.oracle.com/javaee/6/api/javax/jms/MapMessage.html#getMapNames()>`_ for the Message indexed by their key.";
    private static final String FIELD_TEXT_DOC = "This field stores the value from `TextMessage.html.getText() <http://docs.oracle.com/javaee/6/api/javax/jms/TextMessage.html#getText()>`_.";
    private static final String FIELD_MESSAGE_TYPE_DOC = "This field stores the type of message that was received. This corresponds to the subinterfaces of `Message <http://docs.oracle.com/javaee/6/api/javax/jms/Message.html>`_. `BytesMessage <http://docs.oracle.com/javaee/6/api/javax/jms/BytesMessage.html>`_ = `bytes`, `MapMessage <http://docs.oracle.com/javaee/6/api/javax/jms/MapMessage.html>`_ = `map`, `ObjectMessage <http://docs.oracle.com/javaee/6/api/javax/jms/ObjectMessage.html>`_ = `object`, `StreamMessage <http://docs.oracle.com/javaee/6/api/javax/jms/StreamMessage.html>`_ = `stream` and `TextMessage <http://docs.oracle.com/javaee/6/api/javax/jms/TextMessage.html>`_ = `text`. The corresponding field will be populated with the values from the respective Message subinterface.";
    private static final String KEY_SCHEMA_DOC = "This schema is used to store the incoming MessageID on the message interface. This will ensure that when that if the same message id arrives it will end up in the same partition. In practice this should never occur.";
    private static final String PROPERTY_VALUE_SCHEMA_DOC = "This schema is used to store the data that is found in the properties of the message. To ensure that the proper type mappings are preserved field ``propertyType`` stores the value type for the field. The corresponding field in the schema will contain the data for the property. This ensures that the data is retrievable as the type returned by `Message.getObjectProperty() <http://docs.oracle.com/javaee/6/api/javax/jms/Message.html#getObjectProperty(java.lang.String)>`_.";
    private static final String DESTINATION_SCHEMA_DOC = "This schema is used to represent a JMS Destination, and is either `queue <http://docs.oracle.com/javaee/6/api/javax/jms/Queue.html>`_ or `topic <http://docs.oracle.com/javaee/6/api/javax/jms/Topic.html>`_.";
    private static final String VALUE_SCHEMA_DOC = "This schema is used to store the value of the JMS message.";
    public static final Schema KEY_SCHEMA;
    public static final Schema PROPERTY_VALUE_SCHEMA;
    public static final Schema DESTINATION_SCHEMA;
    public static final Schema VALUE_SCHEMA;
    public static final Schema KEY_SCHEMA_PERMISSIVE;
    public static final Schema PROPERTY_VALUE_SCHEMA_PERMISSIVE;
    public static final Schema DESTINATION_SCHEMA_PERMISSIVE;
    public static final Schema VALUE_SCHEMA_PERMISSIVE;
    public final Schema keySchema;
    public final Schema propertyValueSchema;
    public final Schema destinationSchema;
    public final Schema valueSchema;
    public static final String FIELD_BYTES = "bytes";
    public static final String FIELD_MAP = "map";
    public static final String FIELD_OBJECT = "object";
    public static final String FIELD_STREAM = "stream";
    public static final String FIELD_TEXT = "text";
    public static final Logger log;
    private final BaseJmsSourceConnectorConfig config;

    public RecordConverter(BaseJmsSourceConnectorConfig config) {
        this.config = config;
        if (config.permissiveSchema) {
            this.keySchema = KEY_SCHEMA_PERMISSIVE;
            this.propertyValueSchema = PROPERTY_VALUE_SCHEMA_PERMISSIVE;
            this.destinationSchema = DESTINATION_SCHEMA_PERMISSIVE;
            this.valueSchema = VALUE_SCHEMA_PERMISSIVE;
        } else {
            this.keySchema = KEY_SCHEMA;
            this.propertyValueSchema = PROPERTY_VALUE_SCHEMA;
            this.destinationSchema = DESTINATION_SCHEMA;
            this.valueSchema = VALUE_SCHEMA;
        }
    }

    protected Struct destination(Destination destination) throws JMSException {
        BaseJmsConnectorConfig.DestinationType type;
        if (destination instanceof Queue && destination instanceof Topic) {
            type = this.config.destinationType;
        } else if (destination instanceof Queue) {
            type = BaseJmsConnectorConfig.DestinationType.QUEUE;
        } else if (destination instanceof Topic) {
            type = BaseJmsConnectorConfig.DestinationType.TOPIC;
        } else {
            return null;
        }
        Struct result = new Struct(this.destinationSchema);
        switch (type) {
            case QUEUE: {
                result.put(FIELD_DESTINATION_TYPE, (Object)"queue");
                result.put(FIELD_NAME, (Object)((Queue)destination).getQueueName());
                break;
            }
            case TOPIC: {
                result.put(FIELD_DESTINATION_TYPE, (Object)"topic");
                result.put(FIELD_NAME, (Object)((Topic)destination).getTopicName());
                break;
            }
            default: {
                return null;
            }
        }
        return result;
    }

    Destination destination(Session session, Struct destinationStruct) throws JMSException {
        if (destinationStruct != null) {
            String type = destinationStruct.getString(FIELD_DESTINATION_TYPE);
            String name = destinationStruct.getString(FIELD_NAME);
            if ("queue".equals(type)) {
                return session.createQueue(name);
            }
            if ("topic".equals(type)) {
                return session.createTopic(name);
            }
        }
        return null;
    }

    Message message(Session session, SinkRecord record) throws JMSException {
        if (record.key() != null && !(record.key() instanceof Struct)) {
            throw new ConnectException("Record key is expected to be a Struct");
        }
        if (record.value() != null && !(record.value() instanceof Struct)) {
            throw new ConnectException("Record value is expected to be a Struct");
        }
        return this.message(session, (Struct)record.key(), (Struct)record.value());
    }

    Message message(Session session, Struct key, Struct value) throws JMSException {
        BytesMessage message = null;
        String messageType = value.getString(FIELD_MESSAGE_TYPE);
        String messageId = value.getString(FIELD_MESSAGE_ID);
        if (FIELD_BYTES.equals(messageType)) {
            log.trace("message(session,key,'{}') - Creating as BytesMessage", (Object)messageId);
            byte[] actualBytes = value.getBytes(FIELD_BYTES);
            BytesMessage bytesMessage = session.createBytesMessage();
            bytesMessage.writeBytes(actualBytes);
            message = bytesMessage;
        } else if (FIELD_TEXT.equals(messageType)) {
            log.trace("message(session,key,'{}') - Creating as TextMessage", (Object)messageId);
            String text = value.getString(FIELD_TEXT);
            TextMessage textMessage = session.createTextMessage(text);
            message = textMessage;
        } else if (FIELD_MAP.equals(messageType)) {
            log.trace("message(session,key,'{}') - Creating as MapMessage", (Object)messageId);
            MapMessage mapMessage = session.createMapMessage();
            Map mapFields = value.getMap(FIELD_MAP);
            for (Map.Entry entry : mapFields.entrySet()) {
                log.trace("record('{}') - Processing map key '{}'", (Object)messageId, entry.getKey());
                this.setPropertyValue(mapMessage, (String)entry.getKey(), (Struct)entry.getValue());
            }
            message = mapMessage;
        } else {
            if (FIELD_OBJECT.equals(messageType)) {
                log.trace("message(session,key,'{}') - Skipping ObjectMessage", (Object)messageId);
                return null;
            }
            if (FIELD_STREAM.equals(messageType)) {
                log.trace("message(session,key,'{}') - Skipping ObjectMessage", (Object)messageId);
                return null;
            }
        }
        message.setJMSMessageID(messageId);
        message.setJMSType(value.getString(FIELD_TYPE));
        message.setJMSTimestamp(value.getInt64(FIELD_TIMESTAMP).longValue());
        message.setJMSDeliveryMode(value.getInt32(FIELD_DELIVERY_MODE).intValue());
        message.setJMSCorrelationID(value.getString(FIELD_CORRELATION_ID));
        message.setJMSRedelivered(value.getBoolean(FIELD_REDELIVERED).booleanValue());
        message.setJMSExpiration(value.getInt64(FIELD_EXPIRATION).longValue());
        message.setJMSPriority(value.getInt32(FIELD_PRIORITY).intValue());
        message.setJMSReplyTo(this.destination(session, value.getStruct(FIELD_REPLY_TO)));
        message.setJMSDestination(this.destination(session, value.getStruct(FIELD_DESTINATION)));
        return message;
    }

    public JmsSourceRecord record(Message message) throws JMSException {
        String messageID = message.getJMSMessageID();
        log.trace("record('{}') - Processing message", (Object)messageID);
        Struct key = new Struct(this.keySchema).put(FIELD_MESSAGE_ID, (Object)messageID);
        if (this.config.permissiveSchema && messageID == null) {
            key = null;
        }
        LinkedHashMap<String, Struct> properties = new LinkedHashMap<String, Struct>();
        Enumeration propertyNames = message.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            log.trace("record('{}') - Processing property '{}'", (Object)messageID, (Object)propertyName);
            Object propertyValue = message.getObjectProperty(propertyName);
            Struct propertyStruct = this.propertyValueStruct(messageID, propertyValue);
            properties.put(propertyName, propertyStruct);
        }
        Struct value = new Struct(this.valueSchema).put(FIELD_MESSAGE_ID, (Object)messageID).put(FIELD_TIMESTAMP, (Object)message.getJMSTimestamp()).put(FIELD_DELIVERY_MODE, (Object)message.getJMSDeliveryMode()).put(FIELD_CORRELATION_ID, (Object)message.getJMSCorrelationID()).put(FIELD_REPLY_TO, (Object)this.destination(message.getJMSReplyTo())).put(FIELD_DESTINATION, (Object)this.destination(message.getJMSDestination())).put(FIELD_REDELIVERED, (Object)message.getJMSRedelivered()).put(FIELD_TYPE, (Object)message.getJMSType()).put(FIELD_EXPIRATION, (Object)message.getJMSExpiration()).put(FIELD_PRIORITY, (Object)message.getJMSPriority()).put(FIELD_PROPERTIES, properties);
        if (message instanceof BytesMessage) {
            this.process((BytesMessage)message, messageID, value);
        } else if (message instanceof MapMessage) {
            this.process((MapMessage)message, messageID, value);
        } else if (message instanceof ObjectMessage) {
            this.process((ObjectMessage)message, messageID, value);
        } else if (message instanceof StreamMessage) {
            this.process((StreamMessage)message, messageID, value);
        } else if (message instanceof TextMessage) {
            this.process((TextMessage)message, messageID, value);
        }
        return new JmsSourceRecord(PARTITIONS, OFFSETS, this.config.topic, null, this.keySchema, key, this.valueSchema, value, message, messageID);
    }

    private void process(BytesMessage bytesMessage, String messageID, Struct value) throws JMSException {
        log.trace("record('{}') - Processing as BytesMessage", (Object)messageID);
        value.put(FIELD_MESSAGE_TYPE, (Object)FIELD_BYTES);
        int bufferLength = (int)bytesMessage.getBodyLength();
        log.trace("record('{}') - allocating buffer of {} byte(s).", (Object)bytesMessage, (Object)bufferLength);
        byte[] buffer = new byte[bufferLength];
        bytesMessage.readBytes(buffer);
        value.put(FIELD_BYTES, (Object)buffer);
    }

    private void process(MapMessage mapMessage, String messageID, Struct value) throws JMSException {
        log.trace("record('{}') - Processing as MapMessage", (Object)messageID);
        Enumeration mapNames = mapMessage.getMapNames();
        LinkedHashMap<String, Struct> mapFieldValues = new LinkedHashMap<String, Struct>();
        while (mapNames.hasMoreElements()) {
            String mapKey = (String)mapNames.nextElement();
            log.trace("record('{}') - Processing map key '{}'", (Object)messageID, (Object)mapKey);
            Object mapValue = mapMessage.getObject(mapKey);
            Struct mapStruct = this.propertyValueStruct(messageID, mapValue);
            mapFieldValues.put(mapKey, mapStruct);
        }
        value.put(FIELD_MESSAGE_TYPE, (Object)FIELD_MAP);
        value.put(FIELD_MAP, mapFieldValues);
    }

    private void process(ObjectMessage objectMessage, String messageID, Struct value) throws JMSException {
        log.trace("record('{}') - Processing as ObjectMessage", (Object)messageID);
        value.put(FIELD_MESSAGE_TYPE, (Object)FIELD_OBJECT);
    }

    private void process(StreamMessage streamMessage, String messageID, Struct value) throws JMSException {
        log.trace("record('{}') - Processing as StreamMessage", (Object)messageID);
        value.put(FIELD_MESSAGE_TYPE, (Object)FIELD_STREAM);
    }

    private void process(TextMessage textMessage, String messageID, Struct value) throws JMSException {
        log.trace("record('{}') - Processing as TextMessage", (Object)messageID);
        value.put(FIELD_MESSAGE_TYPE, (Object)FIELD_TEXT);
        value.put(FIELD_TEXT, (Object)textMessage.getText());
    }

    private Struct propertyValueStruct(String messageID, Object propertyValue) {
        String type;
        Struct propertyStruct = new Struct(this.propertyValueSchema);
        if (propertyValue == null) {
            type = FIELD_NULL;
        } else if (propertyValue instanceof Boolean) {
            type = FIELD_BOOLEAN;
        } else if (propertyValue instanceof Byte) {
            type = FIELD_BYTE;
        } else if (propertyValue instanceof Short) {
            type = FIELD_SHORT;
        } else if (propertyValue instanceof Integer) {
            type = FIELD_INTEGER;
        } else if (propertyValue instanceof Long) {
            type = FIELD_LONG;
        } else if (propertyValue instanceof Float) {
            type = FIELD_FLOAT;
        } else if (propertyValue instanceof Double) {
            type = FIELD_DOUBLE;
        } else if (propertyValue instanceof String) {
            type = FIELD_STRING;
        } else {
            throw new UnsupportedOperationException(propertyValue.getClass() + " is not supported.");
        }
        log.trace("record('{}') - Setting field('{}') to '{}'.", new Object[]{messageID, FIELD_PROPERTY_TYPE, type});
        propertyStruct.put(FIELD_PROPERTY_TYPE, (Object)type);
        if (propertyValue != null) {
            log.trace("record('{}') - Setting field('{}') with value.", (Object)messageID, (Object)type);
            propertyStruct.put(type, propertyValue);
        }
        return propertyStruct;
    }

    private void setPropertyValue(MapMessage message, String propertyName, Struct propertyValue) throws JMSException {
        String type = propertyValue.getString(FIELD_PROPERTY_TYPE);
        if (FIELD_BOOLEAN.equals(type)) {
            message.setBoolean(propertyName, propertyValue.getBoolean(type).booleanValue());
        } else if (FIELD_BYTE.equals(type)) {
            message.setByte(propertyName, propertyValue.getInt8(type).byteValue());
        } else if (FIELD_SHORT.equals(type)) {
            message.setShort(propertyName, propertyValue.getInt16(type).shortValue());
        } else if (FIELD_INTEGER.equals(type)) {
            message.setInt(propertyName, propertyValue.getInt32(type).intValue());
        } else if (FIELD_LONG.equals(type)) {
            message.setLong(propertyName, propertyValue.getInt64(type).longValue());
        } else if (FIELD_FLOAT.equals(type)) {
            message.setFloat(propertyName, propertyValue.getFloat32(type).floatValue());
        } else if (FIELD_DOUBLE.equals(type)) {
            message.setDouble(propertyName, propertyValue.getFloat64(type).doubleValue());
        } else if (FIELD_STRING.equals(type)) {
            message.setString(propertyName, propertyValue.getString(type));
        } else {
            throw new UnsupportedOperationException("Property type '" + type + "' is not supported.");
        }
    }

    static {
        log = LoggerFactory.getLogger(RecordConverter.class);
        KEY_SCHEMA = SchemaBuilder.struct().name("io.confluent.connect.jms.Key").doc(KEY_SCHEMA_DOC).field(FIELD_MESSAGE_ID, SchemaBuilder.string().doc(FIELD_MESSAGE_ID_DOC).build()).build();
        KEY_SCHEMA_PERMISSIVE = SchemaBuilder.struct().name("io.confluent.connect.jms.Key").doc(KEY_SCHEMA_DOC).field(FIELD_MESSAGE_ID, SchemaBuilder.string().optional().doc(FIELD_MESSAGE_ID_DOC).build()).optional().build();
        PROPERTY_VALUE_SCHEMA_PERMISSIVE = PROPERTY_VALUE_SCHEMA = SchemaBuilder.struct().name("io.confluent.connect.jms.PropertyValue").doc(PROPERTY_VALUE_SCHEMA_DOC).field(FIELD_PROPERTY_TYPE, SchemaBuilder.string().doc(FIELD_PROPERTY_TYPE_DOC).build()).field(FIELD_BOOLEAN, SchemaBuilder.bool().optional().doc(FIELD_BOOLEAN_DOC).build()).field(FIELD_BYTE, SchemaBuilder.int8().optional().doc(FIELD_BYTE_DOC).build()).field(FIELD_SHORT, SchemaBuilder.int16().optional().doc(FIELD_SHORT_DOC).build()).field(FIELD_INTEGER, SchemaBuilder.int32().optional().doc(FIELD_INTEGER_DOC).build()).field(FIELD_LONG, SchemaBuilder.int64().optional().doc(FIELD_LONG_DOC).build()).field(FIELD_FLOAT, SchemaBuilder.float32().optional().doc(FIELD_FLOAT_DOC).build()).field(FIELD_DOUBLE, SchemaBuilder.float64().optional().doc(FIELD_DOUBLE_DOC).build()).field(FIELD_STRING, SchemaBuilder.string().optional().doc(FIELD_STRING_DOC).build()).build();
        DESTINATION_SCHEMA_PERMISSIVE = DESTINATION_SCHEMA = SchemaBuilder.struct().name("io.confluent.connect.jms.Destination").optional().doc(DESTINATION_SCHEMA_DOC).field(FIELD_DESTINATION_TYPE, SchemaBuilder.string().doc(FIELD_DESTINATION_TYPE_DOC).build()).field(FIELD_NAME, SchemaBuilder.string().doc(FIELD_NAME_DOC).build()).build();
        VALUE_SCHEMA = SchemaBuilder.struct().name("io.confluent.connect.jms.Value").doc(VALUE_SCHEMA_DOC).field(FIELD_MESSAGE_ID, SchemaBuilder.string().doc(FIELD_MESSAGE_ID_DOC).build()).field(FIELD_MESSAGE_TYPE, SchemaBuilder.string().doc(FIELD_MESSAGE_TYPE_DOC).build()).field(FIELD_TIMESTAMP, SchemaBuilder.int64().doc(FIELD_TIMESTAMP_DOC).build()).field(FIELD_DELIVERY_MODE, SchemaBuilder.int32().doc(FIELD_DELIVERY_MODE_DOC).build()).field(FIELD_CORRELATION_ID, SchemaBuilder.string().optional().doc(FIELD_CORRELATION_ID_DOC).build()).field(FIELD_REPLY_TO, DESTINATION_SCHEMA).field(FIELD_DESTINATION, DESTINATION_SCHEMA).field(FIELD_REDELIVERED, SchemaBuilder.bool().doc(FIELD_REDELIVERED_DOC).build()).field(FIELD_TYPE, SchemaBuilder.string().optional().doc(FIELD_TYPE_DOC).build()).field(FIELD_EXPIRATION, SchemaBuilder.int64().doc(FIELD_EXPIRATION_DOC).build()).field(FIELD_PRIORITY, SchemaBuilder.int32().doc(FIELD_PRIORITY_DOC).build()).field(FIELD_PROPERTIES, SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)PROPERTY_VALUE_SCHEMA).doc(FIELD_PROPERTIES_DOC).build()).field(FIELD_BYTES, SchemaBuilder.bytes().optional().doc(FIELD_BYTES_DOC).build()).field(FIELD_MAP, SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)PROPERTY_VALUE_SCHEMA).optional().doc(FIELD_MAP_DOC).build()).field(FIELD_TEXT, SchemaBuilder.string().optional().doc(FIELD_TEXT_DOC).build()).build();
        VALUE_SCHEMA_PERMISSIVE = SchemaBuilder.struct().name("io.confluent.connect.jms.Value").doc(VALUE_SCHEMA_DOC).field(FIELD_MESSAGE_ID, SchemaBuilder.string().optional().doc(FIELD_MESSAGE_ID_DOC).build()).field(FIELD_MESSAGE_TYPE, SchemaBuilder.string().doc(FIELD_MESSAGE_TYPE_DOC).build()).field(FIELD_TIMESTAMP, SchemaBuilder.int64().doc(FIELD_TIMESTAMP_DOC).build()).field(FIELD_DELIVERY_MODE, SchemaBuilder.int32().doc(FIELD_DELIVERY_MODE_DOC).build()).field(FIELD_CORRELATION_ID, SchemaBuilder.string().optional().doc(FIELD_CORRELATION_ID_DOC).build()).field(FIELD_REPLY_TO, DESTINATION_SCHEMA_PERMISSIVE).field(FIELD_DESTINATION, DESTINATION_SCHEMA_PERMISSIVE).field(FIELD_REDELIVERED, SchemaBuilder.bool().doc(FIELD_REDELIVERED_DOC).build()).field(FIELD_TYPE, SchemaBuilder.string().optional().doc(FIELD_TYPE_DOC).build()).field(FIELD_EXPIRATION, SchemaBuilder.int64().doc(FIELD_EXPIRATION_DOC).build()).field(FIELD_PRIORITY, SchemaBuilder.int32().doc(FIELD_PRIORITY_DOC).build()).field(FIELD_PROPERTIES, SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)PROPERTY_VALUE_SCHEMA_PERMISSIVE).doc(FIELD_PROPERTIES_DOC).build()).field(FIELD_BYTES, SchemaBuilder.bytes().optional().doc(FIELD_BYTES_DOC).build()).field(FIELD_MAP, SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)PROPERTY_VALUE_SCHEMA_PERMISSIVE).optional().doc(FIELD_MAP_DOC).build()).field(FIELD_TEXT, SchemaBuilder.string().optional().doc(FIELD_TEXT_DOC).build()).build();
    }
}

