/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils;

import io.confluent.connect.utils.Strings;
import java.util.Objects;

public class HostAndPort {
    static final int NO_PORT = -1;
    private final String host;
    private final int port;

    public static HostAndPort fromString(String hostAndPort) {
        String port;
        String host;
        Objects.requireNonNull(hostAndPort);
        if (hostAndPort.startsWith("[")) {
            int closingBracketIndex = hostAndPort.indexOf(93);
            if (closingBracketIndex == -1) {
                throw new IllegalArgumentException("Malformed host and port is missing closing bracket: '" + hostAndPort + "'");
            }
            host = hostAndPort.substring(1, closingBracketIndex);
            if (closingBracketIndex + 1 == hostAndPort.length()) {
                port = null;
            } else {
                if (hostAndPort.charAt(closingBracketIndex + 1) != ':') {
                    throw new IllegalArgumentException("Malformed host and port is missing colon after host brackets: '" + hostAndPort + "'");
                }
                if (closingBracketIndex + 2 == hostAndPort.length()) {
                    throw new IllegalArgumentException("Malformed host and port ends with colon and is missing port: '" + hostAndPort + "'");
                }
                port = hostAndPort.substring(closingBracketIndex + 2);
            }
        } else {
            int colonIndex = hostAndPort.indexOf(58);
            if (colonIndex != -1 && hostAndPort.lastIndexOf(58) == colonIndex) {
                host = hostAndPort.substring(0, colonIndex);
                port = hostAndPort.substring(colonIndex + 1);
            } else {
                host = hostAndPort;
                port = null;
            }
        }
        return new HostAndPort(host, HostAndPort.parsePort(port));
    }

    protected static int parsePort(String portStr) {
        int portNumber = -1;
        if (!Strings.isNullOrEmpty(portStr)) {
            Integer portValue = Strings.parseInt(portStr);
            if (portValue == null) {
                throw new IllegalArgumentException("Invalid port value '" + portStr + "' must be an integer.");
            }
            portNumber = portValue;
            if (portNumber < 1 || portNumber > 65535) {
                throw new IllegalArgumentException("Invalid port value '" + portStr + "'. Must be between 1 and 65535.");
            }
        }
        return portNumber;
    }

    protected HostAndPort(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public boolean hasPort() {
        return this.port != -1;
    }

    public int getPort() {
        return this.port;
    }

    public int getPortOrDefault(int defaultPort) {
        return this.hasPort() ? this.getPort() : defaultPort;
    }

    public boolean requiresBracketsForIpv6() {
        return !this.hasPort() && this.isHostIpv6();
    }

    public boolean isHostIpv6() {
        return this.host.indexOf(58) != -1;
    }

    public HostAndPort withDefaultPort(int defaultPort) {
        return this.hasPort() ? this : new HostAndPort(this.host, defaultPort);
    }

    public int hashCode() {
        return this.host.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof HostAndPort) {
            HostAndPort that = (HostAndPort)obj;
            return Objects.equals(this.getHost(), that.getHost()) && this.getPort() == that.getPort();
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isHostIpv6()) {
            sb.append('[').append(this.host).append(']');
        } else {
            sb.append(this.host);
        }
        if (this.hasPort()) {
            sb.append(':').append(this.getPort());
        }
        return sb.toString();
    }
}

