/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils;

public class Strings {
    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    @SafeVarargs
    public static <T> String join(CharSequence delim, T ... values) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (T value : values) {
            if (first) {
                first = false;
            } else {
                sb.append(delim);
            }
            if (value != null) {
                sb.append(value.toString());
                continue;
            }
            sb.append("null");
        }
        return sb.toString();
    }

    public static String repeat(CharSequence toRepeat, int count) {
        StringBuilder sb = new StringBuilder();
        if (count > 0) {
            for (int i = 0; i != count; ++i) {
                sb.append(toRepeat);
            }
        }
        return sb.toString();
    }

    public static Integer parseInt(String str) {
        if (str != null) {
            try {
                Long value = Long.parseLong(str);
                if ((long)value.intValue() == value) {
                    return value.intValue();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

