/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.config;

import io.confluent.connect.utils.HostAndPort;
import io.confluent.connect.utils.Strings;
import io.confluent.connect.utils.config.ValidHostnameAndPort;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class ConfigUtils {
    public static <T> Class<T> getClass(AbstractConfig config, String key, Class<T> expected) {
        Objects.requireNonNull(config, "config cannot be null");
        Objects.requireNonNull(key, "key cannot be null");
        Objects.requireNonNull(expected, "expected cannot be null");
        Class cls = config.getClass(key);
        if (!expected.isAssignableFrom(cls)) {
            throw new IllegalArgumentException(expected.getSimpleName() + "is not assignable from " + cls.getSimpleName());
        }
        return cls;
    }

    public static <T extends Enum<T>> T getEnum(Class<T> enumClass, AbstractConfig config, String key) {
        Objects.requireNonNull(enumClass, "enumClass cannot be null");
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException("enumClass must be an enum.");
        }
        String textValue = config.getString(key);
        return Enum.valueOf(enumClass, textValue);
    }

    public static String enumValues(Class<?> enumClass) {
        Objects.requireNonNull(enumClass, "enumClass cannot be null");
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException("enumClass must be an enum.");
        }
        return Strings.join(", ", enumClass.getEnumConstants());
    }

    public static File getAbsoluteFile(AbstractConfig config, String key) {
        Objects.requireNonNull(config, "config cannot be null");
        String path = config.getString(key);
        File file = new File(path);
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("'" + key + "' must be an absolute path.");
        }
        return new File(path);
    }

    static InetSocketAddress parseInetSocketAddress(String s) {
        Objects.requireNonNull(s, "s cannot be null.");
        Matcher matcher = ValidHostnameAndPort.HOSTNAME_PATTERN.matcher(s);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("'" + s + "' does not match '" + ValidHostnameAndPort.HOSTNAME_PATTERN.pattern());
        }
        Integer port = Strings.parseInt(matcher.group(2));
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Invalid port value '" + port + "'. Must be between 1 and 65535.");
        }
        return new InetSocketAddress(matcher.group(1), (int)port);
    }

    public static InetSocketAddress inetSocketAddress(AbstractConfig config, String key) {
        Objects.requireNonNull(config, "config cannot be null");
        String value = config.getString(key);
        return ConfigUtils.parseInetSocketAddress(value);
    }

    public static List<InetSocketAddress> inetSocketAddresses(AbstractConfig config, String key) {
        Objects.requireNonNull(config, "config cannot be null");
        List value = config.getList(key);
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>(value.size());
        for (String s : value) {
            addresses.add(ConfigUtils.parseInetSocketAddress(s));
        }
        return Collections.unmodifiableList(new ArrayList(addresses));
    }

    static HostAndPort hostAndPort(String input, Integer defaultPort) {
        HostAndPort result = HostAndPort.fromString(input);
        if (defaultPort != null) {
            result = result.withDefaultPort(defaultPort);
        }
        return result;
    }

    public static List<HostAndPort> hostAndPorts(AbstractConfig config, String key, Integer defaultPort) {
        List inputs = config.getList(key);
        ArrayList<HostAndPort> result = new ArrayList<HostAndPort>();
        for (String input : inputs) {
            HostAndPort hostAndPort = ConfigUtils.hostAndPort(input, defaultPort);
            result.add(hostAndPort);
        }
        return Collections.unmodifiableList(new ArrayList(result));
    }

    public static List<HostAndPort> hostAndPorts(AbstractConfig config, String key) {
        return ConfigUtils.hostAndPorts(config, key, null);
    }

    public static int keysInGroup(ConfigDef configDef, String groupName) {
        int numKeys = 0;
        for (ConfigDef.ConfigKey key : configDef.configKeys().values()) {
            if (key.group == null || !key.group.equals(groupName)) continue;
            ++numKeys;
        }
        return numKeys;
    }
}

