/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.config;

import io.confluent.connect.utils.HostAndPort;
import io.confluent.connect.utils.Strings;
import java.util.List;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class ValidHostAndPort
implements ConfigDef.Validator {
    private final Integer defaultPort;
    private final boolean portRequired;

    public static ValidHostAndPort of() {
        return new ValidHostAndPort(null, true);
    }

    public static ValidHostAndPort of(Integer defaultPort, boolean portRequired) {
        return new ValidHostAndPort(defaultPort, portRequired);
    }

    private ValidHostAndPort(Integer defaultPort, boolean portRequired) {
        this.defaultPort = defaultPort;
        this.portRequired = portRequired;
    }

    private void validate(String setting, String input) {
        HostAndPort hostAndPort = HostAndPort.fromString(input);
        if (null != this.defaultPort) {
            hostAndPort.withDefaultPort(this.defaultPort);
        }
        if (Strings.isNullOrEmpty(hostAndPort.getHost())) {
            throw new ConfigException(String.format("'%s'(%s) host cannot be blank or null.", setting, input));
        }
        if (this.portRequired && !hostAndPort.hasPort()) {
            throw new ConfigException(String.format("'%s'(%s) must specify a port.", setting, input));
        }
    }

    public void ensureValid(String setting, Object value) {
        if (value instanceof String) {
            String input = (String)value;
            this.validate(setting, input);
        } else if (value instanceof List) {
            List inputs = (List)value;
            for (Object input : inputs) {
                this.validate(setting, input.toString());
            }
        } else {
            throw new ConfigException(String.format("'%s' must be a String or List", setting));
        }
    }

    public String toString() {
        return "One or more comma-separated host-port pairs";
    }
}

