/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.config;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidHostnameAndPort
implements ConfigDef.Validator {
    private static final Logger log = LoggerFactory.getLogger(ValidHostnameAndPort.class);
    static final Pattern HOSTNAME_PATTERN = Pattern.compile("^(.+)\\:(\\d{1,5})$");

    public void ensureValid(String key, Object value) {
        block8: {
            log.trace("ensureValid('{}', '{}')", (Object)key, value);
            if (value instanceof String) {
                try {
                    Matcher matcher = HOSTNAME_PATTERN.matcher((CharSequence)value);
                    if (!matcher.matches()) {
                        throw new IllegalArgumentException("'" + key + "' does not match pattern '" + HOSTNAME_PATTERN.pattern());
                    }
                    int port = Integer.parseInt(matcher.group(2));
                    if (port < 1 || port > 65535) {
                        throw new IllegalArgumentException("'" + key + "' port value " + port + " must be between 1 and 65535.");
                    }
                    break block8;
                }
                catch (Exception ex) {
                    throw new ConfigException(String.format("'%s' is not a valid hostname and port.", key), (Object)ex);
                }
            }
            if (value instanceof List) {
                List list = (List)value;
                for (Object s : list) {
                    this.ensureValid(key, s);
                }
            } else {
                throw new ConfigException(String.format("'%s' must be a string or a list.", key));
            }
        }
    }

    public static ValidHostnameAndPort of() {
        return new ValidHostnameAndPort();
    }
}

