/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.docs;

import io.confluent.connect.utils.docs.RstDocument;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DocumentationTestBase {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    protected void generate(String relativePath, RstDocument rst) throws IOException {
        this.generate(relativePath, rst.toString());
    }

    protected void generate(String relativePath, String content) throws IOException {
        Path docsPath = Paths.get("docs", new String[0]);
        if (!Files.exists(docsPath, new LinkOption[0]) || !Files.isDirectory(docsPath, new LinkOption[0])) {
            Path missing = docsPath.toAbsolutePath();
            throw new IOException("Unable to write to documentation file " + relativePath + " because the '" + missing + "' directory does not exist");
        }
        Path path = Paths.get("docs", relativePath).toAbsolutePath();
        File file = path.toAbsolutePath().toFile();
        this.log.info("Writing documentation at {}", (Object)path);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
            writer.append(content);
        }
        this.log.info("Updated documentation at {}", (Object)path);
    }

    protected void addConnectorLicensingContent(RstDocument rst, String anchor, String configPrefix) {
        if (!configPrefix.endsWith(".")) {
            configPrefix = configPrefix + ".";
        }
        rst.anchor(anchor);
        rst.heading3("Confluent Licensing");
        rst.newLine();
        rst.line("The connector requires a |cpe| license, which is stored inside Kafka in a topic. The connector must be configured with Kafka client configuration properties so that it can connect to Kafka and validate the license.");
        rst.line("To configure the clients used for the license topic add the standard producer, consumer, and topic configuration properties to the connector properties, prefixed with ``" + configPrefix + "``.");
        rst.line("Do not specify the serializers and deserializers. If specified here, they will be ignored.");
        rst.newLine();
        rst.line("If the connector does not exist, you might need to create the license topic.");
        rst.line("This allows you to override the replication factor and other topic configuration properties using the same ``" + configPrefix + "`` prefix.");
        rst.line("You cannot override the cleanup policy of a topic because the topic always has a single partition and is compacted.");
        rst.newLine();
        rst.line("For example, here's an example of the licensing-related properties that should be included in the connector configuration:");
        ((RstDocument.CodeBlock)((RstDocument.CodeBlock)rst.codeBlock("bash").line("confluent.license=")).line(configPrefix + "bootstrap.servers" + "=localhost:9092")).end();
        rst.line("Set the ``confluent.license`` property with the license you get from Confluent support, or leave it blank for a 30-day trial.");
        rst.newLine();
        ((RstDocument.Note)rst.note().line("When using a Kafka cluster as destination with fewer than three brokers (e.g., when testing locally) you should set the ``" + configPrefix + "replication.factor`` property to ``1``.")).end();
        rst.newLine();
        rst.line("Other properties have defaults but can be specified as needed.");
        rst.line("For example, the ``" + configPrefix + "client.id" + "`` property defaults to ");
        rst.line("the name of the connector with ``-licensing`` suffix. ");
        rst.line("Specify the configurations settings for brokers that require SSL or SASL for client connections here.");
        rst.newLine();
        rst.line("If necessary, you can override producer-specific properties by using the ``" + configPrefix + "producer.`` and you can override consumer-specific properties with the ``" + configPrefix + "consumer.`` prefix.");
        rst.newLine();
    }
}

