/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.docs;

import io.confluent.connect.utils.Strings;
import io.confluent.connect.utils.docs.SchemaDocumentation;
import io.confluent.connect.utils.docs.SchemaLinks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.data.Schema;

public class RstDocument {
    private final StringBuilder sb = new StringBuilder();

    public RstDocument append(Object obj) {
        if (obj != null) {
            this.sb.append(obj);
        }
        return this;
    }

    public RstDocument append(String str) {
        if (str != null) {
            this.sb.append(str);
        }
        return this;
    }

    public RstDocument append(char c) {
        this.sb.append(c);
        return this;
    }

    public RstDocument append(char c, int count) {
        if (count > 0) {
            for (int i = 0; i != count; ++i) {
                this.sb.append(c);
            }
        }
        return this;
    }

    public RstDocument append(ConfigDef configDef) {
        this.sb.append(configDef.toEnrichedRst());
        this.newLine();
        return this;
    }

    public RstDocument append(Schema schema) {
        return this.append(schema, null);
    }

    public RstDocument append(Schema schema, SchemaLinks links) {
        this.sb.append(SchemaDocumentation.toEnrichedRst(schema, links));
        this.newLine();
        return this;
    }

    public RstDocument appendFixedWidth(Object value, int length) {
        return this.appendFixedWidth(value, length, ' ');
    }

    public RstDocument appendFixedWidth(Object value, int length, char padChar) {
        String s;
        String string = s = value != null ? value.toString() : "";
        if (s.length() > length) {
            s = s.substring(0, length);
        }
        this.sb.append(s);
        this.append(padChar, length - s.length());
        return this;
    }

    public RstDocument newLine() {
        this.sb.append("\n");
        return this;
    }

    public RstDocument line(String line) {
        if (line != null) {
            this.append(line);
            this.newLine();
        }
        return this;
    }

    public TableOfContents tableOfContents() {
        this.newLine();
        this.line(".. toctree::");
        return new TableOfContents();
    }

    public CodeBlock codeBlock(String language) {
        this.newLine();
        this.append(".. sourcecode::");
        if (language != null && !language.isEmpty()) {
            this.append(" ");
            this.append(language);
            this.newLine();
        }
        return new CodeBlock();
    }

    public Note note() {
        this.newLine();
        this.append(".. note::");
        return new Note();
    }

    public RstDocument include(String docName) {
        this.sb.append(".. include:: " + docName);
        this.newLine();
        return this;
    }

    public RstDocument link(String text, String link) {
        this.sb.append("`").append(text).append(" <").append(link).append(">`_");
        this.newLine();
        return this;
    }

    public RstDocument linkToAnchor(String text, String anchorName) {
        this.sb.append(":ref:`").append(text).append(" <").append(anchorName).append(">`");
        return this;
    }

    public RstDocument anchor(String anchorName) {
        this.newLine();
        this.sb.append(".. _").append(anchorName).append(":");
        this.newLine();
        this.newLine();
        return this;
    }

    public RstDocument title(String title) {
        this.sb.append(title);
        this.newLine();
        this.append('=', title.length());
        this.newLine();
        this.newLine();
        return this;
    }

    public RstDocument heading1(String name) {
        this.newLine();
        this.sb.append(name);
        this.newLine();
        this.append('-', name.length());
        this.newLine();
        this.newLine();
        return this;
    }

    public RstDocument heading2(String name) {
        this.newLine();
        this.sb.append(name);
        this.newLine();
        this.append('^', name.length());
        this.newLine();
        this.newLine();
        return this;
    }

    public RstDocument heading3(String name) {
        this.newLine();
        this.sb.append(name);
        this.newLine();
        this.append('*', name.length());
        this.newLine();
        this.newLine();
        return this;
    }

    public RstDocument appendParagraphs(String content) {
        if (content == null) {
            return this;
        }
        for (String docLine : content.split("\n")) {
            if (docLine.length() == 0) continue;
            this.sb.append(docLine);
            this.newLine();
            this.newLine();
        }
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }

    protected static String[] paragraphsFrom(String content) {
        return content.split("[\\n\\r]");
    }

    public <T> Table<T> gridTable(List<Column<T>> columns, Iterable<T> rows) {
        return new Table<T>(columns, rows, new GridTableFormat());
    }

    public <T> Table<T> simpleTable(List<Column<T>> columns, Iterable<T> rows) {
        return new Table<T>(columns, rows, new SimpleTableFormat());
    }

    protected static class SimpleTableFormat<T>
    implements TableFormat<T> {
        protected SimpleTableFormat() {
        }

        @Override
        public void beforeFirstColumnInRow(RstDocument rst) {
        }

        @Override
        public void betweenColumnsInRow(RstDocument rst) {
            rst.append("    ");
        }

        @Override
        public void afterLastColumnInRow(RstDocument rst) {
        }

        @Override
        public void beforeHeader(RstDocument rst, List<Column<T>> columns) {
            for (Column<T> column : columns) {
                column.appendHeaderDelimiter(rst, '=');
                rst.append("    ");
            }
            rst.newLine();
        }

        @Override
        public void afterHeader(RstDocument rst, List<Column<T>> columns) {
            this.beforeHeader(rst, columns);
        }

        @Override
        public void betweenRows(RstDocument rst, List<Column<T>> columns) {
        }

        @Override
        public void afterRows(RstDocument rst, List<Column<T>> columns) {
            this.beforeHeader(rst, columns);
        }
    }

    protected static class GridTableFormat<T>
    implements TableFormat<T> {
        protected GridTableFormat() {
        }

        @Override
        public void beforeFirstColumnInRow(RstDocument rst) {
            rst.append("| ");
        }

        @Override
        public void betweenColumnsInRow(RstDocument rst) {
            rst.append(" | ");
        }

        @Override
        public void afterLastColumnInRow(RstDocument rst) {
            rst.append(" |");
        }

        @Override
        public void beforeHeader(RstDocument rst, List<Column<T>> columns) {
            this.delimiterLine(rst, columns, '-');
        }

        @Override
        public void afterHeader(RstDocument rst, List<Column<T>> columns) {
            this.delimiterLine(rst, columns, '=');
        }

        @Override
        public void betweenRows(RstDocument rst, List<Column<T>> columns) {
            this.delimiterLine(rst, columns, '-');
        }

        protected void delimiterLine(RstDocument rst, List<Column<T>> columns, char c) {
            rst.append("+");
            for (Column<T> column : columns) {
                rst.append(c);
                column.appendHeaderDelimiter(rst, c);
                rst.append(c);
                rst.append("+");
            }
            rst.newLine();
        }

        @Override
        public void afterRows(RstDocument rst, List<Column<T>> columns) {
            this.beforeHeader(rst, columns);
        }
    }

    protected static interface TableFormat<T> {
        public void beforeHeader(RstDocument var1, List<Column<T>> var2);

        public void afterHeader(RstDocument var1, List<Column<T>> var2);

        public void betweenRows(RstDocument var1, List<Column<T>> var2);

        public void afterRows(RstDocument var1, List<Column<T>> var2);

        public void beforeFirstColumnInRow(RstDocument var1);

        public void betweenColumnsInRow(RstDocument var1);

        public void afterLastColumnInRow(RstDocument var1);
    }

    public static class Column<T> {
        private final String name;
        private final ColumnGetter<T> getter;
        private int width;

        public Column(String name, ColumnGetter<T> getter) {
            this.name = name;
            this.getter = getter;
            this.width = name.length();
        }

        protected void computeWidth(Iterable<T> rows) {
            for (T row : rows) {
                Object value = this.getter.get(row);
                if (value == null) continue;
                this.width = Math.max(this.width, value.toString().length());
            }
        }

        protected void appendHeaderDelimiter(RstDocument rst, char c) {
            rst.append(c, this.width);
        }

        protected void appendHeaderName(RstDocument rst) {
            rst.appendFixedWidth(this.name, this.width);
        }

        protected void appendRowLine(RstDocument rst, String line) {
            if (line == null) {
                line = "";
            }
            rst.appendFixedWidth(line, this.width);
        }

        protected String[] rowLines(T row) {
            Object value = this.getter.get(row);
            if (value == null) {
                value = "";
            }
            return RstDocument.paragraphsFrom(value.toString());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Column) {
                Column that = (Column)obj;
                return this.name.equals(that.name);
            }
            return false;
        }

        public String toString() {
            return this.name + " (" + this.width + ")";
        }
    }

    public static interface ColumnGetter<T> {
        public Object get(T var1);
    }

    public static class Table<T> {
        private static final boolean INCLUDE_SPACE = true;
        private final List<Column<T>> columns;
        private final List<T> rows;
        private final TableFormat<T> format;

        protected Table(List<Column<T>> columns, Iterable<T> rows, TableFormat<T> format) {
            this.format = format;
            this.columns = columns;
            this.rows = new ArrayList<T>();
            for (T t : rows) {
                this.rows.add(t);
            }
            for (Column column : columns) {
                column.computeWidth(rows);
            }
        }

        public void appendTo(RstDocument rst) {
            rst.newLine();
            this.format.beforeHeader(rst, this.columns);
            this.appendColumnNames(rst);
            this.format.afterHeader(rst, this.columns);
            for (int i = 0; i != this.rows.size(); ++i) {
                if (i != 0) {
                    this.format.betweenRows(rst, this.columns);
                }
                this.appendRow(rst, this.rows.get(i));
            }
            this.format.afterRows(rst, this.columns);
            rst.newLine();
        }

        protected void addSpace(RstDocument rst, char c) {
            rst.append(c);
        }

        protected void appendColumnNames(RstDocument rst) {
            this.format.beforeFirstColumnInRow(rst);
            for (int i = 0; i != this.columns.size(); ++i) {
                if (i != 0) {
                    this.format.betweenColumnsInRow(rst);
                }
                Column<T> column = this.columns.get(i);
                column.appendHeaderName(rst);
            }
            this.format.afterLastColumnInRow(rst);
            rst.newLine();
        }

        protected void appendRow(RstDocument rst, T field) {
            HashMap<Column<T>, String[]> linesByColumns = new HashMap<Column<T>, String[]>();
            int maxLineCount = 0;
            for (Column<T> column : this.columns) {
                String[] lines = column.rowLines(field);
                linesByColumns.put(column, lines);
                maxLineCount = Math.max(maxLineCount, lines.length);
            }
            for (int lineNum = 0; lineNum != maxLineCount; ++lineNum) {
                this.format.beforeFirstColumnInRow(rst);
                for (int i = 0; i != this.columns.size(); ++i) {
                    Column<T> column = this.columns.get(i);
                    String[] lines = (String[])linesByColumns.get(column);
                    String line = "";
                    if (lines.length > lineNum) {
                        line = lines[lineNum];
                    }
                    if (i != 0) {
                        this.format.betweenColumnsInRow(rst);
                    }
                    column.appendRowLine(rst, line);
                }
                this.format.afterLastColumnInRow(rst);
                rst.newLine();
            }
        }
    }

    public class TableOfContents {
        protected static final String INDENTATION = "   ";
        private final Options options;

        public TableOfContents() {
            this.options = new Options();
        }

        public TableOfContents enableGlobbing() {
            if (this.options.enable("globbing")) {
                RstDocument.this.append(INDENTATION);
                RstDocument.this.line(":glob:");
            }
            return this;
        }

        public TableOfContents numbered() {
            if (this.options.enable("numbered")) {
                RstDocument.this.append(INDENTATION);
                RstDocument.this.line(":numbered:");
            }
            return this;
        }

        public TableOfContents caption(String caption) {
            if (this.options.enable("caption") && caption != null) {
                RstDocument.this.append(INDENTATION);
                RstDocument.this.line(":caption: " + caption);
            }
            return this;
        }

        public TableOfContents maxDepth(int maxDepth) {
            if (maxDepth > 0 && this.options.enable("maxdepth")) {
                RstDocument.this.append(INDENTATION);
                RstDocument.this.line(":maxdepth: " + maxDepth);
            }
            return this;
        }

        public TableOfContents entry(String docName) {
            return this.entry(docName, null);
        }

        public TableOfContents entry(String docNameOrUrl, String title) {
            if (this.options.markCompleted()) {
                RstDocument.this.newLine();
            }
            RstDocument.this.append(INDENTATION);
            if (Strings.isNullOrEmpty(title)) {
                RstDocument.this.line(docNameOrUrl);
            } else {
                RstDocument.this.append(title);
                RstDocument.this.append(" <");
                RstDocument.this.append(docNameOrUrl);
                RstDocument.this.line(">");
            }
            return this;
        }

        public RstDocument end() {
            RstDocument.this.newLine();
            return RstDocument.this;
        }
    }

    public class Note
    extends Block<Note> {
        public Note link(String text, String link) {
            RstDocument.this.append("   ");
            RstDocument.this.link(text, link);
            return this;
        }

        public Note linkToAnchor(String text, String anchorName) {
            RstDocument.this.append("   ");
            RstDocument.this.linkToAnchor(text, anchorName);
            return this;
        }

        @Override
        protected Note getThis() {
            return this;
        }
    }

    public class CodeBlock
    extends Block<CodeBlock> {
        @Override
        protected CodeBlock getThis() {
            return this;
        }
    }

    protected abstract class Block<T extends Block> {
        protected static final String INDENTATION = "   ";
        private final Options options;

        protected Block() {
            this.options = new Options();
        }

        protected abstract T getThis();

        public T line(String line) {
            if (this.options.markCompleted()) {
                RstDocument.this.newLine();
            }
            RstDocument.this.append(INDENTATION);
            if (!Strings.isNullOrEmpty(line)) {
                RstDocument.this.append(line);
            }
            RstDocument.this.newLine();
            return this.getThis();
        }

        public RstDocument end() {
            RstDocument.this.newLine();
            return RstDocument.this;
        }
    }

    protected class Options {
        private final Set<String> features = new HashSet<String>();
        private boolean optionsComplete = false;

        protected Options() {
        }

        public boolean enable(String option) {
            return this.features.add(option);
        }

        protected boolean markCompleted() {
            if (!this.optionsComplete) {
                this.optionsComplete = true;
                return true;
            }
            return false;
        }
    }
}

