/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.docs;

import io.confluent.connect.utils.Strings;
import io.confluent.connect.utils.docs.RstDocument;
import io.confluent.connect.utils.docs.SchemaLinks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;

public class SchemaDocumentation {
    public static String toEnrichedRst(Schema schema, SchemaLinks links) {
        String anchorName;
        RstDocument rst = new RstDocument();
        if (links != null && !Strings.isNullOrEmpty(anchorName = links.anchorFor(schema))) {
            rst.anchor(anchorName);
        }
        if (schema.name() != null) {
            rst.heading2(schema.name());
        } else {
            rst.heading2("Schema");
        }
        rst.appendParagraphs(schema.doc());
        rst.line("The schema defines the following fields:");
        SchemaDocumentation.fieldTableFor(rst, schema, links).appendTo(rst);
        if (schema.parameters() != null && !schema.parameters().isEmpty()) {
            rst.line("The following parameters are defined on the schema:");
            SchemaDocumentation.parameterTableFor(rst, schema).appendTo(rst);
            rst.newLine();
        }
        return rst.toString();
    }

    protected static RstDocument.Table<Field> fieldTableFor(RstDocument rst, Schema schema, final SchemaLinks links) {
        ArrayList columns = new ArrayList();
        columns.add(new RstDocument.Column<Field>("Name", new RstDocument.ColumnGetter<Field>(){

            @Override
            public Object get(Field field) {
                return field.name();
            }
        }));
        columns.add(new RstDocument.Column<Field>("Schema", new RstDocument.ColumnGetter<Field>(){

            @Override
            public Object get(Field field) {
                Schema elementSchema;
                Schema schema = field.schema();
                if (links != null) {
                    return links.linkTo(schema);
                }
                Schema.Type type = schema.type();
                if (type.isPrimitive()) {
                    return schema.type();
                }
                if (type == Schema.Type.ARRAY && (elementSchema = schema.valueSchema()) != null) {
                    return "Array of " + elementSchema.name();
                }
                if (type == Schema.Type.MAP) {
                    Schema keySchema = schema.keySchema();
                    Schema valueSchema = schema.valueSchema();
                    if (keySchema != null && valueSchema != null) {
                        return "Map of " + keySchema.name() + ", " + valueSchema.name();
                    }
                }
                return field.schema().name();
            }
        }));
        columns.add(new RstDocument.Column<Field>("Required", new RstDocument.ColumnGetter<Field>(){

            @Override
            public Object get(Field field) {
                return field.schema().isOptional() ? "no" : "yes";
            }
        }));
        columns.add(new RstDocument.Column<Field>("Default Value", new RstDocument.ColumnGetter<Field>(){

            @Override
            public Object get(Field field) {
                return field.schema().defaultValue();
            }
        }));
        columns.add(new RstDocument.Column<Field>("Documentation", new RstDocument.ColumnGetter<Field>(){

            @Override
            public Object get(Field field) {
                return field.schema().doc();
            }
        }));
        return rst.gridTable(columns, schema.fields());
    }

    protected static RstDocument.Table<Map.Entry<String, String>> parameterTableFor(RstDocument rst, Schema schema) {
        ArrayList paramColumns = new ArrayList();
        paramColumns.add(new RstDocument.Column<Map.Entry<String, String>>("Name", new RstDocument.ColumnGetter<Map.Entry<String, String>>(){

            @Override
            public Object get(Map.Entry<String, String> entry) {
                return entry.getKey();
            }
        }));
        paramColumns.add(new RstDocument.Column<Map.Entry<String, String>>("Value", new RstDocument.ColumnGetter<Map.Entry<String, String>>(){

            @Override
            public Object get(Map.Entry<String, String> entry) {
                return entry.getValue();
            }
        }));
        HashMap params = schema.parameters();
        if (params == null) {
            params = new HashMap();
        }
        return rst.gridTable(paramColumns, params.entrySet());
    }
}

