/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.docs;

import io.confluent.connect.utils.docs.RstDocument;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.DataException;

public class SchemaLinks {
    private final Map<Schema, Link> schemaUrls = new HashMap<Schema, Link>();
    private final Map<Schema, Link> schemaAnchors = new HashMap<Schema, Link>();
    private boolean useShortSchemaNames = false;

    public SchemaLinks useShortSchemaNames(boolean useShortSchemaNames) {
        this.useShortSchemaNames = useShortSchemaNames;
        return this;
    }

    protected String schemaName(Schema schema) {
        int lastDot;
        String name = schema.name();
        if (name != null && this.useShortSchemaNames && (lastDot = name.lastIndexOf(46)) > 0 && ++lastDot < name.length()) {
            return name.substring(lastDot);
        }
        return name;
    }

    public SchemaLinks registerUrl(Schema schema, String urlOrAnchorName) {
        this.schemaUrls.put(schema, new Link(schema.name(), urlOrAnchorName));
        return this;
    }

    public SchemaLinks registerAnchor(Schema schema, String urlOrAnchorName) {
        this.schemaAnchors.put(schema, new Link(this.schemaName(schema), urlOrAnchorName));
        return this;
    }

    public String anchorFor(Schema schema) {
        Link link = this.schemaAnchors.get(schema);
        return link != null ? link.link : null;
    }

    public String linkTo(Schema schema) {
        Schema.Type type = schema.type();
        if (type == Schema.Type.ARRAY) {
            return this.linkToArray(schema);
        }
        if (type == Schema.Type.MAP) {
            return this.linkToMap(schema);
        }
        Link anchor = this.schemaAnchors.get(schema);
        if (anchor != null) {
            return new RstDocument().linkToAnchor(anchor.text, anchor.link).toString();
        }
        Link url = this.schemaUrls.get(schema);
        if (url != null) {
            return new RstDocument().link(url.text, url.link).toString();
        }
        if (schema.type().isPrimitive()) {
            return schema.type().getName().toUpperCase(Locale.getDefault());
        }
        return schema.name();
    }

    protected String linkToArray(Schema schema) {
        Schema elementSchema = schema.valueSchema();
        if (elementSchema != null) {
            return "Array of " + this.linkTo(elementSchema);
        }
        throw new DataException("The array schema does not have a schema for its value");
    }

    protected String linkToMap(Schema schema) {
        Schema keySchema = schema.keySchema();
        Schema valueSchema = schema.valueSchema();
        if (keySchema != null && valueSchema != null) {
            return "Map of " + this.linkTo(keySchema) + ", " + this.linkTo(valueSchema);
        }
        throw new DataException("The map schema does not have schemas for its key and value");
    }

    private static class Link {
        protected final String text;
        protected final String link;

        public Link(String text, String link) {
            this.text = text;
            this.link = link;
        }

        public String toString() {
            return "[" + this.text + "](" + this.link + ")";
        }
    }
}

