/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.licensing;

import io.confluent.connect.utils.function.Supplier;
import io.confluent.license.InvalidLicenseException;
import io.confluent.license.LicenseManager;
import java.util.Map;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectLicenseManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectLicenseManager.class);
    public static final String DEFAULT_TOPIC_NAME = "_confluent-command";
    private final Supplier<LicenseManager> licenseManagerSupplier;
    private final String license;

    public static Builder create() {
        return new Builder();
    }

    protected ConnectLicenseManager(String license, Supplier<LicenseManager> licenseManagerSupplier) {
        assert (licenseManagerSupplier != null);
        this.licenseManagerSupplier = licenseManagerSupplier;
        this.license = license;
    }

    public void registerOrValidateLicense() throws ConnectException {
        LicenseManager licenseManager = null;
        try {
            LOG.trace("Creating new license manager");
            licenseManager = this.licenseManagerSupplier.get();
            LOG.info("Validating Confluent License");
            licenseManager.registerOrValidateLicense(this.license);
        }
        catch (InvalidLicenseException e) {
            throw new ConnectException("Error validating license", (Throwable)e);
        }
        finally {
            if (licenseManager != null) {
                licenseManager.stop();
                LOG.trace("Stopped license manager");
            }
        }
    }

    public static class Builder {
        protected String topicName;
        protected Map<String, Object> producerProps;
        protected Map<String, Object> consumerProps;
        protected Map<String, Object> adminProps;
        protected String defaultClientId;
        protected String license;

        protected Builder() {
        }

        public Builder useLicense(String license) {
            this.license = license;
            return this;
        }

        public Builder useTopicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public Builder useProducerConfig(Map<String, Object> configuration) {
            this.producerProps = configuration;
            if (this.producerProps != null && this.producerProps.remove("replication.factor") != null) {
                LOG.debug("Removed {} property from the license manager producer configuration", (Object)"replication.factor");
            }
            return this;
        }

        public Builder useConsumerConfig(Map<String, Object> configuration) {
            this.consumerProps = configuration;
            if (this.consumerProps != null && this.consumerProps.remove("replication.factor") != null) {
                LOG.debug("Removed {} property from the license manager consumer configuration", (Object)"replication.factor");
            }
            return this;
        }

        public Builder useAdminConfig(Map<String, Object> configuration) {
            this.adminProps = configuration;
            return this;
        }

        public Builder useDefaultClientId(String defaultClientId) {
            this.defaultClientId = defaultClientId;
            return this;
        }

        protected void addDefaultClientId(Map<String, Object> props) {
            if (this.defaultClientId != null && props != null && !props.containsKey("client.id")) {
                props.put("client.id", this.defaultClientId);
            }
        }

        protected String topicName() {
            return this.topicName == null || this.topicName.trim().isEmpty() ? ConnectLicenseManager.DEFAULT_TOPIC_NAME : this.topicName;
        }

        protected String license() {
            return this.license;
        }

        protected Map<String, Object> producerConfig() {
            return this.producerProps;
        }

        protected Map<String, Object> consumerConfig() {
            return this.consumerProps;
        }

        protected Map<String, Object> consumerOrProducerConfig() {
            return this.consumerProps != null ? this.consumerProps : this.producerProps;
        }

        protected Map<String, Object> adminConfig() {
            return this.adminProps;
        }

        protected Map<String, Object> adminOrProducerConfig() {
            return this.adminProps != null ? this.adminProps : this.producerProps;
        }

        public ConnectLicenseManager build() {
            if (this.producerProps == null || this.producerProps.isEmpty()) {
                throw new IllegalStateException("Producer properties for license cannot be null or empty");
            }
            this.addDefaultClientId(this.consumerProps);
            this.addDefaultClientId(this.adminProps);
            this.addDefaultClientId(this.producerProps);
            return new ConnectLicenseManager(this.license(), new Supplier<LicenseManager>(){

                @Override
                public LicenseManager get() {
                    LOG.debug("Topic name for license manager: '{}'", (Object)this.topicName());
                    LOG.debug("Producer configs for license manager: {}", this.producerConfig());
                    LOG.debug("Consumer configs for license manager: {}", this.consumerOrProducerConfig());
                    LOG.debug("Topic admin configs for license manager: {}", this.adminOrProducerConfig());
                    return new LicenseManager(this.topicName(), this.producerConfig(), this.consumerOrProducerConfig(), this.adminOrProducerConfig());
                }
            });
        }
    }
}

