/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.utils.licensing;

import io.confluent.license.License;
import java.security.PublicKey;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseValidator
implements ConfigDef.Validator {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseValidator.class);

    public void ensureValid(String configKey, Object o) {
        String licenseStr = (String)o;
        if (!licenseStr.isEmpty()) {
            try {
                LicenseValidator.verify(licenseStr);
            }
            catch (Failure e) {
                throw new ConfigException(configKey, (Object)e);
            }
        }
    }

    public static void verify(String license) throws Failure {
        PublicKey publicKey;
        try {
            publicKey = License.loadPublicKey();
        }
        catch (Exception e) {
            throw new Failure("Failed to load public key", e);
        }
        LicenseValidator.verify(publicKey, license);
    }

    static void verify(PublicKey publicKey, String license) throws Failure {
        JwtClaims jwtClaims = LicenseValidator.getJwtClaims(publicKey, license);
        long expirationTimeMillis = Long.MIN_VALUE;
        try {
            expirationTimeMillis = License.getExpiration((JwtClaims)jwtClaims);
        }
        catch (Throwable t) {
            String msg = "Error extracting expiration date from given license";
            LOG.warn(msg, t);
            throw new Failure(msg, t);
        }
        if (System.currentTimeMillis() > expirationTimeMillis) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            throw new Failure("Expired as of " + dateFormat.format(new Date(expirationTimeMillis)));
        }
    }

    private static JwtClaims getJwtClaims(PublicKey publicKey, String licenseStr) throws Failure {
        JwtClaims jwtClaims;
        try {
            jwtClaims = License.verify((PublicKey)publicKey, (String)licenseStr);
        }
        catch (InvalidJwtException e) {
            throw new Failure(String.format("Could not verify '%s'", licenseStr), e);
        }
        return jwtClaims;
    }

    public String toString() {
        return "Confluent Platform license";
    }

    public static class Failure
    extends Exception {
        public Failure(String message) {
            super(message);
        }

        public Failure(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

