/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.json.diff.Difference;
import io.confluent.kafka.schemaregistry.json.diff.SchemaDiff;
import io.confluent.kafka.schemaregistry.json.jackson.Jackson;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.SpecificationVersion;
import org.everit.json.schema.loader.internal.ReferenceResolver;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchema
implements ParsedSchema {
    private static final Logger log = LoggerFactory.getLogger(JsonSchema.class);
    public static final String TYPE = "JSON";
    private static final String SCHEMA_KEYWORD = "$schema";
    private static final Object NONE_MARKER = new Object();
    private final JsonNode jsonNode;
    private transient Schema schemaObj;
    private final Integer version;
    private final List<SchemaReference> references;
    private final Map<String, String> resolvedReferences;
    private transient String canonicalString;
    private transient int hashCode = Integer.MIN_VALUE;
    private static final int NO_HASHCODE = Integer.MIN_VALUE;
    private static final ObjectMapper objectMapper = Jackson.newObjectMapper();

    public JsonSchema(JsonNode jsonNode) {
        this(jsonNode, Collections.emptyList(), Collections.emptyMap(), null);
    }

    public JsonSchema(String schemaString) {
        this(schemaString, Collections.emptyList(), Collections.emptyMap(), null);
    }

    public JsonSchema(JsonNode jsonNode, List<SchemaReference> references, Map<String, String> resolvedReferences, Integer version) {
        this.jsonNode = jsonNode;
        this.version = version;
        this.references = Collections.unmodifiableList(references);
        this.resolvedReferences = Collections.unmodifiableMap(resolvedReferences);
    }

    public JsonSchema(String schemaString, List<SchemaReference> references, Map<String, String> resolvedReferences, Integer version) {
        try {
            this.jsonNode = objectMapper.readTree(schemaString);
            this.version = version;
            this.references = Collections.unmodifiableList(references);
            this.resolvedReferences = Collections.unmodifiableMap(resolvedReferences);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid JSON " + schemaString, e);
        }
    }

    public JsonSchema(Schema schemaObj) {
        this(schemaObj, null);
    }

    public JsonSchema(Schema schemaObj, Integer version) {
        try {
            this.jsonNode = schemaObj != null ? objectMapper.readTree(schemaObj.toString()) : null;
            this.schemaObj = schemaObj;
            this.version = version;
            this.references = Collections.emptyList();
            this.resolvedReferences = Collections.emptyMap();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid JSON " + schemaObj.toString(), e);
        }
    }

    private JsonSchema(JsonNode jsonNode, Schema schemaObj, Integer version, List<SchemaReference> references, Map<String, String> resolvedReferences, String canonicalString) {
        this.jsonNode = jsonNode;
        this.schemaObj = schemaObj;
        this.version = version;
        this.references = references;
        this.resolvedReferences = resolvedReferences;
        this.canonicalString = canonicalString;
    }

    public JsonSchema copy() {
        return new JsonSchema(this.jsonNode, this.schemaObj, this.version, this.references, this.resolvedReferences, this.canonicalString);
    }

    public JsonSchema copy(Integer version) {
        return new JsonSchema(this.jsonNode, this.schemaObj, version, this.references, this.resolvedReferences, this.canonicalString);
    }

    public JsonNode toJsonNode() {
        return this.jsonNode;
    }

    public Schema rawSchema() {
        if (this.jsonNode == null) {
            return null;
        }
        if (this.schemaObj == null) {
            try {
                String id;
                String schema;
                SpecificationVersion spec = SpecificationVersion.DRAFT_7;
                if (this.jsonNode.has(SCHEMA_KEYWORD) && (schema = this.jsonNode.get(SCHEMA_KEYWORD).asText()) != null) {
                    spec = SpecificationVersion.lookupByMetaSchemaUrl((String)schema).orElse(SpecificationVersion.DRAFT_7);
                }
                URI idUri = null;
                if (this.jsonNode.has(spec.idKeyword()) && (id = this.jsonNode.get(spec.idKeyword()).asText()) != null) {
                    idUri = ReferenceResolver.resolve((URI)null, (String)id);
                }
                SchemaLoader.SchemaLoaderBuilder builder = SchemaLoader.builder().useDefaults(true).draftV7Support();
                for (Map.Entry<String, String> dep : this.resolvedReferences.entrySet()) {
                    URI child = ReferenceResolver.resolve((URI)idUri, (String)dep.getKey());
                    builder.registerSchemaByURI(child, (Object)new JSONObject(dep.getValue()));
                }
                JSONObject jsonObject = (JSONObject)objectMapper.treeToValue((TreeNode)this.jsonNode, JSONObject.class);
                builder.schemaJson(jsonObject);
                SchemaLoader loader = builder.build();
                this.schemaObj = loader.load().build();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid JSON", e);
            }
        }
        return this.schemaObj;
    }

    public String schemaType() {
        return TYPE;
    }

    public String name() {
        return this.getString("title");
    }

    public String getString(String key) {
        return this.jsonNode.has(key) ? this.jsonNode.get(key).asText() : null;
    }

    public String canonicalString() {
        if (this.jsonNode == null) {
            return null;
        }
        if (this.canonicalString == null) {
            try {
                this.canonicalString = objectMapper.writeValueAsString((Object)this.jsonNode);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid JSON", e);
            }
        }
        return this.canonicalString;
    }

    public Integer version() {
        return this.version;
    }

    public List<SchemaReference> references() {
        return this.references;
    }

    public Map<String, String> resolvedReferences() {
        return this.resolvedReferences;
    }

    public void validate() {
        this.rawSchema();
    }

    public void validate(Object value) throws JsonProcessingException, ValidationException {
        Object primitiveValue = NONE_MARKER;
        if (JsonSchema.isPrimitive(value)) {
            primitiveValue = value;
        } else if (value instanceof BinaryNode) {
            primitiveValue = ((BinaryNode)value).asText();
        } else if (value instanceof BooleanNode) {
            primitiveValue = ((BooleanNode)value).asBoolean();
        } else if (value instanceof NullNode) {
            primitiveValue = null;
        } else if (value instanceof NumericNode) {
            primitiveValue = ((NumericNode)value).numberValue();
        } else if (value instanceof TextNode) {
            primitiveValue = ((TextNode)value).asText();
        }
        if (primitiveValue != NONE_MARKER) {
            this.rawSchema().validate(primitiveValue);
        } else {
            Object jsonObject = value instanceof ArrayNode ? objectMapper.treeToValue((TreeNode)((ArrayNode)value), JSONArray.class) : (value instanceof JsonNode ? objectMapper.treeToValue((TreeNode)((JsonNode)value), JSONObject.class) : (value.getClass().isArray() ? objectMapper.convertValue(value, JSONArray.class) : objectMapper.convertValue(value, JSONObject.class)));
            this.rawSchema().validate(jsonObject);
        }
    }

    private static boolean isPrimitive(Object value) {
        return value == null || value instanceof Boolean || value instanceof Number || value instanceof String;
    }

    public List<String> isBackwardCompatible(ParsedSchema previousSchema) {
        if (!this.schemaType().equals(previousSchema.schemaType())) {
            return Collections.singletonList("Incompatible because of different schema type");
        }
        List<Difference> differences = SchemaDiff.compare(((JsonSchema)previousSchema).rawSchema(), this.rawSchema());
        List incompatibleDiffs = differences.stream().filter(diff -> !SchemaDiff.COMPATIBLE_CHANGES.contains((Object)diff.getType())).collect(Collectors.toList());
        boolean isCompatible = incompatibleDiffs.isEmpty();
        if (!isCompatible) {
            boolean first = true;
            ArrayList<String> errorMessages = new ArrayList<String>();
            for (Difference incompatibleDiff : incompatibleDiffs) {
                if (first) {
                    log.warn("Found incompatible change: {}", (Object)incompatibleDiff);
                    errorMessages.add(String.format("Found incompatible change: %s", incompatibleDiff));
                    first = false;
                    continue;
                }
                log.debug("Found incompatible change: {}", (Object)incompatibleDiff);
                errorMessages.add(String.format("Found incompatible change: %s", incompatibleDiff));
            }
            return errorMessages;
        }
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonSchema that = (JsonSchema)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.references, that.references) && Objects.equals(this.canonicalString(), that.canonicalString());
    }

    public int hashCode() {
        if (this.hashCode == Integer.MIN_VALUE) {
            this.hashCode = Objects.hash(this.jsonNode, this.references, this.version);
        }
        return this.hashCode;
    }

    public String toString() {
        return this.canonicalString();
    }
}

