/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.mqtt;

import io.confluent.mqtt.BaseConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.types.Password;

public abstract class AbstractBaseConfig
implements BaseConfig {
    private AbstractConfig innerConfig;
    private Map<String, ?> values;

    protected final synchronized void init(ConfigDef configDef, Map<String, String> props) {
        this.innerConfig = new AbstractConfig(configDef, props);
        this.values = this.innerConfig.values();
    }

    @Override
    public Object get(String key) {
        return this.values.get(key);
    }

    @Override
    public void ignore(String key) {
        this.innerConfig.ignore(key);
    }

    @Override
    public Short getShort(String key) {
        return this.innerConfig.getShort(key);
    }

    @Override
    public Integer getInt(String key) {
        return this.innerConfig.getInt(key);
    }

    @Override
    public Long getLong(String key) {
        return this.innerConfig.getLong(key);
    }

    @Override
    public Double getDouble(String key) {
        return this.innerConfig.getDouble(key);
    }

    @Override
    public List<String> getList(String key) {
        return this.innerConfig.getList(key);
    }

    @Override
    public Boolean getBoolean(String key) {
        return this.innerConfig.getBoolean(key);
    }

    @Override
    public String getString(String key) {
        return this.innerConfig.getString(key);
    }

    public ConfigDef.Type typeOf(String key) {
        return this.innerConfig.typeOf(key);
    }

    @Override
    public Password getPassword(String key) {
        return this.innerConfig.getPassword(key);
    }

    @Override
    public Class<?> getClass(String key) {
        return this.innerConfig.getClass(key);
    }

    public Set<String> unused() {
        return this.innerConfig.unused();
    }

    public Map<String, Object> originals() {
        return this.innerConfig.originals();
    }

    public Map<String, String> originalsStrings() {
        return this.innerConfig.originalsStrings();
    }

    public Map<String, Object> originalsWithPrefix(String prefix) {
        return this.innerConfig.originalsWithPrefix(prefix);
    }

    public Map<String, Object> originalsWithPrefix(String prefix, boolean strip) {
        return this.innerConfig.originalsWithPrefix(prefix, strip);
    }

    public Map<String, Object> valuesWithPrefixOverride(String prefix) {
        return this.innerConfig.valuesWithPrefixOverride(prefix);
    }

    public Map<String, Object> valuesWithPrefix(String prefix) {
        return this.withPrefix(prefix, this.values);
    }

    protected Map<String, Object> withPrefix(String prefix, Map<String, ?> map) {
        RecordingMap<Object> result = new RecordingMap<Object>();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            if (!entry.getKey().startsWith(prefix) || entry.getKey().length() <= prefix.length()) continue;
            result.put(entry.getKey().substring(prefix.length()), entry.getValue());
        }
        return result;
    }

    public Map<String, Object> valuesWithPrefixAllOrNothing(String prefix) {
        return this.innerConfig.valuesWithPrefixAllOrNothing(prefix);
    }

    public Map<String, ?> values() {
        return this.innerConfig.values();
    }

    public void logUnused() {
        this.innerConfig.logUnused();
    }

    public <T> T getConfiguredInstance(String key, Class<T> t) {
        return (T)this.innerConfig.getConfiguredInstance(key, t);
    }

    public <T> List<T> getConfiguredInstances(String key, Class<T> t) {
        return this.innerConfig.getConfiguredInstances(key, t);
    }

    public <T> List<T> getConfiguredInstances(String key, Class<T> t, Map<String, Object> configOverrides) {
        return this.innerConfig.getConfiguredInstances(key, t, configOverrides);
    }

    public <T> List<T> getConfiguredInstances(List<String> classNames, Class<T> t, Map<String, Object> configOverrides) {
        return this.innerConfig.getConfiguredInstances(classNames, t, configOverrides);
    }

    private class RecordingMap<V>
    extends HashMap<String, V> {
        private final String prefix;

        RecordingMap() {
            this("");
        }

        RecordingMap(String prefix) {
            this.prefix = prefix;
        }

        RecordingMap(Map<String, ? extends V> m) {
            this(m, "");
        }

        RecordingMap(Map<String, ? extends V> m, String prefix) {
            super(m);
            this.prefix = prefix;
        }

        @Override
        public V get(Object key) {
            if (key instanceof String) {
                String keyWithPrefix = this.prefix.isEmpty() ? (String)key : this.prefix + key;
                AbstractBaseConfig.this.ignore(keyWithPrefix);
            }
            return super.get(key);
        }
    }
}

