/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.mqtt.network.netty;

import io.confluent.mqtt.ProxyServer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyProxyServer
implements ProxyServer {
    private static final Logger log = LoggerFactory.getLogger(NettyProxyServer.class);
    private final ServerBootstrap bootstrap;
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final CountDownLatch stopLatch = new CountDownLatch(1);
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private ChannelFuture listener;

    protected NettyProxyServer(ServerBootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    private static void shutdownGroup(EventLoopGroup group) {
        if (group != null) {
            group.shutdownGracefully();
        }
    }

    @Override
    public void start() {
        try {
            log.info("{} starting", (Object)"Kafka-MQTT");
            Runtime.getRuntime().addShutdownHook(new ProxyServer.ShutdownHook(this, this.startLatch, log));
            this.listener = this.bootstrap.bind().syncUninterruptibly();
            log.info("{} started", (Object)"Kafka-MQTT");
        }
        finally {
            this.startLatch.countDown();
        }
    }

    @Override
    public void awaitStop() {
        try {
            this.stopLatch.await();
        }
        catch (InterruptedException e) {
            log.error("Interrupted waiting for Kafka Connect to shutdown");
        }
    }

    @Override
    public void stop() {
        try {
            boolean wasShuttingDown = this.shutdown.getAndSet(true);
            if (!wasShuttingDown) {
                log.info("{} stopping", (Object)"Kafka-MQTT");
                if (this.listener != null) {
                    this.listener.channel().close().awaitUninterruptibly();
                }
                NettyProxyServer.shutdownGroup(this.bootstrap.config().childGroup());
                NettyProxyServer.shutdownGroup(this.bootstrap.config().group());
                log.info("{} stopped", (Object)"Kafka-MQTT");
            }
        }
        finally {
            this.stopLatch.countDown();
        }
    }
}

