/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.mqtt.protocol.security;

import io.confluent.mqtt.BaseConfig;
import io.confluent.mqtt.protocol.security.ClientAuth;
import io.confluent.mqtt.util.ConfigUtils;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.SslConfigs;

public interface PrefixedSecurityConfigs
extends BaseConfig {
    public static final String SSL_CLIENT_AUTH_DOC = "Configures server to request client authentication.";
    public static final ConfigUtils.EnumRecommender SSL_CLIENT_AUTH_RECOMMENDER = ConfigUtils.EnumRecommender.in(false, ClientAuth.values());

    public static ConfigDef configDef(String prefix, ConfigDef config, BaseConfig.GroupAndOrder group) {
        ConfigDef configDef = config;
        configDef = PrefixedSecurityConfigs.sslConfigDef(prefix, configDef, group);
        configDef = PrefixedSecurityConfigs.saslConfigDef(prefix, configDef, group);
        return configDef;
    }

    public static ConfigDef sslConfigDef(String prefix, ConfigDef config, BaseConfig.GroupAndOrder group) {
        ++group.order;
        ++group.order;
        ++group.order;
        ++group.order;
        ++group.order;
        return config.define(prefix + "ssl.protocol", ConfigDef.Type.STRING, (Object)SslConfigs.DEFAULT_SSL_PROTOCOL, ConfigDef.Importance.MEDIUM, "The SSL protocol used to generate the SSLContext. The default is 'TLSv1.3' when running with Java 11 or newer, 'TLSv1.2' otherwise. This value should be fine for most use cases. Allowed values in recent JVMs are 'TLSv1.2' and 'TLSv1.3'. 'TLS', 'TLSv1.1', 'SSL', 'SSLv2' and 'SSLv3' may be supported in older JVMs, but their usage is discouraged due to known security vulnerabilities. With the default value for this config and 'ssl.enabled.protocols', clients will downgrade to 'TLSv1.2' if the server does not support 'TLSv1.3'. If this config is set to 'TLSv1.2', clients will not use 'TLSv1.3' even if it is one of the values in ssl.enabled.protocols and the server only supports 'TLSv1.3'.", group.name, group.order, ConfigDef.Width.MEDIUM, "SSL/TLS protocol").define(prefix + "ssl.provider", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "The name of the security provider used for SSL connections. Default value is the default security provider of the JVM.", group.name, group.order, ConfigDef.Width.MEDIUM, "SSL/TLS provider").define(prefix + "ssl.cipher.suites", ConfigDef.Type.LIST, null, ConfigDef.Importance.LOW, "A list of cipher suites. This is a named combination of authentication, encryption, MAC and key exchange algorithm used to negotiate the security settings for a network connection using TLS or SSL network protocol. By default all the available cipher suites are supported.", group.name, group.order, ConfigDef.Width.MEDIUM, "Cipher suites").define(prefix + "ssl.enabled.protocols", ConfigDef.Type.LIST, (Object)SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS, ConfigDef.Importance.MEDIUM, "The list of protocols enabled for SSL connections. The default is 'TLSv1.2,TLSv1.3' when running with Java 11 or newer, 'TLSv1.2' otherwise. With the default value for Java 11, clients and servers will prefer TLSv1.3 if both support it and fallback to TLSv1.2 otherwise (assuming both support at least TLSv1.2). This default should be fine for most cases. Also see the config documentation for `ssl.protocol`.", group.name, group.order, ConfigDef.Width.MEDIUM, "Enabled protocols").define(prefix + "ssl.keystore.type", ConfigDef.Type.STRING, (Object)"JKS", ConfigDef.Importance.MEDIUM, "The file format of the key store file. This is optional for client. The values currently supported by the default `ssl.engine.factory.class` are [JKS, PKCS12, PEM].", group.name, group.order, ConfigDef.Width.MEDIUM, "Keystore type").define(prefix + "ssl.keystore.location", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "The location of the key store file. This is optional for client and can be used for two-way authentication for client.", group.name, ++group.order, ConfigDef.Width.MEDIUM, "Keystore location").define(prefix + "ssl.keystore.password", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.HIGH, "The store password for the key store file. This is optional for client and only needed if 'ssl.keystore.location' is configured. Key store password is not supported for PEM format.", group.name, ++group.order, ConfigDef.Width.MEDIUM, "Password for the keystore").define(prefix + "ssl.key.password", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.HIGH, "The password of the private key in the key store file or the PEM key specified in 'ssl.keystore.key'.", group.name, ++group.order, ConfigDef.Width.MEDIUM, "Password of the private key in the keystore").define(prefix + "ssl.truststore.type", ConfigDef.Type.STRING, (Object)"JKS", ConfigDef.Importance.MEDIUM, "The file format of the trust store file. The values currently supported by the default `ssl.engine.factory.class` are [JKS, PKCS12, PEM].", group.name, ++group.order, ConfigDef.Width.MEDIUM, "Truststore type").define(prefix + "ssl.truststore.location", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "The location of the trust store file.", group.name, ++group.order, ConfigDef.Width.MEDIUM, "Truststore file location").define(prefix + "ssl.truststore.password", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.HIGH, "The password for the trust store file. If a password is not set, trust store file configured will still be used, but integrity checking is disabled. Trust store password is not supported for PEM format.", group.name, ++group.order, ConfigDef.Width.MEDIUM, "Password for the truststore").define(prefix + "ssl.keymanager.algorithm", ConfigDef.Type.STRING, (Object)SslConfigs.DEFAULT_SSL_KEYMANGER_ALGORITHM, ConfigDef.Importance.LOW, "The algorithm used by key manager factory for SSL connections. Default value is the key manager factory algorithm configured for the Java Virtual Machine.", group.name, ++group.order, ConfigDef.Width.MEDIUM, "key manager factory's algorithm").define(prefix + "ssl.trustmanager.algorithm", ConfigDef.Type.STRING, (Object)SslConfigs.DEFAULT_SSL_TRUSTMANAGER_ALGORITHM, ConfigDef.Importance.LOW, "The algorithm used by trust manager factory for SSL connections. Default value is the trust manager factory algorithm configured for the Java Virtual Machine.", group.name, ++group.order, ConfigDef.Width.MEDIUM, "Trust manager factory's algorithm").define(prefix + "ssl.endpoint.identification.algorithm", ConfigDef.Type.STRING, (Object)"https", ConfigDef.Importance.LOW, "The endpoint identification algorithm to validate server hostname using server certificate. ", group.name, ++group.order, ConfigDef.Width.MEDIUM, "Endpoint identification algorithm").define(prefix + "ssl.secure.random.implementation", ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "The SecureRandom PRNG implementation to use for SSL cryptography operations. ", group.name, ++group.order, ConfigDef.Width.MEDIUM, "SecureRandom PRNG implementation");
    }

    public static ConfigDef sslServerConfigDef(String prefix, ConfigDef config, BaseConfig.GroupAndOrder group) {
        return config.define(prefix + "ssl.client.auth", ConfigDef.Type.STRING, (Object)ClientAuth.NONE.toString(), (ConfigDef.Validator)SSL_CLIENT_AUTH_RECOMMENDER, ConfigDef.Importance.MEDIUM, SSL_CLIENT_AUTH_DOC, group.name, ++group.order, ConfigDef.Width.MEDIUM, "Client authentication requirements");
    }

    public static ConfigDef saslConfigDef(String prefix, ConfigDef config, BaseConfig.GroupAndOrder group) {
        ++group.order;
        ++group.order;
        ++group.order;
        ++group.order;
        return config.define(prefix + "sasl.kerberos.service.name", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "The Kerberos principal name that Kafka runs as. This can be defined either in Kafka's JAAS config or in Kafka's config.", group.name, group.order, ConfigDef.Width.MEDIUM, "Kerberos Principal Name").define(prefix + "sasl.kerberos.kinit.cmd", ConfigDef.Type.STRING, (Object)"/usr/bin/kinit", ConfigDef.Importance.LOW, "Kerberos kinit command path.", group.name, group.order, ConfigDef.Width.MEDIUM, "Kerberos kinit Command Path").define(prefix + "sasl.kerberos.ticket.renew.window.factor", ConfigDef.Type.DOUBLE, (Object)0.8, ConfigDef.Importance.LOW, "Login thread will sleep until the specified window factor of time from last refresh to ticket's expiry has been reached, at which time it will try to renew the ticket.", group.name, group.order, ConfigDef.Width.MEDIUM, "Ticket Renew Window Factor").define(prefix + "sasl.kerberos.ticket.renew.jitter", ConfigDef.Type.DOUBLE, (Object)0.05, ConfigDef.Importance.LOW, "Percentage of random jitter added to the renewal time.", group.name, group.order, ConfigDef.Width.MEDIUM, "Ticket Renew Jitter").define(prefix + "sasl.kerberos.min.time.before.relogin", ConfigDef.Type.LONG, (Object)60000L, ConfigDef.Importance.LOW, "Login thread sleep time between refresh attempts.", group.name, ++group.order, ConfigDef.Width.MEDIUM, "Minimum Time Before Re-login").define(prefix + "sasl.login.refresh.window.factor", ConfigDef.Type.DOUBLE, (Object)0.8, (ConfigDef.Validator)ConfigDef.Range.between((Number)0.5, (Number)1.0), ConfigDef.Importance.LOW, "Login refresh thread will sleep until the specified window factor relative to the credential's lifetime has been reached, at which time it will try to refresh the credential. Legal values are between 0.5 (50%) and 1.0 (100%) inclusive; a default value of 0.8 (80%) is used if no value is specified. Currently applies only to OAUTHBEARER.", group.name, ++group.order, ConfigDef.Width.MEDIUM, "Login Refresh Window Factor").define(prefix + "sasl.login.refresh.window.jitter", ConfigDef.Type.DOUBLE, (Object)0.05, (ConfigDef.Validator)ConfigDef.Range.between((Number)0.0, (Number)0.25), ConfigDef.Importance.LOW, "The maximum amount of random jitter relative to the credential's lifetime that is added to the login refresh thread's sleep time. Legal values are between 0 and 0.25 (25%) inclusive; a default value of 0.05 (5%) is used if no value is specified. Currently applies only to OAUTHBEARER.", group.name, ++group.order, ConfigDef.Width.MEDIUM, "Login Refresh Window Jitter").define(prefix + "sasl.login.refresh.min.period.seconds", ConfigDef.Type.SHORT, (Object)60, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)900), ConfigDef.Importance.LOW, "The desired minimum time for the login refresh thread to wait before refreshing a credential, in seconds. Legal values are between 0 and 900 (15 minutes); a default value of 60 (1 minute) is used if no value is specified.  This value and  sasl.login.refresh.buffer.seconds are both ignored if their sum exceeds the remaining lifetime of a credential. Currently applies only to OAUTHBEARER.", group.name, ++group.order, ConfigDef.Width.MEDIUM, "Minimum Time Before Credentials Refresh (sec)").define(prefix + "sasl.login.refresh.buffer.seconds", ConfigDef.Type.SHORT, (Object)300, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)3600), ConfigDef.Importance.LOW, "The amount of buffer time before credential expiration to maintain when refreshing a credential, in seconds. If a refresh would otherwise occur closer to expiration than the number of buffer seconds then the refresh will be moved up to maintain as much of the buffer time as possible. Legal values are between 0 and 3600 (1 hour); a default value of  300 (5 minutes) is used if no value is specified. This value and sasl.login.refresh.min.period.seconds are both ignored if their sum exceeds the remaining lifetime of a credential. Currently applies only to OAUTHBEARER.", group.name, ++group.order, ConfigDef.Width.MEDIUM, "Refresh Buffer Time (sec)").define(prefix + "sasl.mechanism", ConfigDef.Type.STRING, (Object)"GSSAPI", ConfigDef.Importance.MEDIUM, "SASL mechanism used for client connections. This may be any mechanism for which a security provider is available. GSSAPI is the default mechanism.", group.name, ++group.order, ConfigDef.Width.MEDIUM, "SASL mechanism").define(prefix + "sasl.jaas.config", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.MEDIUM, "JAAS login context parameters for SASL connections in the format used by JAAS configuration files. JAAS configuration file format is described <a href=\"https://docs.oracle.com/javase/8/docs/technotes/guides/security/jgss/tutorials/LoginConfigFile.html\">here</a>. The format for the value is: <code>loginModuleClass controlFlag (optionName=optionValue)*;</code>. For brokers, the config must be prefixed with listener prefix and SASL mechanism name in lower-case. For example, listener.name.sasl_ssl.scram-sha-256.sasl.jaas.config=com.example.ScramLoginModule required;", group.name, ++group.order, ConfigDef.Width.MEDIUM, "JAAS Login Context Parameters").define(prefix + "sasl.client.callback.handler.class", ConfigDef.Type.CLASS, null, ConfigDef.Importance.MEDIUM, "The fully qualified name of a SASL client callback handler class that implements the AuthenticateCallbackHandler interface.", group.name, ++group.order, ConfigDef.Width.MEDIUM, "SASL Client Callback Handler Class").define(prefix + "sasl.login.callback.handler.class", ConfigDef.Type.CLASS, null, ConfigDef.Importance.MEDIUM, "The fully qualified name of a SASL login callback handler class that implements the AuthenticateCallbackHandler interface. For brokers, login callback handler config must be prefixed with listener prefix and SASL mechanism name in lower-case. For example, listener.name.sasl_ssl.scram-sha-256.sasl.login.callback.handler.class=com.example.CustomScramLoginCallbackHandler", group.name, ++group.order, ConfigDef.Width.MEDIUM, "SASL Login Callback Handler Class").define(prefix + "sasl.login.class", ConfigDef.Type.CLASS, null, ConfigDef.Importance.MEDIUM, "The fully qualified name of a class that implements the Login interface. For brokers, login config must be prefixed with listener prefix and SASL mechanism name in lower-case. For example, listener.name.sasl_ssl.scram-sha-256.sasl.login.class=com.example.CustomScramLogin", group.name, ++group.order, ConfigDef.Width.MEDIUM, "Login Interface Class");
    }
}

