/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.mqtt.protocol.security;

import io.netty.handler.codec.mqtt.MqttConnectPayload;
import java.nio.charset.StandardCharsets;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPasswordCallbackHandler
implements CallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(UserPasswordCallbackHandler.class);
    private final String username;
    private final String password;

    public UserPasswordCallbackHandler(MqttConnectPayload connectPayload) {
        this.username = connectPayload.userName();
        this.password = new String(connectPayload.passwordInBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public void handle(Callback[] callbacks) {
        boolean nameCallbackHandled = false;
        boolean passwordCallbackHandled = false;
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.username);
                nameCallbackHandled = true;
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                passwordCallbackHandled = true;
                continue;
            }
            log.warn("Ignoring unsupported callback: {}", (Object)callback);
        }
        if (!nameCallbackHandled || !passwordCallbackHandled) {
            log.warn("NameCallback and PasswordCallback must both be used");
            throw new IllegalArgumentException("NameCallback and PasswordCallback must both be used");
        }
    }
}

