/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.mqtt.stream;

import io.confluent.mqtt.BaseConfig;
import io.confluent.mqtt.protocol.security.PrefixedSecurityConfigs;
import java.util.Collections;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.metrics.Sensor;

public interface SelectedProducerConfigDef
extends BaseConfig {
    public static final String METADATA_MAX_AGE_CONFIG = "metadata.max.age.ms";
    public static final String METADATA_MAX_AGE_DOC = "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.";
    public static final String BATCH_SIZE_CONFIG = "batch.size";
    public static final String BATCH_SIZE_DOC = "The producer will attempt to batch records together into fewer requests whenever multiple records are being sent to the same partition. This helps performance on both the client and the server. This configuration controls the default batch size in bytes. No attempt will be made to batch records larger than this size. Requests sent to brokers will contain multiple batches, one for each partition with data available to be sent. A small batch size will make batching less common and may reduce throughput (a batch size of zero will disable batching entirely). A very large batch size may use memory a bit more wastefully as we will always allocate a buffer of the specified batch size in anticipation of additional records.";
    public static final String LINGER_MS_CONFIG = "linger.ms";
    public static final String LINGER_MS_DOC = "The producer groups together any records that arrive in between request transmissions into a single batched request. Normally this occurs only under load when records arrive faster than they can be sent out. However in some circumstances the client may want to reduce the number of requests even under moderate load. This setting accomplishes this by adding a small amount of artificial delay&mdash;that is, rather than immediately sending out a record the producer will wait for up to the given delay to allow other records to be sent so that the sends can be batched together. This can be thought of as analogous to Nagle's algorithm in TCP. This setting gives the upper bound on the delay for batching: once we get batch.size worth of records for a partition it will be sent immediately regardless of this setting, however if we have fewer than this many bytes accumulated for this partition we will 'linger' for the specified time waiting for more records to show up. This setting defaults to 0 (i.e. no delay). Setting linger.ms=5, for example, would have the effect of reducing the number of requests sent but would add up to 5ms of latency to records sent in the absence of load.";
    public static final String CLIENT_ID_CONFIG = "client.id";
    public static final String SEND_BUFFER_CONFIG = "send.buffer.bytes";
    public static final String RECEIVE_BUFFER_CONFIG = "receive.buffer.bytes";
    public static final String MAX_REQUEST_SIZE_CONFIG = "max.request.size";
    public static final String MAX_REQUEST_SIZE_DOC = "The maximum size of a request in bytes. This setting will limit the number of record batches the producer will send in a single request to avoid sending huge requests. This is also effectively a cap on the maximum record batch size. Note that the server has its own cap on record batch size which may be different from this.";
    public static final String RECONNECT_BACKOFF_MS_CONFIG = "reconnect.backoff.ms";
    public static final String RECONNECT_BACKOFF_MAX_MS_CONFIG = "reconnect.backoff.max.ms";
    public static final String MAX_BLOCK_MS_CONFIG = "max.block.ms";
    public static final String MAX_BLOCK_MS_DOC = "The configuration controls how long KafkaProducer.send() and KafkaProducer.partitionsFor() will block.These methods can be blocked either because the buffer is full or metadata unavailable.Blocking in the user-supplied serializers or partitioner will not be counted against this timeout.";
    public static final String BUFFER_MEMORY_CONFIG = "buffer.memory";
    public static final String BUFFER_MEMORY_DOC = "The total bytes of memory the producer can use to buffer records waiting to be sent to the server. If records are sent faster than they can be delivered to the server the producer will block for max.block.ms after which it will throw an exception.This setting should correspond roughly to the total memory the producer will use, but is not a hard bound since not all memory the producer uses is used for buffering. Some additional memory will be used for compression (if compression is enabled) as well as for maintaining in-flight requests.";
    public static final String COMPRESSION_TYPE_CONFIG = "compression.type";
    public static final String COMPRESSION_TYPE_DOC = "The compression type for all data generated by the producer. The default is none (i.e. no compression). Valid  values are none, gzip, snappy, or lz4. Compression is of full batches of data, so the efficacy of batching will also impact the compression ratio (more batching means better compression).";
    public static final String METRICS_SAMPLE_WINDOW_MS_CONFIG = "metrics.sample.window.ms";
    public static final String METRICS_NUM_SAMPLES_CONFIG = "metrics.num.samples";
    public static final String METRICS_RECORDING_LEVEL_CONFIG = "metrics.recording.level";
    public static final String METRIC_REPORTER_CLASSES_CONFIG = "metric.reporters";
    public static final String MAX_IN_FLIGHT_REQUESTS_PER_CONNECTION = "max.in.flight.requests.per.connection";
    public static final String MAX_IN_FLIGHT_REQUESTS_PER_CONNECTION_DOC = "The maximum number of unacknowledged requests the client will send on a single connection before blocking. Note that if this setting is set to be greater than 1 and there are failed sends, there is a risk of message re-ordering due to retries (i.e., if retries are enabled).";
    public static final String CONNECTIONS_MAX_IDLE_MS_CONFIG = "connections.max.idle.ms";
    public static final String PARTITIONER_CLASS_CONFIG = "partitioner.class";
    public static final String PARTITIONER_CLASS_DOC = "Partitioner class that implements the org.apache.kafka.clients.producer.Partitioner interface.";
    public static final String REQUEST_TIMEOUT_MS_CONFIG = "request.timeout.ms";
    public static final String REQUEST_TIMEOUT_MS_DOC = "The configuration controls the maximum amount of time the client will wait for the response of a request. If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted. This should be larger than replica.lag.time.max.ms (a broker configuration) to reduce the possibility of message duplication due to unnecessary producer retries.";
    public static final String INTERCEPTOR_CLASSES_CONFIG = "interceptor.classes";
    public static final String INTERCEPTOR_CLASSES_DOC = "A list of classes to use as interceptors. Implementing the org.apache.kafka.clients.producer.ProducerInterceptor interface allows you to intercept (and possibly mutate) the records received by the producer before they are published to the Kafka cluster. By default, there are no interceptors.";

    public static ConfigDef configDef(String prefix, ConfigDef config, BaseConfig.GroupAndOrder group) {
        ConfigDef configDef = config;
        ++group.order;
        ++group.order;
        ++group.order;
        ++group.order;
        ++group.order;
        ++group.order;
        ++group.order;
        ++group.order;
        configDef.define(prefix + BUFFER_MEMORY_CONFIG, ConfigDef.Type.LONG, (Object)0x2000000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.HIGH, BUFFER_MEMORY_DOC, group.name, group.order, ConfigDef.Width.LONG, "Buffer Memory").define(prefix + COMPRESSION_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)"none", ConfigDef.Importance.HIGH, COMPRESSION_TYPE_DOC, group.name, group.order, ConfigDef.Width.LONG, "Compression Type").define(prefix + BATCH_SIZE_CONFIG, ConfigDef.Type.INT, (Object)16384, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, BATCH_SIZE_DOC, group.name, group.order, ConfigDef.Width.LONG, "Batch Size").define(prefix + LINGER_MS_CONFIG, ConfigDef.Type.LONG, (Object)0, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.MEDIUM, LINGER_MS_DOC, group.name, group.order, ConfigDef.Width.LONG, "Batch Size").define(prefix + CLIENT_ID_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "An id string to pass to the server when making requests. The purpose of this is to be able to track the source of requests beyond just ip/port by allowing a logical application name to be included in server-side request logging.", group.name, group.order, ConfigDef.Width.LONG, "Producer Id").define(prefix + SEND_BUFFER_CONFIG, ConfigDef.Type.INT, (Object)131072, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)-1), ConfigDef.Importance.MEDIUM, "The size of the TCP send buffer (SO_SNDBUF) to use when sending data. If the value is -1, the OS default will be used.", group.name, group.order, ConfigDef.Width.LONG, "Send Buffer Size").define(prefix + RECEIVE_BUFFER_CONFIG, ConfigDef.Type.INT, (Object)32768, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)-1), ConfigDef.Importance.MEDIUM, "The size of the TCP receive buffer (SO_RCVBUF) to use when reading data. If the value is -1, the OS default will be used.", group.name, group.order, ConfigDef.Width.LONG, "Receive Buffer Size").define(prefix + MAX_REQUEST_SIZE_CONFIG, ConfigDef.Type.INT, (Object)0x100000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MAX_REQUEST_SIZE_DOC, group.name, group.order, ConfigDef.Width.LONG, "Max Request Size").define(prefix + RECONNECT_BACKOFF_MS_CONFIG, ConfigDef.Type.LONG, (Object)50L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.LOW, "The base amount of time to wait before attempting to reconnect to a given host. This avoids repeatedly connecting to a host in a tight loop. This backoff applies to all connection attempts by the client to a broker.", group.name, ++group.order, ConfigDef.Width.LONG, "Reconnect Backoff (ms)").define(prefix + RECONNECT_BACKOFF_MAX_MS_CONFIG, ConfigDef.Type.LONG, (Object)1000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.LOW, "The maximum amount of time in milliseconds to wait when reconnecting to a broker that has repeatedly failed to connect. If provided, the backoff per host will increase exponentially for each consecutive connection failure, up to this maximum. After calculating the backoff increase, 20% random jitter is added to avoid connection storms.", group.name, ++group.order, ConfigDef.Width.LONG, "Maximum Reconnect Backoff (ms)").define(prefix + MAX_BLOCK_MS_CONFIG, ConfigDef.Type.LONG, (Object)60000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MAX_BLOCK_MS_DOC, group.name, ++group.order, ConfigDef.Width.LONG, "Maximum Blocking Time (ms)").define(prefix + REQUEST_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, (Object)30000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, REQUEST_TIMEOUT_MS_DOC, group.name, ++group.order, ConfigDef.Width.LONG, "Request Timeout (ms)").define(prefix + METADATA_MAX_AGE_CONFIG, ConfigDef.Type.LONG, (Object)300000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, METADATA_MAX_AGE_DOC, group.name, ++group.order, ConfigDef.Width.LONG, "Metadata Age (ms)").define(prefix + METRICS_SAMPLE_WINDOW_MS_CONFIG, ConfigDef.Type.LONG, (Object)30000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, "The window of time a metrics sample is computed over.", group.name, ++group.order, ConfigDef.Width.LONG, "Sample Window For Metrics (ms)").define(prefix + METRICS_NUM_SAMPLES_CONFIG, ConfigDef.Type.INT, (Object)2, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "The number of samples maintained to compute metrics.", group.name, ++group.order, ConfigDef.Width.LONG, "Number Of Samples For Metrics").define(prefix + METRICS_RECORDING_LEVEL_CONFIG, ConfigDef.Type.STRING, (Object)Sensor.RecordingLevel.INFO.toString(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{Sensor.RecordingLevel.INFO.toString(), Sensor.RecordingLevel.DEBUG.toString()}), ConfigDef.Importance.LOW, "The highest recording level for metrics.", group.name, ++group.order, ConfigDef.Width.LONG, "Highest Recording Level For Metrics").define(prefix + METRIC_REPORTER_CLASSES_CONFIG, ConfigDef.Type.LIST, Collections.emptyList(), (ConfigDef.Validator)new ConfigDef.NonNullValidator(), ConfigDef.Importance.LOW, "A list of classes to use as metrics reporters. Implementing the <code>org.apache.kafka.common.metrics.MetricsReporter</code> interface allows plugging in classes that will be notified of new metric creation. The JmxReporter is always included to register JMX statistics.", group.name, ++group.order, ConfigDef.Width.LONG, "List Of Metrics Reporter Classes").define(prefix + MAX_IN_FLIGHT_REQUESTS_PER_CONNECTION, ConfigDef.Type.INT, (Object)5, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, MAX_IN_FLIGHT_REQUESTS_PER_CONNECTION_DOC, group.name, ++group.order, ConfigDef.Width.LONG, "Maximum Requests In Flight").define(prefix + CONNECTIONS_MAX_IDLE_MS_CONFIG, ConfigDef.Type.LONG, (Object)540000, ConfigDef.Importance.MEDIUM, "Close idle connections after the number of milliseconds specified by this config.", group.name, ++group.order, ConfigDef.Width.LONG, "Maximum Time to Keep Alive An Idle Connection (ms)").define(prefix + PARTITIONER_CLASS_CONFIG, ConfigDef.Type.CLASS, DefaultPartitioner.class, ConfigDef.Importance.MEDIUM, PARTITIONER_CLASS_DOC, group.name, ++group.order, ConfigDef.Width.LONG, "Partitioner Class").define(prefix + INTERCEPTOR_CLASSES_CONFIG, ConfigDef.Type.LIST, Collections.emptyList(), (ConfigDef.Validator)new ConfigDef.NonNullValidator(), ConfigDef.Importance.LOW, INTERCEPTOR_CLASSES_DOC, group.name, ++group.order, ConfigDef.Width.LONG, "List Of Interceptor Classes").define(prefix + "security.protocol", ConfigDef.Type.STRING, (Object)"PLAINTEXT", ConfigDef.Importance.MEDIUM, CommonClientConfigs.SECURITY_PROTOCOL_DOC, group.name, ++group.order, ConfigDef.Width.LONG, "Security Protocol");
        configDef = PrefixedSecurityConfigs.configDef(prefix, configDef, group);
        return configDef;
    }
}

