/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.gcp;

import com.google.api.services.cloudkms.v1.CloudKMS;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.crypto.tink.KmsClient;
import com.google.crypto.tink.KmsClients;
import com.google.crypto.tink.integration.gcpkms.GcpKmsClient;
import io.confluent.kafka.schemaregistry.encryption.tink.KmsDriver;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Optional;

public class GcpKmsDriver
implements KmsDriver {
    public static final String ACCOUNT_TYPE = "account.type";
    public static final String CLIENT_ID = "client.id";
    public static final String CLIENT_EMAIL = "client.email";
    public static final String PRIVATE_KEY_ID = "private.key.id";
    public static final String PRIVATE_KEY = "private.key";

    public String getKeyUrlPrefix() {
        return "gcp-kms://";
    }

    private GoogleCredentials getCredentials(Map<String, ?> configs) throws GeneralSecurityException {
        try {
            String accountType = (String)configs.get(ACCOUNT_TYPE);
            if (accountType == null) {
                accountType = "service_account";
            }
            String clientId = (String)configs.get(CLIENT_ID);
            String clientEmail = (String)configs.get(CLIENT_EMAIL);
            String privateKeyId = (String)configs.get(PRIVATE_KEY_ID);
            String privateKey = (String)configs.get(PRIVATE_KEY);
            if (clientId != null && clientEmail != null && privateKeyId != null && privateKey != null) {
                String keys = "{ \"type\": \"" + accountType + "\", \"client_id\": \"" + clientId + "\", \"client_email\": \"" + clientEmail + "\", \"private_key_id\": \"" + privateKeyId + "\", \"private_key\": \"" + privateKey + "\" }";
                return GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(keys.getBytes(StandardCharsets.UTF_8)));
            }
            return GoogleCredentials.getApplicationDefault();
        }
        catch (Exception e) {
            throw new GeneralSecurityException("cannot load credentials", e);
        }
    }

    public KmsClient registerKmsClient(Map<String, ?> configs, Optional<String> kekUrl) throws GeneralSecurityException {
        CloudKMS testClient = (CloudKMS)this.getTestClient(configs);
        Optional<GoogleCredentials> creds = testClient != null ? Optional.empty() : Optional.ofNullable(this.getCredentials(configs));
        return GcpKmsDriver.registerWithCloudKms(kekUrl, creds, testClient);
    }

    public static KmsClient registerWithCloudKms(Optional<String> keyUri, Optional<GoogleCredentials> credentials, CloudKMS cloudKms) throws GeneralSecurityException {
        GcpKmsClient client = keyUri.isPresent() ? new GcpKmsClient(keyUri.get()) : new GcpKmsClient();
        if (cloudKms == null) {
            if (credentials.isPresent()) {
                client.withCredentials(credentials.get());
            } else {
                client.withDefaultCredentials();
            }
        } else {
            GcpKmsDriver.setCloudKms(client, cloudKms);
        }
        KmsClients.add((KmsClient)client);
        return client;
    }

    private static void setCloudKms(GcpKmsClient client, CloudKMS cloudKms) {
        try {
            Field field = GcpKmsClient.class.getDeclaredField("cloudKms");
            field.setAccessible(true);
            field.set(client, cloudKms);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

