/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import io.confluent.kafka.schemaregistry.avro.AvroCompatibilityLevel;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.avro.Schema;

public class MockSchemaRegistryClient
implements SchemaRegistryClient {
    private String defaultCompatibility = "BACKWARD";
    private final Map<String, Map<Schema, Integer>> schemaCache = new HashMap<String, Map<Schema, Integer>>();
    private final Map<String, Map<Integer, Schema>> idCache = new HashMap<String, Map<Integer, Schema>>();
    private final Map<String, Map<Schema, Integer>> versionCache = new HashMap<String, Map<Schema, Integer>>();
    private final Map<String, String> compatibilityCache = new HashMap<String, String>();
    private final AtomicInteger ids = new AtomicInteger(0);

    public MockSchemaRegistryClient() {
        this.idCache.put(null, new HashMap());
    }

    private int getIdFromRegistry(String subject, Schema schema) throws IOException {
        Map<Object, Object> idSchemaMap;
        if (this.idCache.containsKey(subject)) {
            idSchemaMap = this.idCache.get(subject);
            for (Map.Entry<Object, Object> entry : idSchemaMap.entrySet()) {
                if (!((Schema)entry.getValue()).toString().equals(schema.toString())) continue;
                this.generateVersion(subject, schema);
                return (Integer)entry.getKey();
            }
        } else {
            idSchemaMap = new HashMap();
        }
        int id = this.ids.incrementAndGet();
        idSchemaMap.put(id, schema);
        this.idCache.put(subject, idSchemaMap);
        this.generateVersion(subject, schema);
        return id;
    }

    private void generateVersion(String subject, Schema schema) {
        int currentVersion;
        Map<Object, Object> schemaVersionMap;
        ArrayList<Integer> versions = this.getAllVersions(subject);
        if (versions.isEmpty()) {
            schemaVersionMap = new IdentityHashMap();
            currentVersion = 1;
        } else {
            schemaVersionMap = this.versionCache.get(subject);
            currentVersion = versions.get(versions.size() - 1) + 1;
        }
        schemaVersionMap.put(schema, currentVersion);
        this.versionCache.put(subject, schemaVersionMap);
    }

    private ArrayList<Integer> getAllVersions(String subject) {
        ArrayList<Integer> versions = new ArrayList<Integer>();
        if (this.versionCache.containsKey(subject)) {
            versions.addAll(this.versionCache.get(subject).values());
            Collections.sort(versions);
        }
        return versions;
    }

    private Schema getSchemaBySubjectAndIdFromRegistry(String subject, int id) throws IOException {
        Map<Integer, Schema> idSchemaMap;
        if (this.idCache.containsKey(subject) && (idSchemaMap = this.idCache.get(subject)).containsKey(id)) {
            return idSchemaMap.get(id);
        }
        throw new IOException("Cannot get schema from schema registry!");
    }

    @Override
    public synchronized int register(String subject, Schema schema) throws IOException, RestClientException {
        Map<Object, Object> schemaIdMap;
        if (this.schemaCache.containsKey(subject)) {
            schemaIdMap = this.schemaCache.get(subject);
        } else {
            schemaIdMap = new IdentityHashMap();
            this.schemaCache.put(subject, schemaIdMap);
        }
        if (schemaIdMap.containsKey(schema)) {
            return (Integer)schemaIdMap.get(schema);
        }
        int id = this.getIdFromRegistry(subject, schema);
        schemaIdMap.put(schema, id);
        this.idCache.get(null).put(id, schema);
        return id;
    }

    @Override
    public Schema getByID(int id) throws IOException, RestClientException {
        return this.getById(id);
    }

    @Override
    public synchronized Schema getById(int id) throws IOException, RestClientException {
        return this.getBySubjectAndId(null, id);
    }

    @Override
    public Schema getBySubjectAndID(String subject, int id) throws IOException, RestClientException {
        return this.getBySubjectAndId(subject, id);
    }

    @Override
    public synchronized Schema getBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        Map<Object, Object> idSchemaMap;
        if (this.idCache.containsKey(subject)) {
            idSchemaMap = this.idCache.get(subject);
        } else {
            idSchemaMap = new HashMap();
            this.idCache.put(subject, idSchemaMap);
        }
        if (idSchemaMap.containsKey(id)) {
            return (Schema)idSchemaMap.get(id);
        }
        Schema schema = this.getSchemaBySubjectAndIdFromRegistry(subject, id);
        idSchemaMap.put(id, schema);
        return schema;
    }

    private int getLatestVersion(String subject) throws IOException, RestClientException {
        ArrayList<Integer> versions = this.getAllVersions(subject);
        if (versions.isEmpty()) {
            throw new IOException("No schema registered under subject!");
        }
        return versions.get(versions.size() - 1);
    }

    @Override
    public synchronized SchemaMetadata getSchemaMetadata(String subject, int version) {
        String schemaString = null;
        Map<Schema, Integer> schemaVersionMap = this.versionCache.get(subject);
        for (Map.Entry<Schema, Integer> entry : schemaVersionMap.entrySet()) {
            if (entry.getValue() != version) continue;
            schemaString = entry.getKey().toString();
        }
        int id = -1;
        Map<Integer, Schema> idSchemaMap = this.idCache.get(subject);
        for (Map.Entry<Integer, Schema> entry : idSchemaMap.entrySet()) {
            if (!entry.getValue().toString().equals(schemaString)) continue;
            id = entry.getKey();
        }
        return new SchemaMetadata(id, version, schemaString);
    }

    @Override
    public synchronized SchemaMetadata getLatestSchemaMetadata(String subject) throws IOException, RestClientException {
        int version = this.getLatestVersion(subject);
        return this.getSchemaMetadata(subject, version);
    }

    @Override
    public synchronized int getVersion(String subject, Schema schema) throws IOException, RestClientException {
        if (this.versionCache.containsKey(subject)) {
            return this.versionCache.get(subject).get(schema);
        }
        throw new IOException("Cannot get version from schema registry!");
    }

    @Override
    public boolean testCompatibility(String subject, Schema newSchema) throws IOException, RestClientException {
        AvroCompatibilityLevel compatibilityLevel;
        String compatibility = this.compatibilityCache.get(subject);
        if (compatibility == null) {
            compatibility = this.defaultCompatibility;
        }
        if ((compatibilityLevel = AvroCompatibilityLevel.forName(compatibility)) == null) {
            return false;
        }
        ArrayList<Schema> schemaHistory = new ArrayList<Schema>();
        for (int version : this.getAllVersions(subject)) {
            SchemaMetadata schemaMetadata = this.getSchemaMetadata(subject, version);
            schemaHistory.add(this.getSchemaBySubjectAndIdFromRegistry(subject, schemaMetadata.getId()));
        }
        return compatibilityLevel.compatibilityChecker.isCompatible(newSchema, schemaHistory);
    }

    @Override
    public String updateCompatibility(String subject, String compatibility) throws IOException, RestClientException {
        if (subject == null) {
            this.defaultCompatibility = compatibility;
            return compatibility;
        }
        this.compatibilityCache.put(subject, compatibility);
        return compatibility;
    }

    @Override
    public String getCompatibility(String subject) throws IOException, RestClientException {
        String compatibility = this.compatibilityCache.get(subject);
        if (compatibility == null) {
            compatibility = this.defaultCompatibility;
        }
        return compatibility;
    }

    @Override
    public Collection<String> getAllSubjects() throws IOException, RestClientException {
        ArrayList<String> results = new ArrayList<String>();
        results.addAll(this.schemaCache.keySet());
        Collections.sort(results, String.CASE_INSENSITIVE_ORDER);
        return results;
    }
}

