/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.maven;

import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.composite.MapConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.sisu.inject.Logs;

public class FixedMapConverter
extends MapConverter {
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Type[] typeArguments, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value = this.fromExpression(configuration, evaluator, type);
        if (null != value) {
            return value;
        }
        try {
            Map<Object, Object> map = this.instantiateMap(configuration, type, loader);
            Class<?> elementType = FixedMapConverter.findElementType(typeArguments);
            if (Object.class == elementType || String.class == elementType) {
                int size = configuration.getChildCount();
                for (int i = 0; i < size; ++i) {
                    PlexusConfiguration element = configuration.getChild(i);
                    map.put(element.getName(), this.fromExpression(element, evaluator));
                }
                return map;
            }
            ConfigurationConverter converter = lookup.lookupConverterForType(elementType);
            int size = configuration.getChildCount();
            for (int i = 0; i < size; ++i) {
                Object elementValue;
                PlexusConfiguration element = configuration.getChild(i);
                try {
                    elementValue = converter.fromConfiguration(lookup, element, elementType, enclosingType, loader, evaluator, listener);
                }
                catch (ComponentConfigurationException e) {
                    elementValue = this.fromExpression(element, evaluator);
                    Logs.warn((String)("Map in " + enclosingType + " declares value type as: {} but saw: {} at runtime"), elementType, null != elementValue ? elementValue.getClass() : null);
                }
                map.put(element.getName(), elementValue);
            }
            return map;
        }
        catch (ComponentConfigurationException e) {
            if (null == e.getFailedConfiguration()) {
                e.setFailedConfiguration(configuration);
            }
            throw e;
        }
    }

    private Map<Object, Object> instantiateMap(PlexusConfiguration configuration, Class<?> type, ClassLoader loader) throws ComponentConfigurationException {
        Class implType = this.getClassForImplementationHint(type, configuration, loader);
        if (null == implType || Modifier.isAbstract(implType.getModifiers())) {
            return new TreeMap<Object, Object>();
        }
        Object impl = this.instantiateObject(implType);
        return (Map)impl;
    }

    private static Class<?> findElementType(Type[] typeArguments) {
        if (null != typeArguments && typeArguments.length > 1) {
            if (typeArguments[1] instanceof Class) {
                return (Class)typeArguments[1];
            }
            if (typeArguments[1] instanceof ParameterizedType) {
                return (Class)((ParameterizedType)typeArguments[1]).getRawType();
            }
        }
        return Object.class;
    }
}

