/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.avro.AvroUtils;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class RestApiModeTest
extends ClusterTestHarness {
    private static String SCHEMA_STRING = AvroUtils.parseSchema((String)"{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}").canonicalString();

    public RestApiModeTest() {
        super(1, true, CompatibilityLevel.BACKWARD.name);
    }

    @Test
    public void testReadOnlyMode() throws Exception {
        String subject = "testSubject";
        String mode = "READONLY";
        Assert.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        try {
            this.restApp.restClient.registerSchema(SCHEMA_STRING, subject);
            Assert.fail((String)"Registering during read-only mode should fail");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Should get a constraint violation", (long)422L, (long)e.getStatus());
        }
    }

    @Test
    public void testReadWriteMode() throws Exception {
        String subject = "testSubject";
        String mode = "READWRITE";
        Assert.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        try {
            this.restApp.restClient.registerSchema(SCHEMA_STRING, subject, 1, 1);
            Assert.fail((String)"Registering an incompatible schema should fail");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Should get a constraint violation", (long)422L, (long)e.getStatus());
        }
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering without id should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject));
    }

    @Test
    public void testImportMode() throws Exception {
        String subject = "testSubject";
        String mode = "IMPORT";
        Assert.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering with id should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject, 1, expectedIdSchema1));
    }

    @Test
    public void testImportModeWithoutId() throws Exception {
        String subject = "testSubject";
        String mode = "IMPORT";
        Assert.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        try {
            this.restApp.restClient.registerSchema(SCHEMA_STRING, subject);
            Assert.fail((String)"Registering a schema without ID should fail");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Should get a constraint violation", (long)422L, (long)e.getStatus());
        }
    }

    @Test
    public void testInvalidImportMode() throws Exception {
        String subject = "testSubject";
        String mode = "IMPORT";
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering without id should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject));
        try {
            this.restApp.restClient.setMode(mode).getMode();
            Assert.fail((String)"Setting import mode should fail");
        }
        catch (RestClientException e) {
            Assert.assertEquals((String)"Should get a constraint violation", (long)422L, (long)e.getStatus());
        }
    }

    @Test
    public void testRegisterSchemaWithDifferentIdAfterImport() throws Exception {
        String subject = "testSubject";
        String mode = "READWRITE";
        Assert.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering without id should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject));
        this.restApp.restClient.deleteSubject(Collections.emptyMap(), subject);
        mode = "IMPORT";
        Assert.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        expectedIdSchema1 = 2;
        Assert.assertEquals((String)"Registering with id should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject, 1, expectedIdSchema1));
    }

    @Test
    public void testRegisterSchemaWithSameIdAfterImport() throws Exception {
        String subject = "testSubject";
        String mode = "READWRITE";
        Assert.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        int expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering without id should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject));
        this.restApp.restClient.deleteSubject(Collections.emptyMap(), subject);
        mode = "IMPORT";
        Assert.assertEquals((Object)mode, (Object)this.restApp.restClient.setMode(mode).getMode());
        expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering with id should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject, 1, expectedIdSchema1));
        this.restApp.restClient.deleteSubject(Collections.emptyMap(), subject);
        expectedIdSchema1 = 1;
        Assert.assertEquals((String)"Registering with id should succeed", (long)expectedIdSchema1, (long)this.restApp.restClient.registerSchema(SCHEMA_STRING, subject, 1, expectedIdSchema1));
        Assert.assertEquals((String)"Getting schema by id should succeed", (Object)SCHEMA_STRING, (Object)this.restApp.restClient.getVersion(subject, 1).getSchema());
    }
}

