/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.rest.RestConfigException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import kafka.cluster.Broker;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;

public class SchemaRegistryConfigTest {
    @Test
    public void testFilterBrokerEndpointsSinglePlaintext() {
        String endpoint = "PLAINTEXT://hostname:1234";
        ArrayList<String> endpointsList = new ArrayList<String>();
        endpointsList.add(endpoint);
        Assert.assertEquals((String)"Expected one PLAINTEXT endpoint for localhost", (Object)endpoint, (Object)SchemaRegistryConfig.endpointsToBootstrapServers(endpointsList, (String)SecurityProtocol.PLAINTEXT.toString()));
    }

    @Test(expected=ConfigException.class)
    public void testGetBrokerEndpointsEmpty() {
        SchemaRegistryConfig.endpointsToBootstrapServers(new ArrayList(), (String)SecurityProtocol.PLAINTEXT.toString());
    }

    @Test(expected=ConfigException.class)
    public void testGetBrokerEndpointsNoSecurityProtocolMatches() {
        SchemaRegistryConfig.endpointsToBootstrapServers(Collections.singletonList("SSL://localhost:1234"), (String)SecurityProtocol.PLAINTEXT.toString());
    }

    @Test(expected=ConfigException.class)
    public void testGetBrokerEndpointsUnsupportedSecurityProtocol() {
        SchemaRegistryConfig.endpointsToBootstrapServers(Collections.singletonList("TRACE://localhost:1234"), (String)"TRACE");
    }

    @Test
    public void testGetBrokerEndpointsMixed() throws IOException {
        ArrayList<String> endpointsList = new ArrayList<String>(4);
        endpointsList.add("PLAINTEXT://localhost0:1234");
        endpointsList.add("PLAINTEXT://localhost1:1234");
        endpointsList.add("SASL_PLAINTEXT://localhost1:1235");
        endpointsList.add("SSL://localhost1:1236");
        endpointsList.add("SASL_SSL://localhost2:1234");
        endpointsList.add("TRACE://localhost3:1234");
        Assert.assertEquals((Object)"PLAINTEXT://localhost0:1234,PLAINTEXT://localhost1:1234", (Object)SchemaRegistryConfig.endpointsToBootstrapServers(endpointsList, (String)SecurityProtocol.PLAINTEXT.toString()));
        Assert.assertEquals((Object)"SASL_PLAINTEXT://localhost1:1235", (Object)SchemaRegistryConfig.endpointsToBootstrapServers(endpointsList, (String)SecurityProtocol.SASL_PLAINTEXT.toString()));
        Assert.assertEquals((Object)"SSL://localhost1:1236", (Object)SchemaRegistryConfig.endpointsToBootstrapServers(endpointsList, (String)SecurityProtocol.SSL.toString()));
        Assert.assertEquals((Object)"SASL_SSL://localhost2:1234", (Object)SchemaRegistryConfig.endpointsToBootstrapServers(endpointsList, (String)SecurityProtocol.SASL_SSL.toString()));
        ArrayList<String> noprotocolEndpointsList = new ArrayList<String>();
        noprotocolEndpointsList.add("localhost0:1234");
        noprotocolEndpointsList.add("localhost1:1234");
        Assert.assertEquals((Object)"PLAINTEXT://localhost0:1234,PLAINTEXT://localhost1:1234", (Object)SchemaRegistryConfig.endpointsToBootstrapServers(noprotocolEndpointsList, (String)SecurityProtocol.PLAINTEXT.toString()));
    }

    @Test
    public void testBrokersToEndpoints() {
        ArrayList<Broker> brokersList = new ArrayList<Broker>(4);
        brokersList.add(new Broker(0, "localhost", 1, new ListenerName("CLIENT"), SecurityProtocol.PLAINTEXT));
        brokersList.add(new Broker(1, "localhost1", 12, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT));
        brokersList.add(new Broker(2, "localhost2", 123, new ListenerName("SECURE_REPLICATION"), SecurityProtocol.SASL_PLAINTEXT));
        brokersList.add(new Broker(2, "localhost2", 123, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT), SecurityProtocol.SASL_PLAINTEXT));
        brokersList.add(new Broker(3, "localhost3", 1234, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), SecurityProtocol.SSL));
        List endpointsList = SchemaRegistryConfig.brokersToEndpoints(brokersList);
        ArrayList<String> expected = new ArrayList<String>(4);
        expected.add("PLAINTEXT://localhost:1");
        expected.add("PLAINTEXT://localhost1:12");
        expected.add("SASL_PLAINTEXT://localhost2:123");
        expected.add("SASL_PLAINTEXT://localhost2:123");
        expected.add("SSL://localhost3:1234");
        Assert.assertEquals((String)"Expected the same size list.", (long)expected.size(), (long)endpointsList.size());
        for (int i = 0; i < endpointsList.size(); ++i) {
            Assert.assertEquals((String)"Expected a different endpoint", expected.get(i), endpointsList.get(i));
        }
    }

    @Test
    public void useDeprecatedInterInstanceProtocolIfDefined() throws RestConfigException {
        Properties props = new Properties();
        props.setProperty("schema.registry.inter.instance.protocol", "https");
        props.setProperty("inter.instance.protocol", "foo");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        Assert.assertEquals((Object)"https", (Object)config.interInstanceProtocol());
    }

    @Test
    public void unprefixedInterInstanceProtocol() throws RestConfigException {
        Properties props = new Properties();
        props.setProperty("inter.instance.protocol", "https");
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        Assert.assertEquals((Object)"https", (Object)config.interInstanceProtocol());
    }

    @Test
    public void defaultInterInstanceProtocol() throws RestConfigException {
        Properties props = new Properties();
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        Assert.assertEquals((Object)"http", (Object)config.interInstanceProtocol());
    }

    @Test
    public void defaultMutabilityMode() throws RestConfigException {
        Properties props = new Properties();
        SchemaRegistryConfig config = new SchemaRegistryConfig(props);
        Assert.assertEquals((Object)true, (Object)config.getBoolean("mode.mutability"));
    }
}

