/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.resources;

import io.confluent.kafka.schemaregistry.client.rest.entities.Mode;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeUpdateRequest;
import io.confluent.kafka.schemaregistry.exceptions.OperationNotPermittedException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryRequestForwardingException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.exceptions.UnknownLeaderException;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.rest.exceptions.RestInvalidModeException;
import io.confluent.kafka.schemaregistry.rest.resources.RequestHeaderBuilder;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Locale;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/mode")
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class ModeResource {
    private static final Logger log = LoggerFactory.getLogger(ModeResource.class);
    private final KafkaSchemaRegistry schemaRegistry;
    private final RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();

    public ModeResource(KafkaSchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    @Path(value="/{subject}")
    @PUT
    @ApiOperation(value="Update mode for the specified subject.")
    @ApiResponses(value={@ApiResponse(code=422, message="Error code 42204 -- Invalid mode\nError code 42205 -- Operation not permitted"), @ApiResponse(code=500, message="Error code 50001 -- Error in the backend data store\nError code 50003 -- Error while forwarding the request to the primary\nError code 50004 -- Unknown leader")})
    public ModeUpdateRequest updateMode(@ApiParam(value="Name of the Subject", required=true) @PathParam(value="subject") String subject, @Context HttpHeaders headers, @ApiParam(value="Update Request", required=true) @NotNull ModeUpdateRequest request, @QueryParam(value="force") boolean force) {
        io.confluent.kafka.schemaregistry.storage.Mode mode;
        subject = QualifiedSubject.normalize((String)this.schemaRegistry.tenant(), (String)subject);
        try {
            mode = Enum.valueOf(io.confluent.kafka.schemaregistry.storage.Mode.class, request.getMode().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new RestInvalidModeException();
        }
        try {
            Map<String, String> headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.schemaRegistry.config().whitelistHeaders());
            this.schemaRegistry.setModeOrForward(subject, mode, force, headerProperties);
        }
        catch (OperationNotPermittedException e) {
            throw Errors.operationNotPermittedException(e.getMessage());
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Failed to update mode", e);
        }
        catch (UnknownLeaderException e) {
            throw Errors.unknownLeaderException("Failed to update mode", e);
        }
        catch (SchemaRegistryRequestForwardingException e) {
            throw Errors.requestForwardingFailedException("Error while forwarding update mode request to the leader", e);
        }
        return request;
    }

    @Path(value="/{subject}")
    @GET
    @ApiOperation(value="Get mode for a subject.")
    @ApiResponses(value={@ApiResponse(code=404, message="Subject not found"), @ApiResponse(code=500, message="Error code 50001 -- Error in the backend data store")})
    public Mode getMode(@ApiParam(value="Name of the Subject", required=true) @PathParam(value="subject") String subject, @QueryParam(value="defaultToGlobal") boolean defaultToGlobal) {
        subject = QualifiedSubject.normalize((String)this.schemaRegistry.tenant(), (String)subject);
        try {
            io.confluent.kafka.schemaregistry.storage.Mode mode;
            io.confluent.kafka.schemaregistry.storage.Mode mode2 = mode = defaultToGlobal ? this.schemaRegistry.getModeInScope(subject) : this.schemaRegistry.getMode(subject);
            if (mode == null) {
                throw Errors.subjectLevelModeNotConfiguredException(subject);
            }
            return new Mode(mode.name());
        }
        catch (SchemaRegistryException e) {
            throw Errors.storeException("Failed to get mode", e);
        }
    }

    @PUT
    @ApiOperation(value="Update global mode.")
    @ApiResponses(value={@ApiResponse(code=422, message="Error code 42204 -- Invalid mode\nError code 42205 -- Operation not permitted"), @ApiResponse(code=500, message="Error code 50001 -- Error in the backend data store\nError code 50003 -- Error while forwarding the request to the primary\nError code 50004 -- Unknown leader")})
    public ModeUpdateRequest updateTopLevelMode(@Context HttpHeaders headers, @ApiParam(value="Update Request", required=true) @NotNull ModeUpdateRequest request, @QueryParam(value="force") boolean force) {
        return this.updateMode(null, headers, request, force);
    }

    @GET
    @ApiOperation(value="Get global mode.")
    @ApiResponses(value={@ApiResponse(code=500, message="Error code 50001 -- Error in the backend data store")})
    public Mode getTopLevelMode() {
        return this.getMode(null, false);
    }

    @DELETE
    @Path(value="/{subject}")
    @ApiOperation(value="Deletes the specified subject-level mode and revert to the global default.", response=io.confluent.kafka.schemaregistry.storage.Mode.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Error code 40401 -- Subject not found"), @ApiResponse(code=500, message="Error code 50001 -- Error in the backend datastore")})
    public void deleteSubjectMode(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @ApiParam(value="the name of the subject", required=true) @PathParam(value="subject") String subject) {
        Mode deleteModeResponse;
        log.info("Deleting mode for subject {}", (Object)subject);
        subject = QualifiedSubject.normalize((String)this.schemaRegistry.tenant(), (String)subject);
        try {
            io.confluent.kafka.schemaregistry.storage.Mode deletedMode = this.schemaRegistry.getMode(subject);
            if (deletedMode == null) {
                throw Errors.subjectNotFoundException(subject);
            }
            Map<String, String> headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.schemaRegistry.config().whitelistHeaders());
            this.schemaRegistry.deleteSubjectModeOrForward(subject, headerProperties);
            deleteModeResponse = new Mode(deletedMode.name());
        }
        catch (OperationNotPermittedException e) {
            throw Errors.operationNotPermittedException(e.getMessage());
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Failed to delete mode", e);
        }
        catch (UnknownLeaderException e) {
            throw Errors.unknownLeaderException("Failed to delete mode", e);
        }
        catch (SchemaRegistryRequestForwardingException e) {
            throw Errors.requestForwardingFailedException("Error while forwarding delete mode request to the leader", e);
        }
        asyncResponse.resume((Object)deleteModeResponse);
    }
}

