/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.resources;

import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.rest.annotations.PerformanceMetric;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/schemas")
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class SchemasResource {
    private static final Logger log = LoggerFactory.getLogger(SchemasResource.class);
    private final KafkaSchemaRegistry schemaRegistry;

    public SchemasResource(KafkaSchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    @GET
    @ApiOperation(value="Get the schemas.")
    @ApiResponses(value={@ApiResponse(code=500, message="Error code 50001 -- Error in the backend data store\n")})
    @PerformanceMetric(value="schemas.get-schemas")
    public List<Schema> getSchemas(@DefaultValue(value="") @QueryParam(value="subjectPrefix") String subjectPrefix, @DefaultValue(value="false") @QueryParam(value="deleted") boolean lookupDeletedSchema, @DefaultValue(value="false") @QueryParam(value="latestOnly") boolean latestOnly, @DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="-1") @QueryParam(value="limit") int limit) {
        Iterator<Schema> schemas = null;
        ArrayList<Schema> filteredSchemas = new ArrayList<Schema>();
        String errorMessage = "Error while getting schemas for prefix " + subjectPrefix;
        try {
            schemas = this.schemaRegistry.getVersionsWithSubjectPrefix(subjectPrefix, lookupDeletedSchema, latestOnly);
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        int fromIndex = offset;
        int toIndex = limit > 0 ? offset + limit : Integer.MAX_VALUE;
        for (int index = 0; schemas.hasNext() && index < toIndex; ++index) {
            Schema schema = schemas.next();
            if (index < offset) continue;
            filteredSchemas.add(schema);
        }
        return filteredSchemas;
    }

    @GET
    @Path(value="/ids/{id}")
    @ApiOperation(value="Get the schema string identified by the input ID.")
    @ApiResponses(value={@ApiResponse(code=404, message="Error code 40403 -- Schema not found\n"), @ApiResponse(code=500, message="Error code 50001 -- Error in the backend data store\n")})
    @PerformanceMetric(value="schemas.ids.get-schema")
    public SchemaString getSchema(@ApiParam(value="Globally unique identifier of the schema", required=true) @PathParam(value="id") Integer id, @QueryParam(value="subject") String subject, @DefaultValue(value="") @QueryParam(value="format") String format, @DefaultValue(value="false") @QueryParam(value="fetchMaxId") boolean fetchMaxId) {
        SchemaString schema = null;
        String errorMessage = "Error while retrieving schema with id " + id + " from the schema registry";
        try {
            schema = this.schemaRegistry.get(id, subject, format, fetchMaxId);
        }
        catch (SchemaRegistryStoreException e) {
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        if (schema == null) {
            throw Errors.schemaNotFoundException(id);
        }
        return schema;
    }

    @GET
    @Path(value="/ids/{id}/subjects")
    @ApiOperation(value="Get all the subjects associated with the input ID.")
    @ApiResponses(value={@ApiResponse(code=404, message="Error code 40403 -- Schema not found\n"), @ApiResponse(code=500, message="Error code 50001 -- Error in the backend data store\n")})
    public Set<String> getSubjects(@ApiParam(value="Globally unique identifier of the schema", required=true) @PathParam(value="id") Integer id, @QueryParam(value="subject") String subject, @QueryParam(value="deleted") boolean lookupDeletedSchema) {
        Set<String> subjects;
        String errorMessage = "Error while retrieving all subjects associated with schema id " + id + " from the schema registry";
        try {
            subjects = this.schemaRegistry.listSubjectsForId(id, subject, lookupDeletedSchema);
        }
        catch (SchemaRegistryStoreException e) {
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        if (subjects == null) {
            throw Errors.schemaNotFoundException();
        }
        return subjects;
    }

    @GET
    @Path(value="/ids/{id}/versions")
    @ApiOperation(value="Get all the subject-version pairs associated with the input ID.")
    @ApiResponses(value={@ApiResponse(code=404, message="Error code 40403 -- Schema not found\n"), @ApiResponse(code=500, message="Error code 50001 -- Error in the backend data store\n")})
    public List<SubjectVersion> getVersions(@ApiParam(value="Globally unique identifier of the schema", required=true) @PathParam(value="id") Integer id, @QueryParam(value="subject") String subject, @QueryParam(value="deleted") boolean lookupDeletedSchema) {
        List<SubjectVersion> versions;
        String errorMessage = "Error while retrieving all subjects associated with schema id " + id + " from the schema registry";
        try {
            versions = this.schemaRegistry.listVersionsForId(id, subject, lookupDeletedSchema);
        }
        catch (SchemaRegistryStoreException e) {
            log.debug(errorMessage, (Throwable)e);
            throw Errors.storeException(errorMessage, e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException(errorMessage, e);
        }
        if (versions == null) {
            throw Errors.schemaNotFoundException();
        }
        return versions;
    }

    @GET
    @Path(value="/types")
    @ApiOperation(value="Get the schema types supported by this registry.")
    @ApiResponses(value={@ApiResponse(code=500, message="Error code 50001 -- Error in the backend data store\n")})
    public Set<String> getSchemaTypes() {
        return this.schemaRegistry.schemaTypes();
    }
}

