/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.storage.ConfigKey;
import io.confluent.kafka.schemaregistry.storage.SubjectValue;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ConfigValue
extends SubjectValue {
    private CompatibilityLevel compatibilityLevel;

    public ConfigValue(@JsonProperty(value="subject") String subject, @JsonProperty(value="compatibilityLevel") CompatibilityLevel compatibilityLevel) {
        super(subject);
        this.compatibilityLevel = compatibilityLevel;
    }

    public ConfigValue() {
        super(null);
        this.compatibilityLevel = null;
    }

    @JsonProperty(value="compatibilityLevel")
    public CompatibilityLevel getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    @JsonProperty(value="compatibilityLevel")
    public void setCompatibilityLevel(CompatibilityLevel compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigValue that = (ConfigValue)o;
        return this.compatibilityLevel.equals((Object)that.compatibilityLevel);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.compatibilityLevel.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{compatibilityLevel=" + this.compatibilityLevel + "}");
        return sb.toString();
    }

    @Override
    public ConfigKey toKey() {
        return new ConfigKey(this.getSubject());
    }
}

