/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest;

import com.google.common.collect.ImmutableList;
import io.confluent.kafka.schemaregistry.ClusterTestHarness;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.utils.TestUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class RestApiContextTest
extends ClusterTestHarness {
    public RestApiContextTest() {
        super(1, true);
    }

    @Test
    public void testQualifiedSubjects() throws Exception {
        int i;
        String subject1 = ":.ctx1:testTopic1";
        String subject2 = ":.ctx2:testTopic2";
        int schemasInSubject1 = 10;
        ArrayList<Integer> allVersionsInSubject1 = new ArrayList<Integer>();
        List<String> allSchemasInSubject1 = TestUtils.getRandomCanonicalAvroString(schemasInSubject1);
        int schemasInSubject2 = 5;
        ArrayList<Integer> allVersionsInSubject2 = new ArrayList<Integer>();
        List<String> allSchemasInSubject2 = TestUtils.getRandomCanonicalAvroString(schemasInSubject2);
        try {
            this.restApp.restClient.getAllVersions(subject1);
            Assert.fail((String)"Getting all versions from non-existing subject1 should fail with 40401 (subject not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Should get a 404 status for non-existing subject", (long)40401L, (long)rce.getErrorCode());
        }
        Assert.assertEquals((String)"Getting all subjects should return default context", Collections.singletonList("."), (Object)this.restApp.restClient.getAllContexts());
        Assert.assertEquals((String)"Getting all subjects should return empty", Collections.emptyList(), (Object)this.restApp.restClient.getAllSubjects());
        int schemaIdCounter = 1;
        for (i = 0; i < schemasInSubject1; ++i) {
            String schema = allSchemasInSubject1.get(i);
            int expectedVersion = i + 1;
            RestApiContextTest.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter, subject1);
            ++schemaIdCounter;
            allVersionsInSubject1.add(expectedVersion);
        }
        for (i = 0; i < schemasInSubject1; ++i) {
            int expectedId = i + 1;
            String schemaString = allSchemasInSubject1.get(i);
            int foundId = this.restApp.restClient.registerSchema(schemaString, subject1);
            Assert.assertEquals((String)"Re-registering an existing schema should return the existing version", (long)expectedId, (long)foundId);
        }
        schemaIdCounter = 1;
        for (i = 0; i < schemasInSubject2; ++i) {
            String schema = allSchemasInSubject2.get(i);
            int expectedVersion = i + 1;
            RestApiContextTest.registerAndVerifySchema(this.restApp.restClient, schema, schemaIdCounter, subject2);
            ++schemaIdCounter;
            allVersionsInSubject2.add(expectedVersion);
        }
        Assert.assertEquals((String)"Getting all versions from subject1 should match all registered versions", allVersionsInSubject1, (Object)this.restApp.restClient.getAllVersions(subject1));
        Assert.assertEquals((String)"Getting all versions from subject2 should match all registered versions", allVersionsInSubject2, (Object)this.restApp.restClient.getAllVersions(subject2));
        Assert.assertEquals((String)"Getting all contexts should return all registered contexts", (Object)ImmutableList.of((Object)".", (Object)".ctx1", (Object)".ctx2"), (Object)this.restApp.restClient.getAllContexts());
        Assert.assertEquals((String)"Getting all subjects should match all registered subjects", Collections.singletonList(subject1), (Object)this.restApp.restClient.getAllSubjects(":.ctx1:", false));
        Assert.assertEquals((String)"Getting all subjects should match all registered subjects", Collections.singletonList(subject2), (Object)this.restApp.restClient.getAllSubjects(":.ctx2:", false));
        Assert.assertEquals((String)"Getting all subjects should match no registered subjects", Collections.emptyList(), (Object)this.restApp.restClient.getAllSubjects("", false));
        Assert.assertEquals((String)"Getting all subjects should match all registered subjects", (Object)ImmutableList.of((Object)subject1, (Object)subject2), (Object)this.restApp.restClient.getAllSubjects(":*:", false));
        Assert.assertEquals((String)"Getting all schemas should match all registered subjects", (long)(schemasInSubject1 + schemasInSubject2), (long)this.restApp.restClient.getSchemas(":*:", false, false).size());
        Schema schema = this.restApp.restClient.getVersion("testTopic1", 1);
        Assert.assertEquals((String)"Getting schema by version w/o context should succeed", (long)1L, (long)schema.getVersion().intValue());
        schema = this.restApp.restClient.lookUpSubjectVersion(schema.getSchema(), "testTopic1");
        Assert.assertEquals((String)"Getting schema by schema w/o context should succeed", (long)1L, (long)schema.getVersion().intValue());
    }

    @Test
    public void testContextPaths() throws Exception {
        int i;
        RestService restClient1 = new RestService(this.restApp.restConnect + "/contexts/.ctx1");
        RestService restClient2 = new RestService(this.restApp.restConnect + "/contexts/.ctx2");
        RestService restClient3 = new RestService(this.restApp.restConnect + "/contexts/:.:");
        RestService noCtxRestClient3 = new RestService(this.restApp.restConnect);
        String subject1 = "testTopic1";
        String subject2 = "testTopic2";
        String subject3 = "testTopic3";
        int schemasInSubject1 = 10;
        ArrayList<Integer> allVersionsInSubject1 = new ArrayList<Integer>();
        List<String> allSchemasInSubject1 = TestUtils.getRandomCanonicalAvroString(schemasInSubject1);
        int schemasInSubject2 = 5;
        ArrayList<Integer> allVersionsInSubject2 = new ArrayList<Integer>();
        List<String> allSchemasInSubject2 = TestUtils.getRandomCanonicalAvroString(schemasInSubject2);
        int schemasInSubject3 = 2;
        ArrayList<Integer> allVersionsInSubject3 = new ArrayList<Integer>();
        List<String> allSchemasInSubject3 = TestUtils.getRandomCanonicalAvroString(schemasInSubject3);
        try {
            restClient1.getAllVersions(subject1);
            Assert.fail((String)"Getting all versions from non-existing subject1 should fail with 40401 (subject not found)");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Should get a 404 status for non-existing subject", (long)40401L, (long)rce.getErrorCode());
        }
        int schemaIdCounter = 1;
        for (i = 0; i < schemasInSubject1; ++i) {
            String schema = allSchemasInSubject1.get(i);
            int expectedVersion = i + 1;
            RestApiContextTest.registerAndVerifySchema(restClient1, schema, schemaIdCounter, subject1);
            ++schemaIdCounter;
            allVersionsInSubject1.add(expectedVersion);
        }
        for (i = 0; i < schemasInSubject1; ++i) {
            int expectedId = i + 1;
            String schemaString = allSchemasInSubject1.get(i);
            int foundId = restClient1.registerSchema(schemaString, subject1);
            Assert.assertEquals((String)"Re-registering an existing schema should return the existing version", (long)expectedId, (long)foundId);
        }
        schemaIdCounter = 1;
        for (i = 0; i < schemasInSubject2; ++i) {
            String schema = allSchemasInSubject2.get(i);
            int expectedVersion = i + 1;
            RestApiContextTest.registerAndVerifySchema(restClient2, schema, schemaIdCounter, subject2);
            ++schemaIdCounter;
            allVersionsInSubject2.add(expectedVersion);
        }
        schemaIdCounter = 1;
        try {
            restClient3.getId(schemaIdCounter);
            Assert.fail((String)"Registered schema should not be found in default context");
        }
        catch (RestClientException rce) {
            Assert.assertEquals((String)"Should get a 404 status for non-existing schema", (long)40403L, (long)rce.getErrorCode());
        }
        for (int i2 = 0; i2 < schemasInSubject3; ++i2) {
            String schema = allSchemasInSubject3.get(i2);
            int expectedVersion = i2 + 1;
            RestApiContextTest.registerAndVerifySchema(restClient3, schema, schemaIdCounter, subject3);
            ++schemaIdCounter;
            allVersionsInSubject3.add(expectedVersion);
        }
        Assert.assertEquals((String)"Getting all versions from subject1 should match all registered versions", allVersionsInSubject1, (Object)restClient1.getAllVersions(subject1));
        Assert.assertEquals((String)"Getting all versions from subject2 should match all registered versions", allVersionsInSubject2, (Object)restClient2.getAllVersions(subject2));
        Assert.assertEquals((String)"Getting all versions from subject3 should match all registered versions", allVersionsInSubject3, (Object)restClient3.getAllVersions(subject3));
        Assert.assertEquals((String)"Getting all versions from subject3 should match all registered versions", allVersionsInSubject3, (Object)noCtxRestClient3.getAllVersions(subject3));
        Assert.assertEquals((String)"Getting all versions from subject3 should match all registered versions", allVersionsInSubject3, (Object)noCtxRestClient3.getAllVersions(":.:" + subject3));
        Assert.assertEquals((String)"Getting all contexts should return all registered contexts", (Object)ImmutableList.of((Object)".", (Object)".ctx1", (Object)".ctx2"), (Object)restClient1.getAllContexts());
        Assert.assertEquals((String)"Getting all subjects should match all registered subjects", Collections.singletonList(":.ctx1:" + subject1), (Object)restClient1.getAllSubjects());
        Assert.assertEquals((String)"Getting all subjects should match all registered subjects", Collections.singletonList(":.ctx2:" + subject2), (Object)restClient2.getAllSubjects());
        Assert.assertEquals((String)"Getting all subjects should match all registered subjects", Collections.singletonList(subject3), (Object)restClient3.getAllSubjects());
        Assert.assertEquals((String)"Getting all subjects should match all registered subjects", Collections.singletonList(subject3), (Object)noCtxRestClient3.getAllSubjects("", false));
    }

    static void registerAndVerifySchema(RestService restService, String schemaString, int expectedId, String subject) throws IOException, RestClientException {
        int registeredId = restService.registerSchema(schemaString, subject);
        Assert.assertEquals((String)"Registering a new schema should succeed", (long)expectedId, (long)registeredId);
        Assert.assertEquals((String)"Registered schema should be found", (Object)schemaString, (Object)restService.getId(expectedId, subject).getSchemaString());
    }
}

